#include "kadm_locl.h"

RCSID("$Id: pw_check.c,v 1.5 1996/02/07 11:00:15 bg Exp $");

/*
 * kadm_pw_check
 *
 * pw		: new password or "" if none passed
 * newkey	: key for pw as passed from client
 * strings	: interesting strings to check for
 *
 * returns NULL if pw is ok, else an explanatory string
 */
int
kadm_pw_check(char *pw, des_cblock *newkey, char **pw_msg, 
	      char **strings)
{
  des_cblock pwkey;
  int status=KADM_SUCCESS;
  
#ifndef NO_PW_CHECK
  *pw_msg = NULL;
  des_string_to_key(pw, &pwkey);
  if(memcmp(pwkey, *newkey, sizeof(pwkey))){
    /* no password or bad key */
    status=KADM_PW_MISMATCH;
  } else if(strlen(pw) < MIN_KPW_LEN){
    status = KADM_INSECURE_PW;
    *pw_msg="Password is too short";
  }
  
#ifdef DICTPATH
  *pw_msg = FascistCheck(pw, DICTPATH, strings);
  if(*pw_msg)
    return KADM_INSECURE_PW;
#endif

  bzero(pwkey, sizeof(pwkey));
#endif

  return status;
}
