#include <memory.h>
#define bcopy(f,t,n)    memcpy((t), (f), (n))
#define bzero(s,n)      memset((s), 0, (n))
#define bcmp(a,b,n)     memcmp((a), (b), (n))

/*
 * Functions that dont have a prototype on your system.
 */

#if defined(__GNUC__) && defined(sun) && !defined(__svr4__) /* not solaris */

/* To get type fd_set */
#include <sys/types.h>
#include <sys/time.h>

/* To get struct in_addr */
#include <netinet/in.h>

int gethostname(char *, int);

void swab(const char *, char *, int);
int flock(int, int);
int atoi(const char *str);
int fsync(int);
int seteuid(uid_t);
int setreuid(int, int);
int socket(int, int, int);
int setsockopt(int, int, int, void *, int);
struct sockaddr;
int bind(int, void *, int);
int getsockname(int, struct sockaddr *, int *);
int accept(int, struct sockaddr *, int *);
int connect(int, struct sockaddr *, int);
int listen(int, int);
int recvfrom(int, char *, int, int, void *, int *);
int sendto(int, const char *, int, int, void *, int);

struct stat;
int lstat(const char *, struct stat *);
int strcasecmp(const char *, const char *);

int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
int gettimeofday(struct timeval *tp, struct timezone *tzp);
struct utimbuf;
int utime(const char *, struct utimbuf *);

char *inet_ntoa(struct in_addr in);

int sigblock(int);
int sigsetmask(int);

char *mktemp(char *);
void srandom(int seed);
int random(void);

int shutdown(int, int);
int ioctl(int, int, void *); 
int rcmd(char **, unsigned short, char *, char *, char *, int *);
int rresvport(int *);
int getpeername(int, struct sockaddr *, int *);
int getsockopt(int, int, int, char *, int *);

int ftruncate(int, off_t);
int fchmod(int, mode_t);


#endif /* defined(__GNUC__) && defined(sun) */

#if defined(__GNUC__) && defined(sun) && defined(__svr4__) /* solaris */

/* include this in a xxx_locl.h file #include <sys/filio.h> */

#endif

#if defined(__GNUC__) && defined(__osf__)

/* To get type fd_set */
#include <sys/types.h>
#include <sys/time.h>

int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
int flock(int fildes, int operation);
int fsync(int fildes);
/* int setreuid(int ruid, int euid); */
int gethostname(char *address, int address_len);
int gethostid(void);
int ioctl(int d, unsigned long request, void * arg);

unsigned short htons(unsigned short hostshort);
unsigned int   htonl(unsigned int hostint);
unsigned short ntohs(unsigned short netshort);
unsigned int   ntohl(unsigned int netint);

char *mktemp(char *template);
/* char *crypt(char *key, char *salt); */

#endif /* defined(__GNUC__) && defined(__osf__) */

#if defined(__GNUC__) && defined(__sgi__)

char *crypt(const char *key, const char *salt);

#endif /* defined(__GNUC__) && defined(__sgi__) */

#if defined(__GNUC__) && defined(_AIX)

char *crypt (char *PW, char *Salt);

struct timeval;
struct timezone;
int gettimeofday (struct timeval *Tp, struct timezone *Tzp);

#endif /* defined(__GNUC__) && defined(__sgi__) */
