.\" $Source: /mit/krb5/.cvsroot/src/appl/bsd/rlogin.M,v $
.\" $Author: nlgilman $
.\" $Header: /mit/krb5/.cvsroot/src/appl/bsd/rlogin.M,v 5.1 1994/06/14 20:32:39 nlgilman Exp $
.\"
.\" Copyright (c) 1983 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)rlogin.1	6.9 (Berkeley) 9/19/88
.\"
.TH RLOGIN 1 "Kerberos Version 5.0" "MIT Project Athena"
.SH NAME
rlogin \- remote login
.SH SYNOPSIS
.B rlogin
rhost [
\fB\-e\fR\fI\|c\fR
] [
.B \-8
] [
.B \-c
] [
.B \-a
] [
.B \-t
termtype ] [
.B \-n
] [
.B \-7
] [
.B \-d
] [
.B \-k
realm ] [
.B \-x
] [
.B \-noflow
] [
.B \-L
] [
.B \-l
username ]
.br
rhost [
\fB\-e\fR\fIc\fR
] [
.B \-8
] [
.B \-c
] [
.B \-a
] [
.B \-t
termtype ] [
.B \-n
] [
.B \-7
] [
.B \-d
] [
.B \-k
realm ] [
.B \-x
] [
.B \-noflow
] [
.B \-L
] [
.B \-l
username ]
.SH DESCRIPTION
.I Rlogin
connects your terminal on the current local host system
.I lhost
to the remote host system
.I rhost.
.PP
The version built to use Kerberos authentication is very similar to the
standard Berkeley rlogin(1), except that instead of the \fIrhosts\fP
mechanism, it uses Kerberos authentication to determine the
authorization to use a remote account.
.PP
Each user may have a private authorization list in a file \&.k5login
in his login directory.  Each line in this file should contain a
Kerberos principal name of the form 
.IR principal/instance@realm .
If the originating user is authenticated to one of the principals named
in \&.k5login, access is granted to the account.  If there is no
/.k5login file, the principal will be granted access 
to the account according to the aname\->lname mapping rules (see
.IR krb5_anadd(8) 
for more details) 
Otherwise
a login and password will be prompted for on the remote machine as in
.IR login (1).
To avoid some security problems, the \&.k5login file must be owned by
the remote user.
.PP
If there is some problem in marshaling the Kerberos authentication
information, an error message is printed and the standard UCB rlogin is
executed in place of the Kerberos rlogin.
.PP
A line of the form ``~.'' disconnects from the remote host, where
``~'' is the escape character.
Similarly, the line ``~^Z'' (where ^Z, control-Z, is the suspend character)
will suspend the rlogin session.
Substitution of the delayed-suspend character (normally ^Y)
for the suspend character suspends the send portion of the rlogin,
but allows output from the remote system.
.PP
The remote terminal type is the same as your local
terminal type (as given in your environment TERM variable), unless the
.B \-t
option is specified (see below).
The terminal or window size is also copied to the remote system
if the server supports the option,
and changes in size are reflected as well.
.PP
All echoing takes place at the remote site, so that (except for
delays) the rlogin is transparent.  Flow control via ^S and ^Q and
flushing of input and output on interrupts are handled properly.
.PP
The
.B \-8
option allows an eight-bit input data path at all times;
otherwise parity bits are stripped except when the remote side's
stop and start characters are other than ^S/^Q. Eight-bit mode is the default.
.PP
The
.B \-L
option allows the rlogin session to be run in litout mode.
.PP
The
.B \-e
option allows specification of a different escape character.
There is no space separating this option flag and the new escape
character.
.PP
The
.B \-c
option requires confirmation before disconnecting via ``~.''
.PP
The
.B \-a
option forces the remote machine to ask for a password by sending a null local
username.  This option has no effect unless the standard UCB rlogin is
executed in place of the Kerberos rlogin (see above).
.PP
The
.B \-t
option replaces the terminal type passed to the remote host with
\fItermtype\fP.
.PP
The
.B \-n
option prevents suspension of rlogin via ``~^Z'' or ``~^Y''.
.PP
The
.B \-7
option forces seven-bit transmissions.
.PP
The
.B \-d
option turns on socket debugging (via \fIsetsockopt(2)\fR) on the TCP
sockets used for communication with the remote host.
.PP
The
.B \-noflow
option forces transmission of flow control characters (^S/^Q) to the
remote system.
.PP
The
.B \-k
option requests rlogin to obtain tickets for the remote host in realm
.I realm
instead of the remote host's realm as determined by 
.IR krb_realmofhost (3).
.PP
The
.B \-x
option turns on DES encryption for all data passed via the
rlogin session.  This significantly reduces response time and
significantly increases CPU utilization.
.SH SEE ALSO
rsh(1), kerberos(3), krb_sendauth(3), krb_realmofhost(3),
rlogin(1) [UCB version]
.SH FILES
/usr/hosts/*		for \fIrhost\fP version of the command
.br
\&.k5login		in the user's home directory
.SH BUGS
More of the environment should be propagated.
