.\" $Source: /mit/krb5/.cvsroot/src/appl/bsd/rcp.M,v $
.\" $Author: eichin $
.\" $Header: /mit/krb5/.cvsroot/src/appl/bsd/rcp.M,v 5.2 1995/04/21 21:15:52 eichin Exp $
.\"
.\" Copyright (c) 1983 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)rcp.1	6.6 (Berkeley) 9/20/88
.\"
.TH RCP 1 "Kerberos Version 5.0" "MIT Project Athena"
.SH NAME
rcp \- remote file copy
.SH SYNOPSIS
.B rcp
[
.B \-p
] [
.B \-x
] [
.B \-k
realm ] [
.B \-D
port ] [
.B \-N
] file1 file2
.br
.B rcp
[
.B \-p
] [
.B \-x
] [
.B \-k
realm ] [
.B \-r
] [
.B \-D
port ] [
.B \-N
] file ... directory
.SH DESCRIPTION
.I Rcp
copies files between machines.  Each
.I file
or
.I directory
argument is either a remote file name of the
form ``rhost:path'', or a local file name (containing no `:' characters,
or a `/' before any `:'s).
.PP
If the
.B \-r
option
is specified and any of the source files are directories,
.I rcp
copies each subtree rooted at that name; in this case
the destination must be a directory.
.PP
By default, the mode and owner of
.I file2
are preserved if it already existed; otherwise the mode of the source file
modified by the
.IR umask (2)
on the destination host is used.
The
.B \-p
option causes
.I rcp
to attempt to preserve (duplicate) in its copies the modification
times and modes of the source files, ignoring the
.IR umask .
.PP
If
.I path
is not a full path name, it is interpreted relative to
your login directory on 
.IR rhost .
A 
.I path
on a remote host may be quoted (using \e, ", or \(aa)
so that the metacharacters are interpreted remotely.
.PP
.I Rcp
does not prompt for passwords; it uses Kerberos authentication when
connecting to
.IR rhost .
Each user may have a private authorization list in a file \&.k5login
in his login directory.  Each line in this file should contain a
Kerberos principal name of the form 
.IR principal/instance@realm .
If there is a ~/.k5login file, then access is granted to the account if
and only if the originater user is authenticated to one of the
princiapls named in the ~/.k5login file.  Otherwise, the originating
user will be granted access to the account if and only if the
authenticated principal name of the user can be mapped to the local
account name using the aname -> lname mapping rules (see \fIkrb5_anadd(8)\fP
for more details).
.PP
The
.B \-x
option selects encryption of all information transferring between hosts.
The
.B \-k
.I realm
option causes 
.I rcp
to obtain tickets for the remote host in
.I realm
instead of the remote host's realm as determined by
.IR krb_realmofhost (3).
.PP
The
.B \-D
option specifies the port to connect to on the remote machine.  The
.B \-N
option tells rcp to use a network connection even when copying files
on the local machine.  These options are used for testing purposes.
.PP
.I Rcp
handles third party copies, where neither source nor target files
are on the current machine.
Hostnames may also take the form ``rname@rhost'' to use
.I rname
rather than the current user name on the remote host.
.SH SEE ALSO
cp(1), ftp(1), rsh(1), rlogin(1), kerberos(3), krb_getrealm(3),
rcp(1) [UCB version]
.SH BUGS
Doesn't detect all cases where the target of a copy might
be a file in cases where only a directory should be legal.
.PP
Is confused by any output generated by commands in a
\&.login, \&.profile, or \&.cshrc file on the remote host.
.PP
Kerberos is only used for the first connection of a third-party copy;
the second connection uses the standard Berkeley rcp protocol.

