.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KRB_PRIV_spec.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KRB_PRIV_spec.ms,v 1.24 90/12/19 17:06:28 jtkohl Exp $
.\"
.ds R# "$Id: KRB_PRIV_spec.ms,v 1.24 90/12/19 17:06:28 jtkohl Exp $
.N: sec 2 foo333 "KRB_PRIV message specification"
.PP
This section specifies the format of a message that can be used by
either side (client or server) of an
application to securely and privately send a message to its peer.  It presumes that a
session key has previously been exchanged (for example, by using the
KRB_AP_REQ/KRB_AP_REP messages).
.N: sec 3 krb_priv_def "KRB_PRIV definition"
.PP
The KRB_PRIV message contains user data encrypted in the Session Key.
The message fields are:
.KS
.TS
center;
lb l l.
KRB-PRIV ::=	[APPLICATION 21] SEQUENCE {
	pvno[0]	INTEGER,
	msg-type[1]	INTEGER,
	enc-part[3]	EncryptedData	-- EncKrbPrivPart
}
.sp
EncKrbPrivPart ::=	[APPLICATION 28\(dg] SEQUENCE {
	user-data[0]	OCTET STRING,
	timestamp[1]	KerberosTime OPTIONAL,
	usec[2]	INTEGER OPTIONAL,
	seq-number[3]	INTEGER OPTIONAL,
	s-address[4]	HostAddress, -- sender's addr
	r-address[5]	HostAddress OPTIONAL -- recip's addr
}
.TE
.FS \(dg
An application code in the encrypted part of a
message provides an additional check that the message was decrypted
properly.
.FE
.KE

.IP "\fBpvno\fP and \fBmsg-type\fP" 10
.br
These fields are described above in section ~sec kdc_req_def~.
\fBmsg-type\fP is KRB_PRIV.

.IP \fBenc-part\fP 10
This field holds an encoding of the \fBEncKrbPrivPart\fP sequence
encrypted under the session key\**.
.FS 
If supported by the encryption method in use, an
initialization vector may be passed to the encryption procedure, in
order to achieve proper cipher chaining.
The initialization vector might come from the last block of the
ciphertext from the previous KRB_PRIV message, but it is the
application's choice whether or not to use such an initialization vector.
If left out, the default initialization vector for the
encryption algorithm will be used.
.FE
This encrypted encoding is used for the \fBenc-part\fP
field of the KRB-PRIV message.  See section ~sec enc_spec~ for the
format of the ciphertext.

.IP "\fBuser-data, timestamp, usec, s-address\fP and \fBr-address\fP" 10
.br
These fields are described above in section ~sec krb_safe_def~.

.IP \fBseq-number\fP 10
.br
This field is described above in section ~sec auth_def~.
