.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KRB_PRIV.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KRB_PRIV.ms,v 1.25 90/12/19 17:06:27 jtkohl Exp $
.\"
.ds R# "$Id: KRB_PRIV.ms,v 1.25 90/12/19 17:06:27 jtkohl Exp $
.N: sec 2 krb_priv "The KRB_PRIV Exchange"
.PP
The KRB_PRIV message may be used by clients requiring confidentiality
and the ability to detect modifications of exchanged messages.  It
achieves this by encrypting the messages and adding control information.
.N: sec 3 foo42 "Generation of a KRB_PRIV message"
.LP
When an application wishes to send a KRB_PRIV message, it collects its data
and the appropriate control information (specified in section ~sec
krb_priv_def~) and encrypts 
them under an encryption key (usually the last key negotiated via
subkeys, or the session key if no negotiation has occured).
As part of the control information, the client must choose to use either
a timestamp or a sequence number (or both); see the discussion in
section ~sec generate_krb_safe~ for guidelines on which to use.
After the user data and control information are encrypted, the client
transmits the ciphertext and some "envelope" information to the recipient.
.N: sec 3 foo43 "Receipt of KRB_PRIV message"
.LP
When an application receives a KRB_PRIV message, it verifies it as
follows.  If any error occurs, an error code is reported for use by the
application.
.PP
The message is first checked by verifying
that the protocol version and type fields match the current version and
KRB_PRIV, respectively.  A mismatch generates a KRB_AP_ERR_BADVERSION or
KRB_AP_ERR_MSG_TYPE error.
The application then decrypts the ciphertext and processes the resultant
plaintext.
If decryption shows the data to have been modified, a
KRB_AP_ERR_BAD_INTEGRITY error is generated.
The recipient verifies that the operating system's report of the
sender's address matches the sender's address in the message, and (if a
recipient address is specified or the recipient requires an address) that
one of the recipient's addresses appears as the recipient's address in
the message.  A failed match for either case generates a
KRB_AP_ERR_BADADDR error.
Then the timestamp and usec and/or the sequence number fields are
checked.  If timestamp and usec are expected and not present, or they
are present but not
current, the KRB_AP_ERR_SKEW error is generated. If the server name,
along with the client name, time and microsecond
fields from the Authenticator match any recently-seen such tuples,
the KRB_AP_ERR_REPEAT error is generated.  If an incorrect
sequence number is included, or a sequence number is expected but not
present, the KRB_AP_ERR_BADORDER error is generated.
If neither a timestamp and usec or a sequence number is present, a
KRB_AP_ERR_MODIFIED error is generated.
Finally, the checksum is computed over the data and control information,
and if it doesn't match the received checksum, a KRB_AP_ERR_MODIFIED error is
generated.
.PP
If all the checks succeed, the application can assume the message was
generated by its peer, and was securely transmitted (without intruders
able to see the unencrypted contents).
