.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/DB.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/DB.ms,v 1.33 91/02/18 11:44:31 jtkohl Exp $
.\"
.ds R# "$Id: DB.ms,v 1.33 91/02/18 11:44:31 jtkohl Exp $
.N: sec 1 db_spec "The Kerberos Database"
.LP
The Kerberos server must have access to a database
containing the principal identifiers and secret keys of principals
to be authenticated\**.
.FS
The implementation of the Kerberos
server need not combine the database and the server on the same machine;
it is feasible to store the principal database in, say, a network name
service, as long as the entries stored therein are
protected from disclosure to and modification by unauthorized parties.
However, we recommend against such strategies, as they can make system
management and threat analysis quite complex.
.FE
.N: sec 2 foo23 "Database contents"
.LP
A database entry should contain at least the following
fields:
.TS
l l.
.KS
\fIField	Value\fP
.sp
name	Principal's identifier
.KE
key	Principal's secret key
p_kvno	Principal's key version
max_life	Maximum lifetime for Tickets
max_renewable_life	Maximum total lifetime for renewable Tickets
.TE
.de B
\\fB\\$1\\fP
..
The
.B name
field is an encoding of the principal's identifier.
The
.B key
field contains an encryption key.
This key is the principal's secret key.
(The key can be encrypted before storage under a Kerberos "master key"
to protect
it in case the database is compromised but the master key is
not.  In that case, an extra field must be added to indicate the master
key version used, see below.)
The
.B p_kvno
field is the key version number of the principal's
secret key.
The
.B max_life
field contains the maximum allowable lifetime (endtime -
starttime) for any
Ticket issued for this principal.
The
.B max_renewable_life
field contains the maximum allowable total
lifetime for any renewable Ticket issued for this principal.
(See section ~sec as~ for a description of how these lifetimes are
used in determining the lifetime of a given Ticket.)
.PP
A server may provide KDC service to several realms, as long as the
database representation provides a mechanism to distinguish between
principal records with identifiers which differ only in the realm name.
.PP
When an application server's key changes, if the change is routine (i.e. not the
result of disclosure of the old key), the old key should be retained by
the server
until all tickets that had been issued using that key have expired.
Because of this, it is possible for several keys to be active for a
single principal.  Ciphertext encrypted in a principal's key is
always tagged with the version of the key that was used for
encryption, to help the recipient find the proper key for decryption.
.PP
When more than one key is active for a particular principal, the
principal will have more than one record in the Kerberos database.
The keys and key version numbers will differ between the records (the
rest of the fields may or may not be the same). 
Whenever Kerberos issues a ticket, or responds to a request for initial
authentication, the most recent key (known by the Kerberos server)
will be used for encryption.  This is the key with the highest key
version number.
.N: sec 2 foo24 "Additional fields"
.LP
Project Athena's KDC implementation uses 
additional fields in its database:
.TS
l l.
\fIField	Value\fP

K_kvno	Kerberos' key version
expiration	Expiration date for entry
attributes	Bit field of attributes
mod_date	Timestamp of last modification
mod_name	Modifying principal's identifier
.TE
.LP
The
.B K_kvno
field indicates
the key version of the Kerberos master key under which the
principal's secret key is encrypted.
.PP
After an entry's
.B expiration
date has passed, the KDC will return an
error to any client attempting to gain tickets as or for the principal.
(A database may want to maintain two expiration dates: one for the
principal, and one for the principal's current key.  This allows
password aging to work independently of the principal's expiration date.
However, due to the limited space in the responses, the KDC must combine
the key expiration and principal expiration date into a single value
called "key_exp", which is used as a hint to the user to take
administrative action.)
.PP
The
.B attributes
field is a bitfield used to govern the
operations involving the principal.
This field might be useful in conjunction with user registration
procedures, for site-specific policy implementations (Project Athena
currently uses it for their user registration process controlled by the
system-wide database service, Moira.
.[ [
SMSTech
.]]),
or to identify the "string to key" conversion algorithm used for a
principal's key\**.
.FS
See the discussion of the
.B padata
field in section ~sec kdc_rep_def~ for details on why this can be useful.
.FE
Other bits are used to indicate that certain ticket options should not
be allowed in tickets encrypted under a principal's key (one bit
each):  Disallow issuing postdated tickets, disallow
issuing forwardable tickets, disallow issuing tickets based on TGT
authentication, disallow issuing renewable tickets, disallow issuing proxiable
tickets.
.PP
The
.B mod_date
field contains the time of last
modification of the entry, and the
.B mod_name
field
contains the name of the principal which last modified the entry.
.N: sec 2 foo25 "Frequently Changing Fields"
.PP
Some KDC implementations may wish to maintain the last time that a
request was made by a particular principal.
Information that might be maintained includes the time of the last
request, the time of the last request for a ticket-granting ticket,
the time of the last use of a ticket-granting ticket, or other times.
This information can then be returned to the user in the \fBlast-req\fP
field (see section ~sec asn1_base~).
.PP
Other frequently changing information that can be maintained is the
latest expiration time for any tickets that have been issued using
each key.  This field would be used to indicate how long old keys must
remain valid to allow the continued use of outstanding tickets.
.N: sec 2 site_constants "Site Constants"
.PP
The KDC implementation should have the following configurable constants
or options, to allow an administrator to make and enforce policy
decisions:
.IP \(bu 3
The minimum supported lifetime (used to determine whether the
KDC_ERR_NEVER_VALID error should be returned).  This constant should reflect
reasonable expectations of round-trip time to the KDC,
encryption/decryption time, and processing time by the client and target
server, and it should allow for a minimum "useful" lifetime.
.IP \(bu
The maximum allowable total (renewable) lifetime of a ticket (renew_till
- starttime).
.IP \(bu
The maximum allowable lifetime of a ticket (endtime - starttime).
.IP \(bu
Whether to allow the issue of tickets with empty address fields
(including the ability to specify that such tickets may only be issued
if the request specifies some authorization_data).
.IP \(bu
Whether proxiable, forwardable, renewable or post-datable tickets are
to be issued.

