.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/Constants.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/Constants.ms,v 1.31 90/12/19 17:06:08 jtkohl Exp $
.\"
.ds R# "$Id: Constants.ms,v 1.31 90/12/19 17:06:08 jtkohl Exp $
.N: sec 1 constants "Constants and other defined values"
.PP
.N: sec 2 hostaddrs "Host address types"
.PP
All negative values for the host address type are reserved for 
local use.  All non-negative values are
reserved for officially assigned type fields and interpretations.
.PP
The values of the types for the following addresses are chosen to match
the defined address family constants in the Berkeley Standard
Distributions of Unix.  They can be found in <sys/socket.h> with
symbolic names AF_xxx (where xxx is an abbreviation of the address
family name).
.PP
.SH
Internet addresses
.PP
Internet addresses are 32-bit (4-octet) quantities, encoded in MSB
order.
The type of internet addresses is two (2).
.SH
CHAOSnet addresses
.PP
CHAOSnet addresses are 16-bit (2-octet) quantities, encoded in MSB
order.
The type of CHAOSnet addresses is five (5).
.SH
ISO addresses
.PP
ISO addresses are variable-length.  The type of ISO addresses is
seven (7).
.SH
Xerox Network Services (XNS) addresses
.PP
XNS addresses are 48-bit (6-octet) quantities, encoded in MSB
order.
The type of XNS addresses is six (6).
.SH
AppleTalk Datagram Delivery Protocol (DDP) addresses
.PP
AppleTalk DDP addresses consist of an 8-bit node number and a 16-bit
network number.  The first octet of the address is the node number; the
remaining two octets encode the network number in MSB order.
The type of AppleTalk DDP addresses is sixteen (16).
.SH
DECnet Phase IV addresses
.PP
DECnet Phase IV addresses are 16-bit addresses, encoded in LSB order.
The type of DECnet Phase IV addresses is twelve (12).
.N: sec 2 kdc_contact "KDC messages"
.N: sec 3 kdc_ip "IP transport"
.PP
When contacting a Kerberos server (KDC) for a KRB_KDC_REQ
request using IP transports, the client shall send a UDP datagram
containing only an encoding of the request to port 750
.\" XXX get a real port assigned?
at the KDC's IP address; the KDC will respond with a reply datagram
containing only an encoding of the reply message (either a KRB_ERROR or
a KRB_KDC_REP) to the sending port at the sender's IP address.
.N: sec 3 tgs_principal_identifier "Name of the TGS"
.PP
The principal identifier of the ticket-granting service shall be
composed of three parts: (1) the realm of the KDC issuing the TGS ticket
(2) a two-part name, with the first part "krbtgt" and the second part
the name of the realm which will accept the ticket-granting ticket.  For
example, a ticket-granting ticket issued by the ATHENA.MIT.EDU realm to
be used to get tickets from the ATHENA.MIT.EDU KDC has a principal
identifier of "ATHENA.MIT.EDU" (realm), ("krbtgt", "ATHENA.MIT.EDU")
(name).  A ticket-granting ticket issued by the ATHENA.MIT.EDU realm to
be used to get tickets from the MIT.EDU realm has a principal identifier
of "ATHENA.MIT.EDU" (realm), ("krbtgt", "MIT.EDU") (name).
.N: sec 2 pro_consts "Protocol constants and associated values"
.PP
The following tables list constants used in the protocol and
defines their meanings. 
.TS
l l l l l.
Encryption type	\fIetype\fP value	block size	minimum pad size	confounder size
NULL	0	1	0	0
des-cbc-crc	1	8	4	8
.sp
Checksum type	\fIsumtype\fP value	checksum size
CRC32	1	4
rsa-md4	2	16
rsa-md4-des	3	16
des-mac	4	8	8
.sp
padata type	\fIpa-type\fP value
PA-TGS-REQ	1
PA-ENC-TIMESTAMPS	2
PA-PW-SALT	3
.\"XXX
.sp
authorization data type	\fIad-type\fP value
\fIreserved values\fP	0-63
OSF-DCE	64
.sp
alternate authentication type	\fImethod-type\fP value
\fIreserved values\fP	0-63
ATT-CHALLENGE-RESPONSE	64
.sp
transited encoding type	\fItr-type\fP value
DOMAIN-X500-COMPRESS	1
\fIreserved values\fP	all others
.TE
.TS
l r l.
\fILabel	Value	Meaning or MIT code\fP
.sp
pvno	5	current Kerberos protocol version number

message types

KRB_AS_REQ	10	Request for initial authentication
KRB_AS_REP	11	Response to KRB_AS_REQ request
KRB_TGS_REQ	12	Request for authentication based on TGT
KRB_TGS_REP	13	Response to KRB_TGS_REQ request
KRB_AP_REQ	14	application request to server
KRB_AP_REP	15	Response to KRB_AP_REQ_MUTUAL
KRB_SAFE	20	Safe (checksummed) application message
KRB_PRIV	21	Private (encrypted) application message

KRB_ERROR	30	Error response

error codes

KDC_ERR_NONE	0	No error
KDC_ERR_NAME_EXP	1	Client's entry in database has expired
KDC_ERR_SERVICE_EXP	2	Server's entry in database has expired
KDC_ERR_BAD_PVNO	3	Requested protocol version number
		not supported
KDC_ERR_C_OLD_MAST_KVNO	4	Client's key encrypted in
		old master key
KDC_ERR_S_OLD_MAST_KVNO	5	Server's key encrypted in
		old master key
KDC_ERR_C_PRINCIPAL_UNKNOWN	6	Client not found in Kerberos database
KDC_ERR_S_PRINCIPAL_UNKNOWN	7	Server not found in Kerberos database
KDC_ERR_PRINCIPAL_NOT_UNIQUE	8	Multiple entries for principal
		in Kerberos database
KDC_ERR_NULL_KEY	9	The client or server has a null key
KDC_ERR_CANNOT_POSTDATE	10	Ticket not eligible for postdating
KDC_ERR_NEVER_VALID	11	Requested start time is later than end time
KDC_ERR_POLICY	12	KDC policy rejects request
KDC_ERR_BADOPTION	13	KDC cannot accommodate requested option
KDC_ERR_ETYPE_NOSUPP	14	KDC has no support for encryption type
KDC_ERR_SUMTYPE_NOSUPP	15	KDC has no support for checksum type
KDC_ERR_PADATA_TYPE_NOSUPP	16	KDC has no support for padata type
KDC_ERR_TRTYPE_NOSUPP	17	KDC has no support for transited type

KRB_AP_ERR_BAD_INTEGRITY	31	Integrity check on decrypted field failed
KRB_AP_ERR_TKT_EXPIRED	32	Ticket expired
KRB_AP_ERR_TKT_NYV	33	Ticket not yet valid
KRB_AP_ERR_REPEAT	34	Request is a replay
KRB_AP_ERR_NOT_US	35	The ticket isn't for us
KRB_AP_ERR_BADMATCH	36	Ticket and authenticator don't match
KRB_AP_ERR_SKEW	37	Clock skew too great
KRB_AP_ERR_BADADDR	38	Incorrect net address
KRB_AP_ERR_BADVERSION	39	Protocol version mismatch
KRB_AP_ERR_MSG_TYPE	40	Invalid msg type
KRB_AP_ERR_MODIFIED	41	Message stream modified
KRB_AP_ERR_BADORDER	42	Message out of order
KRB_AP_ERR_BADKEYVER	44	Specified version of key is not available
KRB_AP_ERR_NOKEY	45	Service key not available
KRB_AP_ERR_MUT_FAIL	46	Mutual authentication failed
KRB_AP_ERR_BADDIRECTION	47	Incorrect message direction
KRB_AP_ERR_METHOD	48	Alternative authentication method required\(dg
KRB_AP_ERR_BADSEQ	49	Incorrect sequence number in message
KRB_AP_ERR_INAPP_CKSUM	50	Inappropriate type of checksum in message

KRB_ERR_GENERIC	60	Generic error (description in \fBe-text\fP)
KRB_ERR_FIELD_TOOLONG	61	Field is too long for this implementation


.TE
.FS \(dg
This error carries additional information in the e-data field.
The contents of the e-data field will be an encoding of the METHOD-DATA
sequence (see section ~sec krb_error_def~).
.FE
.PP
