/*
 *	$Source: /mit/kerberos/src/appl/erlogin/RCS/winoob.c,v $
 *	$Author: steiner $
 *	$Header: winoob.c,v 4.1 87/09/01 16:17:50 steiner Exp $
 */

#ifndef lint
static char *rcsid_winoob_c = "$Header: winoob.c,v 4.1 87/09/01 16:17:50 steiner Exp $";
#endif lint

/*
 * Copyright (c) 1983 Regents of the University of California.
 * Changes Copyright (c) 1987 Massachusetts Institute of Technology.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <stdio.h>
#include <sgtty.h>
#include <errno.h>
#include <signal.h>
#include <strings.h>
#include "fifo.h"

extern FILE	*dbg;
extern int	errno;
extern int	flush_to_oob_mark();
extern int	daemon_env_oob();

/*
 *    TIOCPKT_WINDOW is sort of a misnomer, which assumes that
 * TIOCPKT_ prefixes all out-of-band msg macro-names.
 * actually, this prefix is just for the pseudo-tty control bits;
 * see pty(4) in the 4.3bsd docs.
 */
# ifndef TIOCPKT_WINDOW
# define TIOCPKT_WINDOW 0x80
# endif TIOCPKT_WINDOW

/* XXX -- klooge
 * until rlogin responds to rlogind's window-size request,
 * rlogind will include the winsiz_req in every pty-control byte
 * that it passes down to rlogin.
 */
unsigned char winsiz_req = TIOCPKT_WINDOW; /* XXX; i.e., klooge */

       /*     ----- WHY RLOGIN SENDS WINDOW-SIZES TO THE REMOTE HOST -----
	*
	*    Sendwindow takes care of sending new window-size data to the
	* remote host. Sendwindow is usually activated by a SIGWINCH signal
	* (see below), but Rlogin's subr Stop() also calls Sendwindow as a subr.
	* Readeroob raises SIGWINCH once per login, when it receives from
	* rlogind an out-of-band request (TIOCPKT_WINDOW) for window-size
	* initializing values. Rlogind sends this request as it starts up.
	*    The local kernel raises SIGWINCH when it gets the call
	*	ioctl(fd, TIOCSWINSZ, &windowsize);
	* This call tells the kernel to set the window size; if
	* the new size is different from the old one, the kernel sends out
	* the SIGWINCH signal to the xterm's process group, which may
	* include an rlogin session, which is where we come in.
	*    For example, suppose the mouse is used to change a local window's
	* size. What happens is, the client window-interface asks the
	* local X server to take care of a window-size change. The server,
	* in turn, tells the window's (local) xterm to change the window's size.
	* The xterm calls ioctl as shown above, and a SIGWINCH arrives.
	*    In this aforementioned complicated event, rlogin needs to
	* pass the new window size info over to the remote cshell, so that
	* editors and other screen-driven programs will know what's going
	* on. It seems that all this is necessary only for the local-X
	* case; when the remote host's X is handling the window-change,
	* everything happens without rlogin's help.
	*/

       /*     ----- HOW RLOGIN SENDS WINDOW-SIZES TO THE REMOTE HOST -----
	*
	*    This version sends an out-of-band message to rlogind, just 
	* before writing the window sizes. When the oob msg arrives, the
	* correspondingly modified rlogind will get a SIGURG, which will
	* cause an oob handler routine to be invoked. Thus, rlogind's
	* oob-handler looks for the window-size data exactly when it's
	* available, and not otherwise.
	*    4.3BSD rlogind detects an incoming window-size message by
	* examining every character in its input stream for a "magic escape
	* sequence".
	*    We still write the magic escape sequence out, so as to remain
	* backward-compatible with unmodified 4.3 rlogind's on foreign hosts.
	* Oob-wise rlogind's simply skip over the "magic escape" crap.
	*/

char	magic[4] = { 0377, 0377, 's', 's' };

/*
 * client-side (rlogin) code.
 */
#ifdef CLIENT

int ext_rem;

setup_win(rem) int rem; {
	ext_rem = rem;
}

writeroob() {
	/*  ------- NEVER SEND WINDOW_SIZES TO 4.2 BSD RLOGIND -------
	 * this routine should run at most once:
	 *    if the remote host's rlogind is version 4.3 or later,
	 * it needs window sizes now (at rlogind startup),
	 * and it needs to get new ones whenever the local X server
	 * changes our window size.
	 *    if the remote host is running version 4.2BSD, which
	 * doesn't know about windows, Writeroob won't run at all,
	 * because rlogind will not send the out-of-band msg TIOCPKT_WINDOW.
	 */
	signal(SIGURG, SIG_IGN);
	sendwindow();
	signal(SIGWINCH, sendwindow);
}

#ifdef sun
struct	ttysize winsize = {-1, -1};
struct	ttysize ws;
struct	winsize {			/* Sendwindow needs berkeley's decl */
	unsigned short ws_row, ws_col;	/* so as to talk to remote VAXen */
	unsigned short ws_xpixel, ws_ypixel;
	};
#define GET_WINDOW_SIZE TIOCGSIZE

#else sun
struct	winsize winsize = {-1, -1, -1, -1};
struct	winsize ws;
#define GET_WINDOW_SIZE TIOCGWINSZ
#endif sun

sendwindow() {
	char obuf[4 + sizeof (struct winsize)];
	struct winsize *wp = (struct winsize *)(obuf+4);

	DBG_FPRINTF((dbg, ">>sendwindow\n\n"));
	if (ioctl(0, GET_WINDOW_SIZE, wp) ||
	    0 == bcmp(&winsize, wp, sizeof (struct winsize))) return;

	winsize = *wp;

	*obuf = TIOCPKT_WINDOW;
	send(ext_rem, obuf, 1, MSG_OOB);

	*(int*) obuf = *(int*) magic;

#ifdef sun
	wp->ws_row = htons(winsize.ts_lines);
	wp->ws_col = htons(winsize.ts_cols);
	wp->ws_xpixel = 0;
	wp->ws_ypixel = 0;
#else sun
	wp->ws_row = htons(winsize.ws_row);
	wp->ws_col = htons(winsize.ws_col);
	wp->ws_xpixel = htons(winsize.ws_xpixel);
	wp->ws_ypixel = htons(winsize.ws_ypixel);
#endif sun
	(void) write(ext_rem, obuf, sizeof(obuf));

	DBG_FPRINTF((dbg, "<<sendwindow\n"));
}
#endif CLIENT

/* end client's code. */

/*
 * server-side code.
 */
#ifdef SERVER

extern int	netf, pty; /* static copies of daemon's device-descriptors */

int	daemon_win_oob();

request_winsiz(f, p) int f, p; {
/* get ready for rlogin's response, then
 * ask rlogin for window-sizes.
 */
	netf = f; pty = p;
	signal(SIGURG, daemon_win_oob);
	send_oob(netf, winsiz_req);
	DBG_FPRINTF((dbg, "request_winsiz\n"));
}

daemon_win_oob() {
/* this is rlogind's out-of-band window-size message handler,
 * activated by SIGURG when msg arrives on socket.
 * in response to rlogind's TIOCPKT_WINDOW oob-msg,
 * which rlogind sends at protocol startup, rlogin sends the
 * TIOCPKT_WINDOW oob-msg, then writes window-size data.
 * Also, rlogin sends new window-sizes,
 * if its local X server handles a size-change.
 *     if the socket is at the out-of-band mark, we can read the control data
 * immediately. otherwise, we have to pump the socket-to-pty flow until
 * we reach the mark:
 */
	int cc, off = 0, on = 1;
	unsigned char oobchar;

	DBG_FPRINTF((dbg, ">>window_oob.\n"));

	/* rlogind's protocol routine, which we've interrupted,
	 * uses non-blocking i/o, which we don't need.
	 */
	ioctl(netf, FIONBIO, &off);
	flush_to_oob_mark(netf, pty);

	cc = recv (netf, &oobchar, 1, MSG_OOB | MSG_PEEK);

	cc = recv (netf, &off, 4, MSG_PEEK);
	DBG_FPRINTF((dbg, "win_oob's recv call: oobchar = %x magic = %x cc = %d\n",
		 oobchar, off, cc));

	if (cc <= 0);
	else if (oobchar == TIOCPKT_WINDOW) catch_window();
	else /* (oobchar == RLOGIN_ENVIRONMENT_OK) */
		/*
		 * the environment stuff has arrived too late to be useful,
		 * so we have to throw it away.
		 */
		 daemon_env_oob();

	ioctl(netf, FIONBIO, &on);
	DBG_FPRINTF((dbg, "<<window_oob.\n"));
}

catch_window() {
	struct winsize w;
	char cp[ sizeof(magic) + sizeof(struct winsize) ];
	int c;

	DBG_FPRINTF((dbg, ">>catch_window: \n"));

	errno = 0;
	c = read (netf, cp, sizeof(cp));

	DBG_FPRINTF((dbg, "read call: *cp = %x c = %d errno = %d\n",
		*(int*)cp, c, errno));

	if (c < 0 || strncmp (cp, magic, 4)) return(-1);

	bcopy(cp+4, (char *)&w, sizeof(w));
	w.ws_row = ntohs(w.ws_row);
	w.ws_col = ntohs(w.ws_col);
	w.ws_xpixel = ntohs(w.ws_xpixel);
	w.ws_ypixel = ntohs(w.ws_ypixel);

	/* Must ignore SIGTTOU, otherwise we'll stop
	 * when we try to set slave pty's window shape
	 * (our controlling tty is the master pty).
	 */
	signal(SIGTTOU, SIG_IGN);
	(void)ioctl(pty, TIOCSWINSZ, &w);

	/* turn off the perpetual request for window sizes,
	 * now that it has been answered.
	 */
	winsiz_req &= ~TIOCPKT_WINDOW;

	DBG_FPRINTF((dbg, "<<catch_window\n"));
	return(0);
}
#endif SERVER
/* end server-side code. */
