/* read_password.c */
#include "des_local.h"
#include <string.h>
#include <signal.h>
#include <sgtty.h>
#include <sys/ioctl.h>
#include <setjmp.h>

static int read_pw();
static void recsig();
static void pushsig();
static void popsig();

static void (*savsig[NSIG])();
static jmp_buf save;

int des_read_password(key,prompt,verify)
des_cblock *key;
char *prompt;
int verify;
	{
	int ok;
	char buf[BUFSIZ],buff[BUFSIZ];

	if ((ok=read_pw(buf,buff,BUFSIZ,prompt,verify)) == 0)
		des_string_to_key(buf,key);
	bzero(buf,BUFSIZ);
	bzero(buff,BUFSIZ);
	return(ok);
	}

int des_read_pw_string(buf,length,prompt,verify)
char *buf;
int length;
char *prompt;
int verify;
	{
	char buff[BUFSIZ];
	int ret;

	ret=read_pw(buf,buff,(length>BUFSIZ)?BUFSIZ:length,prompt,verify);
	bzero(buff,BUFSIZ);
	return(ret);
	}

/* return 0 if ok, 1 (or -1) otherwise */
static int read_pw(buf,buff,size,prompt,verify)
char *buf,*buff;
int size;
char *prompt;
int verify;
	{
	struct sgttyb tty_orig,tty_new;
	int ok=0;
	char *p;
	int ps=0;

	if (ioctl(fileno(stdin),TIOCGETP,(char *)&tty_orig) == -1)
		return(-1);
	bcopy(&(tty_orig),&(tty_new),sizeof(tty_orig));
	if (setjmp(save))
		{
		ok=0;
		goto error;
		}
	pushsig();
	ps=1;
	tty_new.sg_flags &= ~ECHO;
	if (ioctl(fileno(stdin),TIOCSETP,(char *)&tty_new) == -1)
		return(-1);
	ps=2;

	while (!ok)
		{
		fputs(prompt,stdout);
		fflush(stdout);

		buf[0]='\0';
		fgets(buf,size,stdin);
		if (feof(stdin)) goto error;
		if ((p=(char *)index(buf,'\n')) != NULL)
			*p='\0';
		if (verify)
			{
			fprintf(stdout,"\nVerifying password %s",prompt);
			fflush(stdout);
			buff[0]='\0';
			fgets(buff,size,stdin);
			if (feof(stdin)) goto error;
			if ((p=(char *)index(buff,'\n')) != NULL)
				*p='\0';
			if (strcmp(buf,buff) != 0)
				{
				fprintf(stdout,"\nVerify failure - try again\n");
				fflush(stdout);
				continue;
				}
			}
		ok=1;
		}

error:
	fprintf(stdout,"\n");
	/* What can we do if there is an error? */
	if (ps >= 2) ioctl(fileno(stdin),TIOCSETP,(char *)&tty_orig);
	if (ps >= 1) popsig();
	return(!ok);
	}

static void pushsig()
	{
	int i;

	for (i=0; i<NSIG; i++)
		savsig[i]=signal(i,recsig);
	}

static void popsig()
	{
	int i;

	for (i=0; i<NSIG; i++)
		signal(i,savsig[i]);
	}

static void recsig()
	{
	longjmp(save,1);
	}
