/* cbc_encrypt.c */
#include "des_local.h"

int des_cbc_encrypt(input,output,length,schedule,ivec,encrypt)
des_cblock *input;
des_cblock *output;
long length;
des_key_schedule schedule;
des_cblock *ivec;
int encrypt;
	{
	ulong i;
	ulong tin[2],tout[2],xor[2];
	uchar *in,*out,*iv,*ctin;

	in=(uchar *)input;
	out=(uchar *)output;
	iv=(uchar *)ivec;
	ctin=(uchar *)&tin[0];

	if (encrypt)
		{
		c2l(iv,tout[0]);
		c2l(iv,tout[1]);
		for (; length>0; length-=8)
			{
			if (length >= 8)
				{
				c2l(in,tin[0]);
				c2l(in,tin[1]);
				}
			else
				c2ln(in,tin[0],tin[1],length);
			tin[0]^=tout[0];
			tin[1]^=tout[1];
			des_encrypt((ulong *)tin,(ulong *)tout,
				schedule,encrypt);
			l2c(tout[0],out);
			l2c(tout[1],out);
			}
		}
	else
		{
		c2l(iv,xor[0]);
		c2l(iv,xor[1]);
		for (; length>0; length-=8)
			{
			c2l(in,tin[0]);
			c2l(in,tin[1]);
			des_encrypt((ulong *)tin,(ulong *)tout,
				schedule,encrypt);
			tout[0]^=xor[0];
			tout[1]^=xor[1];
			if (length >= 8)
				{
				l2c(tout[0],out);
				l2c(tout[1],out);
				}
			else
				l2cn(tout[0],tout[1],out,length);
			xor[0]=tin[0];
			xor[1]=tin[1];
			}
		}
	tin[0]=tin[1]=tout[0]=tout[1]=xor[0]=xor[1]=0;
	return(0);
	}

