/* This is a *very* simplistic implementation of the AT&T networking
   library. It assumes a very conformant /etc/netconfig file, ie. no
   provisions for sloppy syntax is supported, programs would probably just
   coredump with such a file...
   However... using this file frees us from including the whole -lnsl crap,
   that contains a gazillion of stuff you probably never ever need, and I
   doubt that everything inside libnsl.so really works like it should.. soooo
   this interface works quite different internally than the AT&T solution 
   (this is deductable from the netconfig.h header file, that makes me think
   AT&T uses sort of a linked list of netconfig structures). I'm using an
   array notation, and just pass indices into this array to clients querying
   the database. This should be fairly fast ;-))
   All this is only necessary because the socket interface is only available
   in (copyrighted) object files, and not source ;-(( Blame AT&T !!

   Copyright 1992 by Markus M. Wild.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER ``AS IS'' AND ANY
   EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
   BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
   IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <netconfig.h>
#include <ctype.h>

void 		 *setnetconfig(void);
int   		  endnetconfig(void *);
struct netconfig  *getnetconfig(void *);
struct netconfig  *getnetconfigent(char *);
void  		  freenetconfigent(struct netconfig *);

void 		 *setnetpath(void);
int   		  endnetpath(void *);
struct netconfig  *getnetpath(void *);

static char *netc_buf = 0;
static int netc_buf_size;

static struct netconfig *nc_tab = 0;
static int nc_tab_size;

static int
read_netconfig ()
{
  int fd, rc;
  
  netc_buf_size = -1;
  rc = 0;

  if ((fd = open ("/etc/netconfig", 0)) >= 0)
    {
      struct stat stb;

      /* slurp it in all at once (and core dump if out of memory ;-)) */
      if (fstat (fd, &stb) == 0)
	{
	  netc_buf = (char *) malloc (stb.st_size);
	  rc = read (fd, netc_buf, stb.st_size);
	  netc_buf_size = stb.st_size;
	}
      close (fd);
    }
  
  return rc == netc_buf_size ? 0 : -1;
}

static struct netconfig *
new_nc ()
{
  /* Note: this algorithm is not as bad as it looks. We're using the BSD
           malloc package, and thus realloc() only has to do `real' work
	   when crossing a power of two sized block */

  nc_tab_size++;
  nc_tab = ((struct netconfig *) 
	    realloc (nc_tab, nc_tab_size * sizeof (struct netconfig)));

  return & nc_tab[nc_tab_size - 1];
}

static int
parse_netc_buf ()
{
  char *cp, *cpend;
  int len, nassigned;

  if (! netc_buf)
    if (read_netconfig () == -1)
      return -1;

  if (nc_tab)
    return;

  /* This is the section that relies heavily on a properly specified 
     netconfig file. If not, the best thing that happens is you get 
     back a corrupt netconfig structure. More probable is that the
     program will crash here... */

  for (cp = netc_buf, cpend = netc_buf + netc_buf_size; cp < cpend; )
    {
      struct netconfig *nc = new_nc ();
      char *t, **lp;

      nc->nc_netid = cp;
      while (! isspace (*cp)) cp++;
      *cp++=0;
      while (isspace (*cp)) cp++;

      if (! strncmp (cp, "tpi_cots_ord", 12))
	nc->nc_semantics = NC_TPI_COTS_ORD;
      else if (! strncmp (cp, "tpi_clts", 8))
	nc->nc_semantics = NC_TPI_CLTS;
      else if (! strncmp (cp, "tpi_raw", 7))
	nc->nc_semantics = NC_TPI_RAW;
      else
	nc->nc_semantics = NC_TPI_COTS;

      while (! isspace (*cp)) cp++;
      while (isspace (*cp)) cp++;

      if (*cp == 'v')
	nc->nc_flag = NC_VISIBLE;
      else if (*cp == 'b')
	nc->nc_flag = NC_BROADCAST;
      else
	nc->nc_flag = NC_NOFLAG;

      while (! isspace (*cp)) cp++;
      *cp++=0;
      while (isspace (*cp)) cp++;

      nc->nc_protofmly = cp;

      while (! isspace (*cp)) cp++;
      *cp++=0;
      while (isspace (*cp)) cp++;

      nc->nc_proto = cp;

      while (! isspace (*cp)) cp++;
      *cp++=0;
      while (isspace (*cp)) cp++;

      nc->nc_device = cp;
      while (! isspace (*cp)) cp++;
      *cp++=0;
      while (isspace (*cp)) cp++;

      for (nc->nc_nlookups = 1, t = cp; *t != '\n' && *t; t++)
	if (*t == ',')
	  nc->nc_nlookups++;

      nc->nc_lookups = (char **) malloc (nc->nc_nlookups * 4);
      for (lp = nc->nc_lookups;; )
	{
	  *lp++ = cp;
	  while (*cp != ',' && *cp != '\n' && *cp) cp++;
	  if (*cp == ',')
	    *cp++ = 0;
	  else if (*cp == '\n')
	    {
	      *cp++ = 0;
	      break;
	    }
	  else if (! *cp)
	    break;
	}
      bzero (&nc->nc_unused, sizeof (nc->nc_unused));
    }

  return 0;
}

void *
setnetconfig (void)
{
  int *ip = (int *) malloc (4);

  parse_netc_buf ();

  *ip = 0;
  return (void *) ip;
}

struct netconfig *
getnetconfig (void *handle)
{
  int *ip = (int *) handle;

  parse_netc_buf ();

  if (*ip >= nc_tab_size)
    return 0;
  else
    return &nc_tab[++*ip - 1];
}

int
endnetconfig (void *handle)
{
  if (*(int *) handle == -1)
    return -1;
  else
    {
      /* don't really free it, or we can't detect anymore whether it has
	 been freed in the meantime... */
      /* free (handle); */
      *(int *) handle = -1;
      return 0;
    }
}

struct netconfig *
getnetconfigent (char *netid)
{
  int i;

  parse_netc_buf ();

  for (i = 0; i < nc_tab_size; i++)
    if (! strcmp (nc_tab[i].nc_netid, netid))
      return &nc_tab[i];
  return 0;
}

void
freenetconfigent (struct netconfig *nc)
{
  /* do nothing */
}

void *
setnetpath (void)
{
  int *ip = (int *) malloc (4);

  parse_netc_buf ();

  *ip = 0;
  return (void *) ip;
}

struct netconfig *
getnetpath (void *handle)
{
  int *ip = (int *) handle;

  parse_netc_buf ();

  if (*ip >= nc_tab_size)
    return 0;
  else
    {
      while (nc_tab[*ip].nc_flag != NC_VISIBLE && *ip < nc_tab_size)
	++*ip;

      if (*ip >= nc_tab_size)
	return 0;
      else
	return &nc_tab[++*ip - 1];
    }
}

int
endnetpath (void *handle)
{
  if (*(int *) handle == -1)
    return -1;
  else
    {
      /* don't really free it, or we can't detect anymore whether it has
	 been freed in the meantime... */
      /* free (handle); */
      *(int *) handle = -1;
      return 0;
    }
}
