#include <netconfig.h>

char *semantics[] = {
  "illegal semantic 0",
  "NC_TPI_CLTS",
  "NC_TPI_COTS",
  "NC_TPI_COTS_ORD",
  "NC_TPI_RAW",
};

main()
{
  void *handle;
  struct netconfig *nc;
  int i;

  if (handle = setnetpath ())
    {
      while (nc = getnetpath (handle))
	{
	  printf ("nc_netid:	  %s\n", nc->nc_netid);
	  printf ("nc_semantics:  %s\n",
		  nc->nc_semantics <= 4 ? semantics[nc->nc_semantics] : "too large");
	  printf ("nc_flag	  %s\n",
		  nc->nc_flag == 0 ? "NC_NOFLAG" :
		  nc->nc_flag == 1 ? "NC_VISIBLE" :
		  nc->nc_flag == 2 ? "NC_BROADCAST" : "illegal flag");
	  printf ("nc_protofmly   %s\n", nc->nc_protofmly);
	  printf ("nc_proto       %s\n", nc->nc_proto);
	  printf ("nc_device      %s\n", nc->nc_device);
	  printf ("nc_nlookups    %d\n", nc->nc_nlookups);
	  printf ("nc_lookups:\n");
	  for (i = 0; i < nc->nc_nlookups; i++)
	    printf ("  %s\n", nc->nc_lookups[i]);
	  printf ("nc_unused: ");
	  for (i = 0; i < 8; i++)
	    printf ("$%lx,", nc->nc_unused[i]);
	  printf ("\n");
	}
      endnetpath (handle);
    }
}
