/* Copyright 1992 by Markus M. Wild.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER ``AS IS'' AND ANY
   EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
   BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
   IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */

#include <sys/types.h>
#include <sys/syscall.h>

/* change BSD style sigset_t (which is just an int) into AT&T style (int[4]) */

/* note: can't use syscall() for those functions. Every signal related function
   does weird things with ucontext structures, since I don't know the
   details of the implementation (and perhaps I shouldn't know them anyway ;-))
   I'm using the internal entry point to the functions. */

int
sigpending (int *set)
{
  int ss[4];

#if 0
  if (syscall (SYS_sigpending, 1, ss) == 0)
#else
  if (_sigpending (ss) == 0)
#endif
    {
      *set = ss[0];
      return 0;
    }
  else
    return -1;
}

int
sigprocmask (int cmd, const int *new, int *old)
{
  int n[4], o[4], *np, *op;

  if (new)
    {
      np = n;
      n[0] = *new; n[1] = n[2] = n[3] = 0;
    }
  else
    np = 0;

  op = old ? o : 0;

#if 0
  if (syscall (SYS_sigprocmask, cmd, np, op) == 0)
#else
  if (_sigprocmask (cmd, np, op) == 0)
#endif
    {
      if (old)
	*old = o[0];
      return 0;
    }

  return -1;
}

int
sigsuspend (const int *set)
{
  int ss[4];

  ss[0] = *set; ss[1] = ss[2] = ss[3] = 0;
#if 0
  return syscall (SYS_sigsuspend, ss);
#else
  return _sigsuspend (ss);
#endif
}


