/* Copyright 1992 by Markus M. Wild.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER ``AS IS'' AND ANY
   EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
   BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
   IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */

/* this supports all the dirty tricks BSD code tends to do to sigaction
   structures, including the fact that the BSD definition of struct 
   sigaction really is a struct sigvec with renames flag names... */

#include <sys/types.h>
#define sigaction att_sigaction
#include <signal.h>
#undef sigaction
/* #include <sys/syscall.h> */

struct	bsd_sigaction {
	void	(*sa_handler)();	/* signal handler */
	u_int   sa_mask;		/* signal mask to apply */
	int	sa_flags;		/* see signal options below */
};

#define BSD_SA_ONSTACK	0x0001	/* take signal on signal stack */
#define BSD_SA_RESTART	0x0002	/* do not restart system on signal return */
#define BSD_SA_NOCLDSTOP	0x0004	/* do not generate SIGCHLD on child stop */

int
sigaction (int sig, struct bsd_sigaction *bsa, struct bsd_sigaction *obsa)
{
  struct att_sigaction asa, oasa, *asap, *oasap;

  if (bsa)
    {
      asap = &asa;
      asa.sa_handler = bsa->sa_handler;
      asa.sa_flags = 0;
      if (bsa->sa_flags & BSD_SA_ONSTACK)
	asa.sa_flags |= SA_ONSTACK;
      if (bsa->sa_flags & BSD_SA_RESTART)
	asa.sa_flags |= SA_RESTART;
      if (bsa->sa_flags & BSD_SA_NOCLDSTOP)
	asa.sa_flags |= SA_NOCLDSTOP;
      asa.sa_mask.sigbits[0] = bsa->sa_mask;
      asa.sa_mask.sigbits[1] = 
	asa.sa_mask.sigbits[2] = 
	  asa.sa_mask.sigbits[3] = 0;
    }
  else
    asap = 0;

  if (obsa)
    oasap = &oasa;
  else
    oasap = 0;

#if 0
  if (syscall (SYS_sigaction, sig, asap, oasap) < 0)
    return -1;
#else
  /* the library glue does some weird things with ucontext structures...
     so call the glue, it's in libc.so anyway, so no additional library
     is needed */
  if (_sigaction (sig, asap, oasap) < 0)
    return -1;
#endif

  if (oasap)
    {
      obsa->sa_handler = oasa.sa_handler;
      obsa->sa_flags = 0;
      if (oasa.sa_flags & SA_ONSTACK)
	obsa->sa_flags |= BSD_SA_ONSTACK;
      if (oasa.sa_flags & SA_RESTART)
	obsa->sa_flags |= BSD_SA_RESTART;
      if (oasa.sa_flags & SA_NOCLDSTOP)
	obsa->sa_flags |= BSD_SA_NOCLDSTOP;
      obsa->sa_mask = oasa.sa_mask.sigbits[0];
    }

  return 0;
}
