/* Copyright 1992 by Markus M. Wild.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER ``AS IS'' AND ANY
   EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
   BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
   IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. */

/* too bad AT&T doesn't believe in statistics gathering... All the nice
   values in struct resource are not available, but the cpu usage fields,
   and even those can only be accessed by using the weird waitid() call...
   As the disclaimer states: no warranties whatsoever this code works..
   BTW: Irix4 implements a VERY nice ioctl command for the proc filesystem
        that returns such statistics data, how about adding this feature to
        SVR4???? */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/times.h>
#include <errno.h>

/*
 * Resource utilization information.
 */

#define	RUSAGE_SELF	0
#define	RUSAGE_CHILDREN	-1

struct	rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
	long	ru_maxrss;		/* max resident set size */
#define	ru_first	ru_ixrss
	long	ru_ixrss;		/* integral shared memory size */
	long	ru_idrss;		/* integral unshared data " */
	long	ru_isrss;		/* integral unshared stack " */
	long	ru_minflt;		/* page reclaims */
	long	ru_majflt;		/* page faults */
	long	ru_nswap;		/* swaps */
	long	ru_inblock;		/* block input operations */
	long	ru_oublock;		/* block output operations */
	long	ru_msgsnd;		/* messages sent */
	long	ru_msgrcv;		/* messages received */
	long	ru_nsignals;		/* signals received */
	long	ru_nvcsw;		/* voluntary context switches */
	long	ru_nivcsw;		/* involuntary " */
#define	ru_last		ru_nivcsw
};


int
getrusage (int who, struct rusage *ru)
{
  struct tms tms;

  if (ru)
    {
      int tu, ts;
      bzero (ru, sizeof (*ru));

      if (times (&tms) < 0)
	return -1;
      
      if (who == RUSAGE_SELF)
	{
	  tu = tms.tms_utime;
	  ts = tms.tms_stime;
	}
      else if (who == RUSAGE_CHILDREN)
	{
	  tu = tms.tms_cutime;
	  ts = tms.tms_cstime;
	}
      else
	{
	  errno = EINVAL;
	  return -1;
	}

      ru->ru_utime.tv_usec = (tu % CLK_TCK) * (1000000 / CLK_TCK);
      ru->ru_utime.tv_sec  = tu / CLK_TCK;

      ru->ru_stime.tv_usec = (ts % CLK_TCK) * (1000000 / CLK_TCK);
      ru->ru_stime.tv_sec  = ts / CLK_TCK;

      return 0;
    }
  else
    {
      errno = EFAULT;
      return -1;
    }
}
