#include <sys/time.h>

/* The ftime(2) system call structure -- deprecated. */
struct timeb {
	time_t	time;			/* seconds since the Epoch */
	unsigned short millitm __attribute__ ((aligned(2)));/* + milliseconds since the Epoch */
	short	timezone;		/* minutes west of CUT */
	short	dstflag;		/* DST == non-zero */
};

/* this seems to be a relict of pre-gettimeofday times.. */

int
ftime (struct timeb *tb)
{
  struct timeval tv;
  struct timezone tz;
  
  if (gettimeofday (&tv, &tz) == 0)
    {
      tb->time = tv.tv_sec;
      tb->millitm = tv.tv_usec / 1000;
      tb->timezone = tz.tz_minuteswest;
      tb->dstflag = tz.tz_dsttime;
      return 0;
    }
  return -1;
}
