#include <unistd.h>
#include <stdlib.h>
#include <utmpx.h>

int
svr4_getlogin (char *buf, int bufsize)
{
  /* getlogin is a system call on bsd44, would make sense on svr4
     too, but I don't have kernel source... */

  /* note: we're using the BSD ttyname(3) call, this operates on a 
     device database, using mode/dev_t as key. This should be MUCH
     faster than the AT&T sequential searching thru all subdirs..
     (BTW: dev_mkdb needs some modifications to walk thru subdirectories,
           you can't use it as is on SVR4, since it doesn't descend into
           directories) */
  char *our_tty = ttyname (2);
  struct utmpx *utx;

  /* we could try another way out thru the pw-file and uid approach,
     but for now, I just return failure, much better than the AT&T
     function that sometimes returns wrong entries.. */

  if (! our_tty)
    return -1;

  setutxent ();
  while (utx = getutxent ())
    {
      if (! strcmp (our_tty, utx->ut_line))
	{
	  strncpy (buf, utx->ut_name, bufsize);
	  break;
	}
    }
  endutxent ();

  return utx ? 0 : -1;
}
