/*
 * Copyright (c) 1988, 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)termios.h	7.22 (Berkeley) 5/7/91
 */

/*
 *  termios structure
 */
#ifndef _TERMIOS_H_
#define _TERMIOS_H_

#include <sys/ioctl.h>

/* 
 * Special Control Characters 
 *
 * Index into c_cc[] character array.
 *
 *	Name	     Subscript	Enabled by 
 */
#define	VEOF		4	/* ICANON */
#define	VEOL		5	/* ICANON */
#ifndef _POSIX_SOURCE
#define	VEOL2		6	/* ICANON */
#endif
#define	VERASE		2	/* ICANON */
#ifndef _POSIX_SOURCE
#define VWERASE 	14	/* ICANON */
#endif 
#define VKILL		3	/* ICANON */
#ifndef _POSIX_SOURCE
#define	VREPRINT 	12	/* ICANON */
#endif
#define VINTR		0	/* ISIG */
#define VQUIT		1	/* ISIG */
#define VSUSP		10	/* ISIG */
#ifndef _POSIX_SOURCE
#define VDSUSP		11	/* ISIG */
#endif
#define VSTART		8	/* IXON, IXOFF */
#define VSTOP		9	/* IXON, IXOFF */
#ifndef _POSIX_SOURCE
#define	VLNEXT		15	/* IEXTEN */
#define	VDISCARD	13	/* IEXTEN */
#endif
#define VMIN		4	/* !ICANON */
#define VTIME		5	/* !ICANON */
#ifndef _POSIX_SOURCE
#define VSTATUS		16	/* ICANON */
#define	NCCS		19
#endif

#define _POSIX_VDISABLE	((unsigned char)'\377')

#ifndef _POSIX_SOURCE
#define CCEQ(val, c)	(c == val ? val != _POSIX_VDISABLE : 0)
#endif

/*
 * Input flags - software input processing
 */
#define	IGNBRK		0x00000001	/* ignore BREAK condition */
#define	BRKINT		0x00000002	/* map BREAK to SIGINTR */
#define	IGNPAR		0x00000004	/* ignore (discard) parity errors */
#define	PARMRK		0x00000008	/* mark parity and framing errors */
#define	INPCK		0x00000010	/* enable checking of parity errors */
#define	ISTRIP		0x00000020	/* strip 8th bit off chars */
#define	INLCR		0x00000040	/* map NL into CR */
#define	IGNCR		0x00000080	/* ignore CR */
#define	ICRNL		0x00000100	/* map CR to NL (ala CRMOD) */
#define	IXON		0x00000400	/* enable output flow control */
#define	IXOFF		0x00001000	/* enable input flow control */
#ifndef _POSIX_SOURCE
#define	IXANY		0x00000800	/* any char will restart after stop */
#define IMAXBEL		0x00002000	/* ring bell on input queue full */
#endif  /*_POSIX_SOURCE */

/*
 * Output flags - software output processing
 */
#define	OPOST		0x00000001	/* enable following output processing */
#ifndef _POSIX_SOURCE
#define ONLCR		0x00000004	/* map NL to CR-NL (ala CRMOD) */
#define OXTABS		0x00001800	/* expand tabs to spaces */
#if 0
#define ONOEOT		0x00000008	/* discard EOT's (^D) on output) */
#endif
#endif  /*_POSIX_SOURCE */

/*
 * Control flags - hardware control of terminal
 */
#ifndef _POSIX_SOURCE
#if 0
#define	CIGNORE		0x00000001	/* ignore control flags */
#endif
#endif
#define CSIZE		0x00000030	/* character size mask */
#define     CS5		    0x00000000	    /* 5 bits (pseudo) */
#define     CS6		    0x00000010	    /* 6 bits */
#define     CS7		    0x00000020	    /* 7 bits */
#define     CS8		    0x00000030	    /* 8 bits */
#define CSTOPB		0x00000040	/* send 2 stop bits */
#define CREAD		0x00000080	/* enable receiver */
#define PARENB		0x00000100	/* parity enable */
#define PARODD		0x00000200	/* odd parity, else even */
#define HUPCL		0x00000400	/* hang up on last close */
#define CLOCAL		0x00000800	/* ignore modem status lines */
#ifndef _POSIX_SOURCE
#if 0
#define CCTS_OFLOW	0x00010000	/* CTS flow control of output */
#define CRTSCTS		CCTS_OFLOW	/* ??? */
#define CRTS_IFLOW	0x00020000	/* RTS flow control of input */
#define	MDMBUF		0x00100000	/* flow control output via Carrier */
#endif
#endif


/* 
 * "Local" flags - dumping ground for other state
 *
 * Warning: some flags in this structure begin with
 * the letter "I" and look like they belong in the
 * input flag.
 */

#ifndef _POSIX_SOURCE
#define	ECHOKE		0x00000800	/* visual erase for line kill */
#endif  /*_POSIX_SOURCE */
#define	ECHOE		0x00000010	/* visually erase chars */
#define	ECHOK		0x00000020	/* echo NL after line kill */
#define ECHO		0x00000008	/* enable echoing */
#define	ECHONL		0x00000040	/* echo NL even if ECHO is off */
#ifndef _POSIX_SOURCE
#define	ECHOPRT		0x00000400	/* visual erase mode for hardcopy */
#define ECHOCTL  	0x00000200	/* echo control chars as ^(Char) */
#endif  /*_POSIX_SOURCE */
#define	ISIG		0x00000001	/* enable signals INTR, QUIT, [D]SUSP */
#define	ICANON		0x00000002	/* canonicalize input lines */
#ifndef _POSIX_SOURCE
#if 0
#define ALTWERASE	0x00000200	/* use alternate WERASE algorithm */
#endif
#endif  /*_POSIX_SOURCE */
#define	IEXTEN		0x00008000	/* enable DISCARD and LNEXT */
#if 0
#define EXTPROC         0x00000800      /* external processing */
#endif
#define TOSTOP		0x00000100	/* stop background jobs from output */
#ifndef _POSIX_SOURCE
#define FLUSHO		0x00020000	/* output being flushed (state) */
#if 0
#define	NOKERNINFO	0x02000000	/* no kernel output from VSTATUS */
#endif
#define PENDIN		0x00040000	/* XXX retype pending input (state) */
#endif  /*_POSIX_SOURCE */
#define	NOFLSH		0x00000080	/* don't flush after interrupt */

typedef unsigned long	tcflag_t;
typedef unsigned char	cc_t;
typedef unsigned long	speed_t;

struct termios {
	tcflag_t	c_iflag;	/* input flags */
	tcflag_t	c_oflag;	/* output flags */
	tcflag_t	c_cflag;	/* control flags */
	tcflag_t	c_lflag;	/* local flags */
	cc_t		c_cc[NCCS];	/* control chars */
#if 0
	long		c_ispeed;	/* input speed */
	long		c_ospeed;	/* output speed */
#endif
};

/* 
 * Commands passed to tcsetattr() for setting the termios structure.
 */
#define	TCSANOW		(TIOCSETA)	/* make change immediate */
#define	TCSADRAIN	(TIOCSETAW)	/* drain output, then change */
#define	TCSAFLUSH	(TIOCSETAF)	/* drain output, flush input */
#ifndef _POSIX_SOURCE
#define TCSASOFT	0x0		/* flag - don't alter h.w. state */
#endif

/*
 * Standard speeds
 */
#define B0	0
#define B50	1
#define B75	2
#define B110	3
#define B134	4
#define B150	5
#define B200	6
#define B300	7
#define B600	8
#define B1200	9
#define	B1800	10
#define B2400	11
#define B4800	12
#define B9600	13
#define B19200	14
#define B38400	15

#ifndef KERNEL

#include <sys/cdefs.h>

__BEGIN_DECLS
speed_t	cfgetispeed __P((const struct termios *));
speed_t	cfgetospeed __P((const struct termios *));
int	cfsetispeed __P((struct termios *, speed_t));
int	cfsetospeed __P((struct termios *, speed_t));
int	tcdrain __P((int));
int	tcflow __P((int, int));
int	tcflush __P((int, int));
int	tcgetattr __P((int, struct termios *));
int	tcsendbreak __P((int, int));
int	tcsetattr __P((int, int, const struct termios *));

#define	TCIFLUSH	1
#define	TCOFLUSH	2
#define TCIOFLUSH	3
#define	TCOOFF		1
#define	TCOON		2
#define TCIOFF		3
#define TCION		4

#ifndef _POSIX_SOURCE
void	cfmakeraw __P((struct termios *));
void	cfsetspeed __P((struct termios *, speed_t));
#endif /* !POSIX */
__END_DECLS

#endif /* !KERNEL */

/*
 * END OF PROTECTED INCLUDE.
 */
#endif /* !_TERMIOS_H_ */

#ifndef _POSIX_SOURCE
#include <sys/ttydefaults.h>
#endif  /*_POSIX_SOURCE */
