#!/bin/csh
#
# Mach Operating System
# Copyright (c) 1991 Carnegie Mellon University
# All Rights Reserved.
# 
# Permission to use, copy, modify and distribute this software and its
# documentation is hereby granted, provided that both the copyright
# notice and this permission notice appear in all copies of the
# software, derivative works or modified versions, and any portions
# thereof, and that both notices appear in supporting documentation.
#
# CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
# CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
# ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
#
# Carnegie Mellon requests users of this software to return to
#
#  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
#  School of Computer Science
#  Carnegie Mellon University
#  Pittsburgh PA 15213-3890
#
# any improvements or extensions that they make and grant Carnegie Mellon
# the rights to redistribute these changes.
#
#
# Copyright (c) 1991
# Open Software Foundation, Inc.
#
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "as is"
# without express or implied warranty.
#
#
# HISTORY
# $Log:	setvar.csh,v $
# Revision 2.3  92/07/08  18:06:16  mrt
# 	Added the release area to INCDIRS and LIBDIRS after the export
# 	area. Defined CPP conditionally so  that it can be set in
# 	the context specific setvar.csh
# 	[92/06/18            mrt]
# 
# Revision 2.2  92/05/20  20:16:38  mrt
# 	First checkin.
# 	[92/05/20  14:24:46  mrt]
# 
#
#    File:	setvar.csh
#    Copied from: setup.sh
#    Date:	May, 1990
#
#    Abstract:
#	This script sets all the environment variables used by make
#	and leaves you in a csh shell so that you can just type
#	make <program>. This is to be used before you are using build
#	and rc-files. This script sets things to build things int
#	the Mach3 project, not the ODE tools. 
#
#
# The script assumes that it is in the directory ode/setup.
#
# Usage is as follows:
#	setvar.csh [-basedir <dir>] <context>
#	    -basedir <dir>: the base of the tree which contains the src,obj,
#			release and tools directories. Default to the parent
#			of the current directory.
#
#	    context is machine_os specification that selects
#		a case in src/Makeconf
#
set USAGE="usage: setvar.csh [-basedir <dir>] [-makesyspath <dir>] <context> "
if ( $#argv < 1 ) then
   echo "$USAGE"
   exit (1)
endif
set progdir = `expr "$0" : "\(.*\)/.*"`
if ( $progdir == "") then
   set progdir = "."
endif
set base=NULL
set makesyspath=NULL
while ($#argv > 1)
   switch ( $1 )
	case -basedir:
		set  base=$2
		shift
		shift
		breaksw
	case -makesyspath:
		set  makesyspath=$2
		shift
		shift
		breaksw
	default:
		echo "unrecognized argument: $1"
		echo "$USAGE"
		exit (1)
	endsw
end
if ( $#argv == 1 ) then
    setenv context $1
else 
    echo "$USAGE"
    exit (1)
endif
echo $context $progdir
#
# Read configuration info
#
if ( ! -r $progdir/$context/setvar.csh ) then
  echo "Missing $progdir/$context/setup file"
  exit (1)
endif
source $progdir/$context/setvar.csh

#
#  Find the base directory and where we are relative to it
#
if ( $base == NULL ) then
   set parent = `pwd`
   set src = ${parent}:t
   while ( $src != "src" )
	set parent=$parent:h
	set src=$parent:t
   end
   set base = $parent:h
endif

#
# Setup immediate directory heirarchy
#
set objdir = ${base}/obj
if ( ! -d ${objdir} ) then
    mkdir ${objdir}
endif
set objdir = ${base}/obj/${context}
if ( ! -d ${objdir} ) then
    mkdir ${objdir}
endif
set expdir = ${base}/export
if ( ! -d ${expdir} ) then
    mkdir ${expdir}
endif
set expdir = ${base}/export/${context}
if ( ! -d ${expdir} ) then
    mkdir ${expdir}
endif
set releasedir = ${base}/release
if ( ! -d ${releasedir} ) then
    mkdir ${releasedir}
endif
set releasedir = ${base}/release/${context}
if ( ! -d ${releasedir} ) then
    mkdir ${releasedir}
endif
set toolsdir = ${base}/tools
if ( ! -d ${toolsdir} ) then
    mkdir ${toolsdir}
endif
set toolsdir = ${base}/tools/${context}
if ( ! -d ${toolsdir} ) then
    mkdir ${toolsdir}
endif
set bindir = ${toolsdir}/bin
if ( ! -d ${bindir} ) then
    mkdir ${bindir}
endif
set libdir = ${toolsdir}/lib
if ( ! -d ${libdir} ) then
    mkdir ${libdir}
endif


#if ( ! $?KERN_MACHINE_DIR )then
#    setenv KERN_MACHINE_DIR $target_machine
#endif

#
# Constrain search paths
#    LPATH and CPATH should locate generic Unix files
#    They  may not be used by all Unix compilers and loaders
#

setenv PATH "${bindir}:${releasedir}/bin:${DEFPATH}"
setenv CPATH "${DEFCPATH}"
setenv LPATH "${libdir}:${releasedir}/lib:${DEFLPATH}"

setenv INCDIRS "-I${expdir}/usr/include -I${releasedir}/include"
setenv LIBDIRS "-L${toolsdir}/lib -L${expdir}/usr/lib -L${releasedir}/lib"

#
# Site/Environment stuff
#

setenv OWNER "cs"
setenv GROUP "cs"

#
# New build environment definitions
#
setenv PROJECT_NAME MACH3
setenv project_name mach3
setenv RULES_MK osf.rules.mk
if ( $makesyspath != NULL ) then
    setenv MAKESYSPATH $makesyspath
endif
setenv EXPORTBASE ${expdir}
# SOURCEBASE, SOURCEDIR and OBJECTDIR are needed by genpath
setenv SOURCEBASE ${base}/src
setenv SOURCEDIR ""
if ( ! $?OBJECTDIR )then
	setenv OBJECTDIR ${objdir}
endif

setenv MAKEOPTIONS "-r"
#setenv TOSTAGE ${releasedir}/latest
# TOSTAGE keeps PROGRAMS from building
if ( ! $?CPP ) then
    setenv CPP /usr/cs/lib/cpp
endif
setenv MIGCPP ${CPP}
setenv MIGCOM ${toolsdir}/lib/migcom

csh -i
