#!/bin/sh 
# 
# Mach Operating System
# Copyright (c) 1992 Carnegie Mellon University
# All Rights Reserved.
# 
# Permission to use, copy, modify and distribute this software and its
# documentation is hereby granted, provided that both the copyright
# notice and this permission notice appear in all copies of the
# software, derivative works or modified versions, and any portions
# thereof, and that both notices appear in supporting documentation.
# 
# CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
# CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
# ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
# 
# Carnegie Mellon requests users of this software to return to
# 
#  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
#  School of Computer Science
#  Carnegie Mellon University
#  Pittsburgh PA 15213-3890
# 
# any improvements or extensions that they make and grant Carnegie Mellon 
# the rights to redistribute these changes.
#  
#
# HISTORY
# $Log:	ascpp.sh,v $
# Revision 2.2  92/03/03  00:42:04  rpd
# 	Created, from initial version by danner.
# 	[92/03/01            rpd]
# 

# Wrapper for cpp.  Some cpp's are derived from gcc-cpp, and
# consequently won't run files through cpp that aren't named .c. 
# So this script renames and does the necessary magic. Some extra
# contortions are necessary to get the dependency information right.
# (The script assumes -MD is being used.)

args=""
until [ $# -eq 1 ]
do
	args="$args $1"
	shift
done
fn="$1"

#
# extract last component of file, stripping
#
bn="`expr "$fn" : '.*/\([^/]*\)' '|' "$fn"`"
base="`expr "$bn" : '\(.*\)\.[^.]*'`"

cp "$fn" xXx.c && \
$args -DNEWLINE='&' xXx.c | tr '&' '\012' | sed -e 's[^#\(.*\)"xXx\.c"[#\1"'"$fn"'"[g' && \
sed -e 's[xXx\.c['"$fn"'[g' -e 's/xXx/'"$base"'/g' < xXx.d > "$base".d && \
rm -f xXx.d xXx.c
