 .\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	processor_set_policy_enable.man,v $
.\" Revision 2.5  93/03/18  15:14:31  mrt
.\" 	corrected types
.\" 	[93/03/11  12:54:28  lli]
.\" 
.\" Revision 2.4  91/05/14  17:11:56  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:14:11  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:15:01  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:42:56  rpd
.\" 	Created.
.\" 
.TH processor_set_policy_enable 2 8/13/89
.CM 4
.SH NAME
.nf
processor_set_policy_enable  \-  enable scheduling policy on processor set
processor_set_policy_disable  \-  disable scheduling policy on processor set
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t
processor_set_policy_enable(processor_set, policy)
	mach_port_t processor_set;
	int		policy;


.fi
.ft P
.nf
.ft B
kern_return_t
processor_set_policy_disable(processor_set, policy, change_threads)
	mach_port_t   	processor set;
	int             policy;
	boolean_t	change_threads;




.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
processor_set
The processor set whose allowed policies are to be changed.
.TP 15
.B
policy
The policy to enable or disable
.TP 15
.B
change_threads
Reset the policies of any threads with the newly-disallowed policy to
timesharing.

.SH DESCRIPTION
Processor sets may restrict the scheduling policies to be used for
threads assigned to them.  These two calls provide the mechanism for
designating permitted and forbidden policies.  The current set of
permitted policies can be obtained from 
.B processor_set_info.
Timesharing may not
be forbidden by any processor_set.  This is a compromise to reduce the
complexity of the assign operation; any thread whose policy is forbidden by
the target processor set has its policy reset to timesharing.  If the
.B change_threads
argument to 
.B processor_set_policy_disable
is true, threads currently assigned to this processor set and using the
newly disabled policy will have their policy reset to timesharing.

<mach/policy.h> contains the allowed policies; it is included by mach.h.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Operation completed successfully
.TP 25
KERN_INVALID_ARGUMENT
.B processor_set
is not a processor set,
or 
.B policy
is not a valid policy, or an attempt was made to disable timesharing.

.SH BUGS
Availability limited.  Not all policies (e.g. fixed priority) are supported
by all systems.

.SH SEE ALSO
.B thread_policy, task_policy

