.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	processor_set_create.man,v $
.\" Revision 2.5  93/03/18  15:14:11  mrt
.\" 	corrected types
.\" 	[93/03/11  12:53:53  lli]
.\" 
.\" Revision 2.4  91/05/14  17:11:15  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:13:53  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:14:38  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:42:18  rpd
.\" 	Created.
.\" 
.TH processor_set_create 2 8/13/89
.CM 4
.SH NAME
.nf
processor_set_create  \-  create a new processor set
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t processor_set_create(host, new_set, new_name)
	mach_port_t		host;
	mach_port_t		*new_set;
	mach_port_t     	*new_name;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
host
The host on which the new set is to be created.
.TP 15
.B
new_set
Port used for performing operations on the new set.
.TP 15
.B
new_name
Port used to identify the new set and obtain information about it.

.SH DESCRIPTION
.B processor_set_create
creates a new processor set and returns 
the two ports associated with it.  The port returned in 
.B new_set
is the actual port representing the set.  It is used to perform
operations such as assigning processors, tasks, or threads.
The port returned in 
.B new_name
identifies the set, and is used to obtain information about the set.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B host
was not a host.
.TP 25
KERN_INVALID_ADDRESS
.B new_set
and/or 
.B new_name
point to inaccessible memory.
.TP 25
KERN_FAILURE
The operating system does not support processor allocation.

.SH BUGS
Availability limited.

.SH SEE ALSO
.B processor_set_destroy, processor_set_info, processor_assign, task_assign,
.B thread_assign

