.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_allocate_name.man,v $
.\" Revision 2.2  93/05/10  19:33:16  rvb
.\" 	updated
.\" 	[93/04/21  16:01:37  lli]
.\" 
.\" Revision 2.5  91/12/11  08:42:42  jsb
.\" 	Updated for MK62 (sequence numbers).
.\" 	[91/11/26  11:01:31  rpd]
.\" 
.\" 	Changed <mach/mach.h> to <mach.h>.
.\" 	[91/11/25  10:55:13  rpd]
.\" 
.\" Revision 2.4  91/05/14  17:05:53  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:10:59  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:11:12  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:36:03  rpd
.\" 	Created.
.\" 
.TH mach_port_allocate_name 2 4/13/87
.CM 4
.SH NAME
.nf
mach_port_allocate_name  \-  creates a port right
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

kern_return_t
mach_port_allocate_name(task, right, name)
	mach_port_t task;
	mach_port_right_t right;
	mach_port_t name;
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task acquiring the port right.
.TP 12
.B
right
The kind of right which will be created.
.TP 12
.B
name
The task's name for the port right.
.SH DESCRIPTION
\fBmach_port_allocate_name\fR creates a new right in the specified task,
with a specified name for the new right.

The \fBright\fR argument takes the following values:
.TP 12
MACH_PORT_RIGHT_RECEIVE
\fBmach_port_allocate_name\fR
creates a port.  The new port is not a member
of any port set.  It doesn't have any extant send or send-once rights.
Its make-send count is zero, its sequence number is zero,
its queue limit is MACH_PORT_QLIMIT_DEFAULT,
and it has no queued messages.
\fBname\fR denotes the receive right for the new port.

\fBtask\fR does not hold send rights for the new port, only the receive right.
\fBmach_port_insert_right(2)\fR and \fBmach_port_extract_right(2)\fR can
be used to convert the receive right into a combined send/receive right.
.TP 12
MACH_PORT_RIGHT_PORT_SET
\fBmach_port_allocate_name\fR creates a port set.
The new port set has no members.
.TP 12
MACH_PORT_RIGHT_DEAD_NAME
\fBmach_port_allocate_name\fR creates a new dead name.
The new dead name has one user reference.
.PP
\fBname\fR must not already be in use for some right,
and it can't be the reserved values MACH_PORT_NULL
and MACH_PORT_DEAD.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_VALUE
\fBright\fR was invalid.
.TP 25
KERN_INVALID_VALUE
\fBname\fR was MACH_PORT_NULL or MACH_PORT_DEAD.
.TP 25
KERN_NAME_EXISTS
\fBname\fR was already in use for a port right.
.TP 25
KERN_RESOURCE_SHORTAGE
The kernel ran out of memory.
.PP
The \fBmach_port_allocate_name\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_allocate(2),
mach_port_insert_right(2),
mach_port_extract_right(2),
mach_port_get_receive_status(2).
