.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_allocate.man,v $
.\" Revision 2.6  93/05/10  19:30:59  rvb
.\" 	updated
.\" 	[93/04/21  16:03:10  lli]
.\" 
.\" Revision 2.1.1.1  93/04/21  16:01:27  lli
.\" 	updated
.\" 
.\" Revision 2.5  91/12/11  08:42:40  jsb
.\" 	Updated for MK62 (sequence numbers).
.\" 	[91/11/26  11:01:28  rpd]
.\" 
.\" 	Changed <mach/mach.h> to <mach.h>.
.\" 	[91/11/25  10:55:09  rpd]
.\" 
.\" Revision 2.4  91/05/14  17:05:46  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:10:55  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:11:08  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:35:54  rpd
.\" 	Created.
.\" 
.TH mach_port_allocate 2 4/13/87
.CM 4
.SH NAME
.nf
mach_port_allocate  \-  creates a port right
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

kern_return_t
mach_port_allocate(task, right, name)
	mach_port_t task;
	mach_port_right_t right;
	mach_port_t *name;		/* out */
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task acquiring the port right.
.TP 12
.B
right
The kind of right which will be created.
.TP 12
.B
name
The task's name for the port right.
.SH DESCRIPTION
\fBmach_port_allocate\fR creates a new right in the specified task.
The new right's name is returned in \fBname\fR.

The \fBright\fR argument takes the following values:
.TP 12
MACH_PORT_RIGHT_RECEIVE
\fBmach_port_allocate\fR
creates a port.  The new port is not a member
of any port set.  It doesn't have any extant send or send-once rights.
Its make-send count is zero, its sequence number is zero,
its queue limit is MACH_PORT_QLIMIT_DEFAULT,
and it has no queued messages.
\fBname\fR denotes the receive right for the new port.

\fBtask\fR does not hold send rights for the new port, only the receive right.
\fBmach_port_insert_right(2)\fR and \fBmach_port_extract_right(2)\fR can
be used to convert the receive right into a combined send/receive right.
.TP 12
MACH_PORT_RIGHT_PORT_SET
\fBmach_port_allocate\fR creates a port set.
The new port set has no members.
.TP 12
MACH_PORT_RIGHT_DEAD_NAME
\fBmach_port_allocate\fR creates a dead name.
The new dead name has one user reference.
.PP
The returned \fBname\fR may be any name that wasn't in use.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_VALUE
\fBright\fR was invalid.
.TP 25
KERN_NO_SPACE
There was no room in \fBtask\fR's IPC name space for another right.
.TP 25
KERN_RESOURCE_SHORTAGE
The kernel ran out of memory.
.PP
The \fBmach_port_allocate\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_allocate_name(2),
mach_port_insert_right(2),
mach_port_extract_right(2),
mach_port_get_receive_status(2).
