/******************************************************************************
 *                                                                            *
 * File:   checkiso.c         Version  1.13            Date: 1997-06-14       *
 *                                                                            *
 * Copyright (C) 1993-1997 by kostis@acm.org (Kosta Kostis)                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - this program checks the validity of an 8-bit character encoding   *
 *          description file with ISO 10646 mnemonics                         *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-06-14: KK V1.13                                                   *
 *        - making use of the environment variable TRANS                      *
 *     1997-05-01: KK V1.12                                                   *
 *        - new release of the package                                        *
 *     1996-06-01: KK V1.11                                                   *
 *        - checking duplicate names now                                      *
 *     1995-07-01: KK V1.10                                                   *
 *        - giving correct syntax now                                         *
 *     1994-03-31: KK V1.00                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

/******************************************************************************

	General Program Definitions

 *****************************************************************************/

#include "checkiso.h"
#include "taberr.h"
#include "tab.h"

/******************************************************************************

	String Support Functions

 *****************************************************************************/

#ifdef	NO_STRDUP
	#include "strdup.c"
#endif

#ifdef	NO_STRUPR
	#include "strupr.c"
#endif

/******************************************************************************

	Character Encoding Description Table Functions

 *****************************************************************************/

#include "readtab.h"

/******************************************************************************

	Function:
		display copyright, author and program information

	Parameters:
		none

	Returns:
		nothing

 *****************************************************************************/

void	Hello (void)
{
	fprintf (stderr, MSG_COPYRIGHT) ;
	fprintf (stderr, MSG_VERSION, PRGNAM, VERSION) ;
}

/*****************************************************************************/

int     main
(
	int	argc,
	char	*argv		[]
)
{
	int	rc ;
	int	i ;
	int	j ;
	ushort	Code ;
	char	*SrcTable	[MAX_TABLE_ENTRIES] ;
	static	char	*DstTable	[ISO_TABLE_ENTRIES] ;
	static	ushort	DstCodes	[ISO_TABLE_ENTRIES] ;
	char	SrcName		[MAX_ENC_NAME_LENGTH + 1] ;
	char	DstName		[MAX_ENC_NAME_LENGTH + 1] ;
	char	*SrcComment	[MAX_COMMENTS] ;
	char	*DstComment	[MAX_COMMENTS] ;

	Hello () ;

	/**********************************************************************

		parse parameters/arguments

	 *********************************************************************/

	if (argc != 2)
	{
		/**************************************************************

			display syntax error message and quit

		 *************************************************************/

		fprintf (stderr, ERR_MSG_SYNTAX, PRGNAM) ;
		return (ERR_SYNTAX) ;
	}

	/**********************************************************************

		try to read character encoding description files

	 *********************************************************************/

	rc = ReadCodeTable (argv [1], SrcTable, (ushort *) NULL,
		MAX_TABLE_ENTRIES, SrcName, SrcComment) ;
	if (rc != ERR_NONE)
	{
		fprintf (stderr, ERR_MSG_OPEN, PRGNAM, argv [1]) ;
		return (rc) ;
	}

	rc = ReadCodeTable (DEF_ISONAME, DstTable, DstCodes,
		ISO_TABLE_ENTRIES, DstName, DstComment) ;
	if (rc != ERR_NONE)
	{
		fprintf (stderr, ERR_MSG_OPEN, PRGNAM, DEF_ISONAME) ;
		return (rc) ;
	}

	/**********************************************************************

		check source file

	 *********************************************************************/

	fprintf (stdout, MSG_CHECK, PRGNAM, argv [1]) ;

	for (i = 0 ; i < MAX_TABLE_ENTRIES - 1 ; ++i)
	{
		if
		(
			(SrcTable [i] != (char *) NULL) &&
			(strncmp (SrcTable [i], STR_NC, strlen (STR_NC)) != 0)
		)
		{
			for (j = i + 1 ; j < MAX_TABLE_ENTRIES ; ++j)
			{
				if
				(
					(SrcTable [j] != (char *) NULL) &&
					(strcmp (SrcTable [i], SrcTable [j]) == 0)
				)
				{
					fprintf (stdout, MSG_DUPLICATE,
						 PRGNAM, i, j, SrcTable [i]) ;
				}
			}
		}
	}

	for (i = 0 ; i < MAX_TABLE_ENTRIES ; ++i)
	{
		if
		(
			(SrcTable [i] != (char *) NULL) &&
			(strncmp (SrcTable [i], STR_NC, strlen (STR_NC)) != 0)
		)
		{
			Code = FindCode (SrcTable [i], DstTable,
				DstCodes, ISO_TABLE_ENTRIES) ;
			if (Code == BAD)
			{
				fprintf (stdout, MSG_ERROR,
					PRGNAM, i, SrcTable [i]) ;
			}
		}
	}

	/**********************************************************************

		free memory allocated by ReadCodeTable () and quit

	 *********************************************************************/

	FreeCodeTable (SrcTable, MAX_TABLE_ENTRIES) ;
	FreeCodeTable (DstTable, ISO_TABLE_ENTRIES) ;

	return (ERR_NONE) ;
}
