.TH RAZ  1 "July 1992" "AHPCRC"
.SH NAME
xraz \- X interface to raz, a disk based raster viewer
.SH SYNOPSIS
\fBxraz\fR [ options ] [ script ]
.SH DESCRIPTION
\fBXraz\fR feeds commands
to \fBraz\fR, giving the user a nice push button interface.  Without
\fBxraz\fR the way to use \fBraz\fR is to feed it ascii
commands directly, or from a file.
.PP
\fBXraz\fR can work hand in hand with \fBicol\fR, the color table editor.
Changes in \fBicol\fR are automatically passed on to \fBxraz\fR and 
so on to \fBraz\fR.
.PP
All of the interface elements in \fBxraz\fR send the expected command
to \fBraz\fR, so to understand the effects of \fBxraz\fR commands read
the \fBraz\fR man page.
.PP
If the command line script is -, \fBxraz\fR will read raz commands
from standard input.
.SH "USING XRAZ"
Run \fBxraz\fR, perhaps with a script from a previous session on the 
command line.  \fBXraz\fR starts up \fBraz\fR and sends it the script
if there is one.  Use the dialogs in the Image menu to set the image 
format and raw disk destination if playing from raw disk.  Use the
"Image Files" command and edit the file filter to specify a list of files.
.PP
Press either the large play button or the smaller frame increment button
to trigger \fBraz\fR into loading the movie.  The \fBxraz\fR interface will 
be frozen until \fBraz\fR finishes loading and responds to \fBxraz\fR.  
Once the movie has been loaded
to disk or memory the \fBxraz\fR interface will respond to commands again.
.PP
Any change to file format or file name list will trigger a load at the 
next "play" or "goto" request.  If the movie is already loaded to raw disk,
use the "Source from Raw Disk" toggle to skip the load step.
.PP
To save your settings for next time, use the "Save Script" command.  
For full control of \fBraz\fR, use the "Script" dialog to send
commands directly.  This would be a good way to send a series of
"play", "set speed", "set direction" and "sleep" commands for a movie sequence.
.SH OPTIONS
\fBXraz\fR understands all of the standard X toolkit options.  
In addition:
.IP "-t timeout"
Set the time between frame updates while playing to timeout,
in milliseconds.  When the frame rate timer is on, the 
statistics are updated at this rate.   The default is 2000 milliseconds,
or two seconds between updates.
.IP "-d debug"
Set the debug level,  Currently, 1 will print out the communication
between xraz and raz.
.IP "-h | -help"
Print a brief help message.
.SH RESOURCES
.IP "timeout (class Timeout)"
Set the update timeout in milliseconds.
.IP "bugAddress (class BugAddress)"
The mail address to send comments to.
.SH MENUS
.IP Control
The "Save Script" command interrogates \fBraz\fR and save its state in
the selected file.  The "Open Script" command reads commands from a file
and sends them to \fBraz\fR.  "Script" send text directly to \fBraz\fR.
"Start Icol" simply starts an icol color editor.  "Restart Raz" kills
and restart the \fBraz\fR process.  You will need to select a "play" or
"goto" command to trigger a load and the image window.
.IP Image
The "Files", "Format" and "Raw Disk" dialogs each control the respective
settings in \fBraz\fR.  Set "Play from Memory" to play images out of memory
instead of disk.  Set "Source from Raw Disk" if the images have already
been loaded to raw disk.  In this case, be sure to specify the number
of frames on disk in the Raw Disk dialog.
.IP Mode
The "Zoom Window", "Double Buffered" and "Reverse At End" toggles control the
respective setting in \fBraz\fR.  Setting the frame rate timer issues
a "mark" command to \fBraz\fR whenever the frame scale is updated,
by default every two seconds.  The statistics are shown on the status 
line.
.SH "BUTTONS AND SCALES"
The large arrow buttons issue "play" commands to \fBraz\fR in either
the forward or reverse directions.  The smaller buttons issue "goto" 
commands to the next frame.  The stop button sends "stop".
.PP
Moving the frame scale issues "goto" commands.  The speed, size, border
and zoom scales set the "set speed", "set replication", "set border" 
and "set zoom" settings in \fBraz\fR.
.SH CAVEATS
Xraz works in lock step with raz, waiting for an acknowledgment
for each command before continuing.  This can be a problem when
loading, which can take a long time.  While loading files to raw disk or 
memory, xraz will be unresponsive while it waits for raz to signal
that the load is complete.  During this time xraz will not
accept commands.
.PP
Xraz can also lock up if raz freezes up for any reason.
.PP
There seems to be a problem on VGX machines when raz is flipped from
color map mode to full color mode.  Some of the more saturated pixels
in full color images are incorrectly painted.  Use the "Restart Raz"
command to correct this.
.PP
Due to Motif's file selection boxes, xraz can take a long time to
start up in directories with thousands of files in them.  A workaround
is to first create a script using cmdraz, then start xraz in another
directory.
.SH AUTHOR
Ken Chin-Purcell, AHPCRC
.br
Mail to gvlware@ahpcrc.umn.edu.
