/* $Header: defs.h,v 1.2 90/12/12 15:30:21 zhang Exp $ */

/*
 * $Log:	defs.h,v $
 * 
 * Revision 1.1  90/06/17  03:34:54  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#ifndef 	_DXFCONVERT		/* only once */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>

#ifdef	MSDOS
#include <float.h>
#endif

extern char  *malloc();

#include "config.h"

/*
 * define some basic data structures
 */

typedef	FLOAT	MATRIX[4][4];
typedef	struct	entity	ENTITY;
typedef	struct	block	BLOCK;
typedef	struct	layer	LAYER;
typedef	struct	options	OPTIONS;
typedef	struct	attrib	ATTRIB;
typedef	struct	vertex	VERTEX;
typedef	struct	group	GROUP;
typedef	struct	insert	INSERT;
typedef	struct	stack	STACK;
typedef	struct	name	NAME;
typedef	struct	entityprocs	ENTITYPROCS;

/*
 * define general entity data structure
 */

struct	entity	{
	INT	type;			/* entity type */
	VOID	*data;			/* actual data of the entity */
	LAYER	*layer;			/* pointer to its layer name */
	OPTIONS	*options;		/* optional parameters */
	ENTITY	*next;			/* next entity */
};

/*
 * define entity types
 */

#define	ENTITY_NULL	0		/* null, i.e. error */
#define	ENTITY_LINE	1		/* line */
#define	ENTITY_POINT	2		/* point */
#define	ENTITY_CIRCLE	3		/* circle */
#define	ENTITY_ARC	4		/* arc */
#define	ENTITY_TRACE	5		/* trace */
#define	ENTITY_SOLID	6		/* solid */
#define	ENTITY_TEXT	7		/* text */
#define	ENTITY_SHAPE	8		/* shape */
#define	ENTITY_BLOCK	9		/* block, only in BLOCKS section */
#define	ENTITY_ENDBLK	10		/* end of block, only in BLOCKS */
					/* section */
#define	ENTITY_INSERT	11		/* insert a block */
#define	ENTITY_ATTDEF	12		/* attribute definition */
#define	ENTITY_ATTRIB	13		/* attributes */
#define	ENTITY_POLYLINE	14		/* polyline, very general */
#define	ENTITY_VERTEX	15		/* vertex of polyline, only connected */
					/* with polyline */
#define	ENTITY_SEQEND	16		/* end of vertex sequence, only with */
					/* polyline */
#define	ENTITY_3DLINE	17		/* 3D line, same as line */
#define	ENTITY_3DFACE	18		/* 3D face */
#define	ENTITY_DIMENSION	19	/* demension */

/*
 * define block data structure
 */

struct	block	{
	CHAR	*name;			/* block name */
	INT	flag;			/* block type flags */
	FLOAT	basepoint[3];		/* block base points */
	ENTITY	*entitylist;		/* list of entities in the block */
	ATTRIB	*attrib;		/* attributes of the block, if any */
	LAYER	*layerlist;		/* layers defined in the block */
/*	LAYER	*layer;			 * layer name of the block * 
					 * NOT USED NOW */
	OPTIONS	*options;		/* optional parameters */
	BLOCK	*next;			/* next block in the list */
};

/*
 * define layer data structure
 */

struct	layer	{
	CHAR	*name;			/* layer name */
	FLOAT	*point;			/* reference point of the layer, */
					/* if any  */
/*	ENTITY	*entitylist;		 * list of entities in the layer *
					 * not used now, as entities are *
					 * not resorted according to the *
					 * layer name */
	LAYER	*next;			/* next layer name in the list */
};

/*
 * define data structure for optional properties
 */

struct	options	{
	INT	linetypeset;		/* 1 if linetype is set */
/*	CHAR	*linetype;		 * name of linetype, if * 
					 * not default "BYLAYER" * 
					 * NOT USED NOW */

/*	INT	elevationset;		 * 1 if elevation value is set *
	FLOAT	elevation;		 * elevation value, if nonzero *
					 * SHOULD NOT OCCUR IN A 3D DXF FILE */

	INT	thicknessset;		/* 1 if thickness value is set */
	FLOAT	thickness;		/* thickness vaule, if nonzero */

	INT	colornumberset;		/* 1 if color number is set */
/*	INT	colornumber;		 * color number, if not default *
					 * "BYLAYER" *
					 * NOT USED NOW */

	INT	extrusionset;		/* 1 if extrusion value is set */
	FLOAT	*extrusion;		/* extrusion direction, if not */
					/* parallel to the World Z axis */
};

/*
 * define (text) attribute data structure (not used now)
 */

struct	attrib	{
	FLOAT	start[3];		/* start point of text */
	FLOAT	height;			/* text height */
	CHAR	*defaulttext;		/* default value of text */
	CHAR	*prompt;		/* prompt string */
	CHAR	*tag;			/* tag string */
	INT	attribflag;		/* attribute flags */
	FLOAT	length;			/* field length, default 0 */
	FLOAT	rotation;		/* text rotation, default 0 */
	FLOAT	scale;			/* relative X scale factor, default 1 */
	FLOAT	angle;			/* obliquing angle, default 0 */
	CHAR	*style;			/* text style name, default STANDARD */
	INT	generationflag;		/* text generation flags, default 0 */
	INT	justificationtype;	/* text justification type, default 0 */
	FLOAT	alignment[3];		/* aligment point, only if text */
					/* justification type is present and */
					/* nonzero */
	OPTIONS	*options;		/* optional parameters */
};

/*
 * define attribute flags (bit-coded)
 */

#define	ATTRIB_INVISIBLE	1	/* attribute is invisible */
					/* (does not disply */
#define	ATTRIB_CONSTANT		2	/* this is a constant attribute */

#define	ATTRIB_VERIFICATION	4	/* verification is required on */
					/* input of this attribute */
#define	ATTRIB_PRESET		8	/* attribute is preset */
					/* no prompt during insertion */

/*
 * define vertex data structure
 */

struct	vertex	{
	FLOAT	point[3];		/* location of the vertex */
	INT	startwidthset;		/* if starting width is present */
	FLOAT	startwidth;		/* starting width, default is */
					/* defined by POLYLINE */
	INT	endwidthset;		/* if ending width is present */
	FLOAT	endwidth;		/* ending width, default is */
					/* defined by POLYLINE */
	FLOAT	bulge;			/* bulge, what is its meaning ? */
	INT	vertexflag;		/* vertex flag (bit-coded) */
	FLOAT	fittangentset;		/* if the fittangent is present */
	FLOAT	fittangent;		/* curve fit tangent direction */
	OPTIONS	*options;		/* optional parameters */
};

/*
 * define vertex flags (bit-coded)
 */

#define	VERTEX_EXTRA		1	/* extra vertex created by curve */
					/* fitting */
#define	VERTEX_TANGENT		2	/* curve fit tangent defined for */
					/* this vertex. a curve fit tangent */
					/* direction of 0 may be omitted from */
					/* the DXF output, but is significant */
					/* if this bit is set */
#define	VERTEX_UNUSED		4	/* unused (never set in DXF files */

#define	VERTEX_SPLINE		8	/* spline vertex created by spline */
					/* fitting */
#define	VERTEX_CONTROL		16	/* spline frame control point */

#define	VERTEX_POLYGON		32	/* 3D POLYLINE vertex */

#define	VERTEX_MESH		64	/* 3D POLYLINE mesh vertex */

/*
 * define value data structure for parsing
 */

struct	group	{
	INT	type;			/* type of result */
	INT	code;			/* group code */
	INT	intnum;			/* integer value */
	FLOAT	fltnum;			/* floating number */
	CHAR	*string;		/* string (text) */
};

#define	GROUP_VALUE_INTEGER	1
#define	GROUP_VALUE_FLOAT	2
#define	GROUP_VALUE_STRING	3

/*
 * define data structure for block insertion
 */

struct	insert	{
	INT	attribflag;		/* attributes follow flag, default 0 */
	CHAR	*blockname;		/* block name */
					/* used when the block has not */
					/* defined yet during parsing */
					/* will be freed later during */
					/* output, if the block is really */
					/* defined */
	BLOCK	*block;			/* pointer to the block */
	FLOAT	point[3];		/* insertion point */
	FLOAT	xscale;			/* X scale factor, default 1 */
	FLOAT	yscale;			/* Y scale factor, default 1 */
	FLOAT	zscale;			/* Z scale factor, default 1 */
	FLOAT	angle;			/* rotation angle, default 0 */
	INT	columncount;		/* repeat column counts, default 1 */
	FLOAT	columnspace;		/* repeat column spacing, default 0 */
	INT	rowcount;		/* repeat row counts, default 1 */
	FLOAT	rowspace;		/* repeat column spacing, default 0 */
/*	ATTRIB	*attriblist		 * attributes list, if any *
					 * not used now */
};
/*
 * define stack data structure for block handling
 */

struct	stack	{
	INSERT	*insert;		/* current insert block */
	MATRIX	singlematrix[2];	/* a pair of current transformation */
					/* matrix defined by the insert block */
	MATRIX	matrix[2];		/* a pair of transformation matrics */
					/* defined by multiply all matrics */
					/* of insert blocks */
};

/*
 * define max stack level
 */

#define	MaxStackLevel		64

/*
 * define object name data structure, for output only
 */

struct	name	{
	CHAR	*name;			/* object name, maybe a layer name, */
					/* block name + layer name */
	NAME	*next;			/* next name */
};

/*
 * define process function for entities
 */

struct	entityprocs	{
	INT	type;			/* entity type */
	ENTITY 	*(*dxfparse) ();	/* function for parsing of DXF file */
					/* return an entity pointer */
	VOID 	(*defoutput) ();	/* function for output of DEF file */
	VOID 	(*nffoutput) ();	/* function for output of NFF file */
	VOID 	(*dxfoutput) ();	/* function for output of DXF file */
	VOID 	(*radoutput) ();	/* function for output of RAD file */
					/* Greg Ward's RADIANCE package */
};

/*
 * define constants for circle/arc tesselation
 */

#define	DefaultMinCircleRadius	10.0
#define	MinCircleTesselation	12
#define	MaxCircleTesselation	360

/*
 * define some basic constants and macros
 */

#define	TRUE	1
#define	FALSE	0

#define	TOE	1.0e-10			/* tolerance error in */
					/* FLOAT number comparision */

#ifndef	M_PI
#define	M_PI	3.1415926535
#endif

#ifdef	MSDOS
#ifndef	DBL_MAX
#define	DBL_MAX	1.0e+38
#endif
#ifndef	HUGE
#define	HUGE	DBL_MAX
#endif
#endif

#ifndef	MAXFLOAT
#define	MAXFLOAT	HUGE
#endif

#define Malloc(typename, n)	((typename *) Alloc(sizeof(typename) * (n)))

#define	max(x,y)	((x) > (y) ? (x) : (y))
#define	min(x,y)	((x) < (y) ? (x) : (y))
#define	signof(i)	((i) >= 0 ? 1 :(-1))
#define	fabs(x)		((x) > 0.0 ? (x) : -(x))

/*
 * define macro for converting of angles between degrees and radius
 */

#define DEG_TO_RAD(x)	((FLOAT) (x) * M_PI / 180.0)
#define	RAD_TO_DEG(x)	((FLOAT) (x) * 180.0 / M_PI)

#ifndef	MSC
/*
 * define macros for vector operation
 */

#define	VecCopy(a,b)		((b)[0] = (a)[0],		\
				 (b)[1] = (a)[1],		\
				 (b)[2] = (a)[2])

#define	VecScale(s,a,b)		((b)[0] = (s) * (a)[0],		\
				 (b)[1] = (s) * (a)[1],		\
				 (b)[2] = (s) * (a)[2])

#define	VecAdd(a,b,c)		((c)[0] = (a)[0] + (b)[0],	\
				 (c)[1] = (a)[1] + (b)[1],	\
				 (c)[2] = (a)[2] + (b)[2])

#define	VecSub(a,b,c)		((c)[0] = (a)[0] - (b)[0],	\
				 (c)[1] = (a)[1] - (b)[1],	\
				 (c)[2] = (a)[2] - (b)[2])

#define	VecDot(a,b)		(FLOAT) ((a)[0] * (b)[0] +	\
					 (a)[1] * (b)[1] +	\
					 (a)[2] * (b)[2])

#define VecNegate(a, b)		((b)[0] = - (a)[0],		\
				 (b)[1] = - (a)[1],		\
				 (b)[2] = - (a)[2])

#define VecAddS(s,a,b,c)	((c)[0] = (s) * (a)[0] +(b)[0],	\
				 (c)[1] = (s) * (a)[1] +(b)[1],	\
				 (c)[2] = (s) * (a)[2] +(b)[2])

#define VecCross(a,b,c)		((c)[0] = (a)[1] * (b)[2] -(a)[2] * (b)[1], \
				 (c)[1] = (a)[2] * (b)[0] -(a)[0] * (b)[2], \
				 (c)[2] = (a)[0] * (b)[1] -(a)[1] * (b)[0])

#define	VecLength(s)		(FLOAT) sqrt(VecDot((s), (s)))
#else

/*
 * for MSC, use functions call instead for reducing code size
 */

extern	VOID	VecCopy();
extern	VOID	VecScale();
extern	VOID	VecAdd();
extern	VOID	VecSub();
extern	FLOAT	VecDot();
extern	VOID	VecNegate();
extern	VOID	VecAddS();
extern	VOID	VecCross();
extern	FLOAT	VecLength();

#endif

/*
 * define output file types
 */

#define	FILE_DEF	0		/* for DEF file used by Radiosity */
#define	FILE_NFF	1		/* for NFF file used by Raytracing */
#define	FILE_DXF	2		/* for exploded (3DFACE) DXF file */
#define	FILE_RAD	3		/* for exploded (3DFACE) DXF file */

/*
 * define error reporting macros
 */

#ifndef	MSC

/*
 * error during parsing a DXF file
 */

#define	DXFERR(fmt,arg)		{					     \
					fprintf(stderr, "\n%s: DXF file %s", \
					ProgName, DxfFileName);		     \
					if (DxfAscOrBin == 0)		     \
						fprintf(stderr,		     \
							" at line %d - ",    \
							DxfFileLine);	     \
					else				     \
					if (DxfAscOrBin == 1)		     \
						fprintf(stderr,		     \
							" at byte %d - ",    \
							DxfFileByte);	     \
					fprintf(stderr, fmt, arg);	     \
					exit(-1);			     \
				}

/*
 * general error
 */

#define	GENERR(fmt,arg)		{	 				     \
					/*				     \
					 * if it's parsing a DXF file        \
					 */				     \
									     \
					if (OutFile == NULL)		     \
						fprintf(stderr, "\n%s: ",    \
							ProgName);	     \
					else				     \
						fprintf(stderr, "%s: ",	     \
							ProgName);	     \
					fprintf(stderr, fmt, arg);	     \
					exit(-1);		    	     \
				}

#else

/*
 * for MSC, use function call instead for reducing code size
*/

extern	VOID	DXFERR();
extern	VOID	GENERR();

#endif

/*
 * define globle GetNextGroup function
 */

#define	GetNextGroup()		(*GlobleGetNextGroup[DxfAscOrBin]) ()

#include "extern.h"
#include "function.h"

#define 	_DXFCONVERT
#endif
