/* vertexlist.c */

#include "vertexlist.h"

VERTEX *VertexListFind(VERTEXLIST *vl, POINT *point, VECTOR *norm)
{
	VERTEX *v;

	while ((v = VertexListNext(&vl)))
		if (VECTOREQUAL(*point, *v->point) &&
		    ((!norm && !(v->normal)) ||
		     (norm && v->normal && VECTOREQUAL(*norm, *v->normal))))
			return v;

	return (VERTEX *)NULL;
}

