/* patchlist.c */

#include "patchlist.h"
#include "geom_methods.h"

float *PatchListBounds(PATCHLIST *pl, float *boundingbox)
{
	BOUNDINGBOX b;
	int count;
	PATCH *patch;

	BoundsInit(boundingbox);
	count = 0;
	while ((patch = PatchListNext(&pl))) {
		PatchBounds(patch, b);
		BoundsEnlarge(boundingbox, b);
		count ++;
	}

/* no bounding volume tests for single patches */
	if (count < 2) 
		return (float *)NULL;	
	else
		return boundingbox;
}

PATCH	*PatchListIntersect(PATCHLIST *pl, RAY *ray, float mindist, float *maxdist, int ShadowTesting)
{
	PATCH *p, *patch;

	patch = (PATCH *)NULL;
	while ((p = PatchListNext(&pl))) {
		if (PatchIntersect(p, ray, mindist, maxdist)) {
			if (ShadowTesting)
				return p;
			else
				patch = p;
		}
	}

	return patch;	
}

static void PatchlistDestroy(PATCHLIST *patchlist)
{
	PatchListDestroy(patchlist);
}

static void PatchlistPrint(FILE *out, PATCHLIST *patchlist)
{
	PatchListIterate1B(patchlist, PatchPrint, out);
}

static PATCHLIST *PatchlistPatchlist(PATCHLIST *patchlist)
{
	return patchlist;
}

static PATCHLIST *PatchlistDuplicate(PATCHLIST *patchlist)
{
	return PatchListDuplicate(patchlist);
}

GEOM_METHODS patchlistMethods = {
	(float *(*)(void *, float *))PatchListBounds,
	(void (*)(void *))PatchlistDestroy,
	(void (*)(FILE *, void *))PatchlistPrint,
	(PATCH *(*)(void *, RAY *, float, float *, int))PatchListIntersect,
	(GEOMLIST *(*)(void *))NULL,
	(PATCHLIST *(*)(void *))PatchlistPatchlist,
	(void *(*)(void *))PatchlistDuplicate
};

GEOM_METHODS *PatchListMethods(void)
{
	return &patchlistMethods;
}



