/* importance.h */

#ifndef _IMPORTANCE_H_
#define _IMPORTANCE_H_

/* directe importance is evenredig met aantal pixels op het scherm. We bepalen dus eerst
 * voor iedere pixel op het scherm het ID van de patch die er zichtbaar is (0 indien geen 
 * enkele patch er aichtbaar is). We tellen vervolgens in patchpixels[i] hoeveel pixels de
 * patch met ID i op het scherm inneemt. Door te delen door het totaal aantal pixels op
 * het scherm (gebeurt in PatchUpdateDirectImportance()) bekomen we directe importances
 * die onafhankelijk van de schermgrootte zijn en netjes tussen 0 en 1 liggen. */
extern void UpdateDirectImportance(void);

/* stel routine in om nieuwe directe importance van een patch in te vullen 
 * (deze routine verschilt naargelang het gebruikte radiositeitsalgoritme).
 * eerste arg: patch waarvan de directe importance aangepast moet worden,
 * tweede argument: een array waarvan het i-de element de nieuwe directe
 * importance van de patch met ID i is. */
#include "patch.h"
extern void SetPatchDirectImportanceUpdateRoutine(void (*routine)(PATCH *, float *));

#endif /*_IMPORTANCE_H_*/
