/* globals.h: globale variabelen nodig voor radiantieberekening */

#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include <time.h>
extern float usecs_last_phase, usecs_total;
extern float usecs_last_id_rendering, usecs_last_importance_propagation,
     usecs_ff_computation, usecs_shaftculling, usecs_last_radiance_propagation;

extern int	iterationr;

extern float radiance_rescale, maxpower;

/* gebruikt bij keuze van "patch die de grootste volgende bijdrage levert" */
extern float	Beps;	/* vermogens kleiner dan dit worden niet gepropageerd */
extern float	Ieps;	/* importances kleiner dan dit worden niet gepropageerd */

/* toleranties voor hierarchische verfijning */
extern float	Aeps;	/* oppervalktes kleiner dan dit worden nooit verfijnd */
extern float	Feps;	/* vormfactoren met deze tolerantie zijn aanvaardbaar */
extern float 	BFeps;	/* voor BF verfijning - wordt automatisch bepaald */
extern float 	epsfac;	/* om BFeps ... gradueel kleiner te maken in gathering rad. */

/* voor wel of geen gebruik van importantie */
extern char	ImportanceDriven;

/* voor wel of geen hierarchische verfijning */
extern char	HierarchicalRefinement;

/* zet op TRUE voor demo mode */
extern char demo;

/* TRUE als de radiantieberekeningen bezig zijn - wordt ingesteld in main.c */
extern char working;

/* algoritme-types */
#define SOUTHWELL	1
#define GAUSS_SEIDEL	2
extern char SolutionMethod;

/* TRUE for visualisation with ambient term */
extern int render_ambient;

/* instellen of gebruik gemaakt moet worden van importance of niet */
extern void SetImportanceDriven(int bool);

/* instellen of hierarchisch verfijnd moet worden */
extern void SetHierarchicalRefinement(int bool);

/* instellen van demo mode */
extern void SetDemoMode(int bool);

/* toleranties instellen */
extern void SetTolerances(float Aeps, 	/* patches kleiner dan deze worden nooit verfijnd */
			  float Feps,	/* max. fout op vormfactoren */
			  float	Beps,	/* min. te propageren vermogen - progr. rad. */
			  float Ieps);	/* min. te propageren importance - progr. rad. */

extern char shaftcullmode;
#define SHAFTCULL_NEVER		0
#define SHAFTCULL_REFINE	1
#define SHAFTCULL_ALWAYS	2

extern void SetShaftcullMode(int mode);

extern void SetRenderAmbient(int bool);

#endif /*_GLOBALS_H_*/
