/* formfactor.h */

#ifndef _FORMFACTOR_H_
#define _FORMFACTOR_H_

#include "patchlist.h"
#include "geomlist.h"
#include "cubature.h"
#include "Float.h"

/* returns TRUE if the patches are facing each other and FALSE if not */
extern int Facing(PATCH *p, PATCH *q);

/* computes the coupling coefficients between the two given patches. We assume that
 * p is the patch that receives light from q. shadowlist is a list of potential
 * occluders. The coupling coefficients are filled in the matrix FF that should
 * have at laast currentBasis->size rows and columns. Some "geometric"
 * information needed for approximation error estimation is returned. The coupling
 * coefficients do not contain the reflectivity of the receiving patch. In this
 * version of the program, this reflectivity is a constant. This may change when
 * texturing will be implemented. vis will contain visibility information: 
 * *vis == 0 if the patches don't interact with each other. */
extern Float AreaToAreaFormFactor(PATCH *p, PATCH *q, GEOMLIST *shadowlist, 
				  Float FF[][], int *vis);

/* sets the cubature rules to be used for formfactor computation and approximation error
 * estimation: different rules for ReCeiVing and EMitting TRIangular or 
 * QUADrilateral patches.  
 * passing NULL for a parameter will leave the corresponding rule unchanged. */
extern void SetCubatureRules(CUBARULE *rcvtri, CUBARULE *rcvquad, 
			     CUBARULE *emtri, CUBARULE *emquad);

#endif /*FORMFACTOR_H_*/
