/* defaults.h */

#ifndef _DEFAULTS_H_
#define _DEFAULTS_H_

#include "render.h"
#include "radiance.h"
#include "formfactor.h"
#include "bases.h"
#include "movie.h"

/* defines the name of the X application defaults file */
#define APP_CLASS_NAME   	"Rad"

/* rendering */
#define DEFAULT_GOURAUDSHADING 		True
#define DEFAULT_BACKFACECULLING 	True
#define DEFAULT_OUTLINEDRAWING 		False
#define DEFAULT_OUTLINECOLOR 		{0., 1., 0.}
#define DEFAULT_SHOWLINKS		False
#define DEFAULT_LINKCOLOR		{0., 1., 1.}
#define DEFAULT_RENDERINGMODE		RENDER_RADIANCE
#define DEFAULT_TVERTEXELIMINATION	True
#define DEFAULT_RENDER_AMBIENT		True

/* radiance computation */
#define DEFAULT_SOLUTION_METHOD		SOUTHWELL

#define DEFAULT_BEPS 			1e-4
#define DEFAULT_IEPS			1e-3
#define DEFAULT_AEPS			1e-3
#define DEFAULT_FEPS			1e-4
#define DEFAULT_IMPORTANCE_DRIVEN	FALSE
#define DEFAULT_HIERARCHICAL_REFINEMENT	TRUE

/* basis set to be used by default */
#define DEFAULT_QUAD_BASIS		constantBasis
#define DEFAULT_TRI_BASIS		constantBasis

/* cubature rules to be used to compute formfactors and so on */
#define DEFAULT_CR_RCV_DEG		3	/* cubature rule degree to be used on receiver patches */
#define DEFAULT_CR_SRC_DEG		3	/* idem for source patches */

#define DEFAULT_SHAFTCULL_MODE		SHAFTCULL_REFINE

#define DEFAULT_DEMOMODE		TRUE

/* camera */
#define DEFAULT_EYEP			{10., 0., 0.}
#define DEFAULT_LOOKP			{ 0., 0., 0.}
#define DEFAULT_UPDIR			{ 0., 0., 1.}
#define DEFAULT_FOV			22.5
#define DEFAULT_BACKGROUND		{0., 0., 0.}

/* movie mode options */
#define DEFAULT_MOVIE_OPTIONS		MOVIE_SAVE_RADIANCE
#define DEFAULT_MOVIE_MODE		FALSE

/* gamma correction */
#ifndef GAMMA
#define GAMMA 1.0
#endif /*GAMMA*/
#define DEFAULT_GAMMA			GAMMA

/* MGF file format options */
#define DEFAULT_MGF_NQCDIVS		2
#define DEFAULT_MGF_IGNORE_SIDEDNESS	TRUE

#endif /*_DEFAULTS_H_*/

