/**********************************************************************/
/* auto.h                                                             */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef AUTO_H
#define AUTO_H

#define WRITEF "w"
#define READF "r"
#define HEAD_NMOVES    "nmoves"
#define HEAD_TRANSLATE "Move T {"
#define HEAD_ROTATE    "Move R {"
#define HEAD_SPIN      "Move P {"
#define HEAD_SCALE     "Move S {"
#define HEAD_ZOOM      "Move Z {"
#define HEAD_ABSOLUTE  "Move A {"

#define MOVEABS 'A'         /* Movement to absolute position          */
#define MOVEREL_ROT 'R'     /* Rotation in X,Y relative to eye        */
#define MOVEREL_SPIN 'P'    /* Rotation in Z relative to eye          */
#define MOVEREL_SCALE 'S'   /* Scale image movement relative to eye   */
#define MOVEREL_TRANSL 'T'  /* Translation in X,Y relative to eye     */
#define MOVEREL_ZOOM 'Z'    /* Translation in Z relative to eye       */
char Movetype;              /* Type of move reading in                */

/**********************************************************************/
/* Prototypes                                                         */
/**********************************************************************/
void PrintRelMove();
void PrintAbsMove();
int OpenMoveFile(/* char*filename, char *filemode*/);
int ReadMoves();

RelMovement *CreateRelMove();
AbsMovement *CreateAbsMove();
void ClearOrientLog();
void LogRelMove();
void LogAbsMove();

void InitMoveLog(/* char*filename, char mode, int nmoves*/);
void WriteRelMove(/* *RelMovement, int mtype */);
void WriteAbsMove(/* *AbsMovement */);
int WriteMoves(/* *char filename, *Movement, int nmoves */);

#endif /* AUTO_H */
