/**********************************************************************/
/* conv.c                                                             */
/*                                                                    */
/* For storing points to show converge in radiosity per iteration     */
/* Plot total radiosity left versus iteration. Show data every n      */
/* iterations by default, where n = label_freq variable.              */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#include <stdio.h>
#include <string.h>

extern char *ProgName;

int label_freq = 1;           /* Label frequency */
FILE *convfile;               /* File of data points of convergence */
char *convfilename =          /* Filename */
  "                              ";

/**********************************************************************/
/* Switch log on / off */
/**********************************************************************/
void LogConv(logflag,fname)
     int logflag;
{
  if (logflag) {
    sprintf(convfilename,"%s.conv",fname);   /* Convergence log */
    if (!(convfile = fopen(convfilename, "w"))) {
      fprintf(stderr,"%s: cannot open log file %s\n", ProgName, convfilename);
      exit(1);
    } 
    printf("\n\t*** Print convergence data to %s ***\n",convfilename);
  } else 
    fclose(convfile);
}

/**********************************************************************/
/* Log pair of data */
/**********************************************************************/
void LogConv_Pt(iter,value)
     int iter;
     double value;
{
  if ((iter % label_freq) == 0) /* Every n iterations ? */
    fprintf(convfile,"%g %g\n", (float)iter, value);
}
