/**********************************************************************/
/* rayhit.c :                                                         */
/*                                                                    */
/* Intersection support routines                                      */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#include <stdio.h>
#include "geo.h"
#include "struct.h"
#include "io.h"
#include "misc.h"
#define RAY_HITC 1
#include "ray.h"

extern OptionType Option;

/**********************************************************************/
/* Reset hit data. Set not object hit, and maximum distance for ray   */
/**********************************************************************/
void Reset_Hit(hit, max_distance)
     HitData *hit;
     double max_distance;
{
  hit->obj = (Objectt *)NULL;
  hit->poly = (Polygon *)NULL;
  hit->mesh = (Mesh *)NULL;
  if (Option.visibility == RAY_TRACE ||
      Option.visibility == RAY_CAST) {
    hit->distance= 4.0 * UNIVERSE;          /* Drawing scene          */
  } else if (Option.visibility == FORM_FACTOR) {
    hit->distance = max_distance;           /* Computing form-factors */
  }
}

/**********************************************************************/
/* Update hit intersection information */
/**********************************************************************/
void Store_HitInter(hit,optr,t,x,y,z)
     register HitData *hit;
     register Objectt *optr;
     double t,x,y,z;
{
  hit->obj = optr;
  hit->distance= t;
  hit->intersect.x= x;
  hit->intersect.y= y;
  hit->intersect.z= z;
}

/**********************************************************************/
/* Update hit intersection normal information */
/**********************************************************************/
void Store_HitNorm(hit,x,y,z)
     register HitData *hit;
     double x,y,z;
{
  hit->normal.x= x;
  hit->normal.y= y;
  hit->normal.z= z;
}

