/* FILE: filter.h

   Prototypes for filter routines are here.

   Written by Petri Kuittinen, last modifications 10th August 1993.
*/ 

void invert_block1 (struct picture *pic_p);
void invert_block2 (struct picture *pic_p);
void invert_block3 (struct picture *pic_p);
void rgb_adjust_block1 (struct picture *pic_p, double r_scale, double g_scale,
			double b_scale, int r_add, int g_add, int b_add);
void rgb_adjust_block2 (struct picture *pic_p, double r_scale, double g_scale,
			double b_scale, int r_add, int g_add, int b_add);
void rgb_adjust_block3 (struct picture *pic_p, double r_scale, double g_scale,
			double b_scale, int r_add, int g_add, int b_add);
void do_5x5_matrix_block1 (struct picture *pic_p, double mul, double div,
			   double *mat);
void do_5x5_matrix_block2 (struct picture *pic_p, double mul, double div,
			   double *mat);
void do_5x5_matrix_block3 (struct picture *pic_p, double mul, double div,
			   double *mat);
void add_noise_block1 (struct picture *pic_p, int range);
void add_noise_block2 (struct picture *pic_p, int range);
void add_noise_block3 (struct picture *pic_p, int range);
void hsv_adjust_block1 (struct picture *pic_p, double h_add, double s_add,
			double v_add);
void hsv_adjust_block2 (struct picture *pic_p, double h_add, double s_add,
			double v_add);
void hsv_adjust_block3 (struct picture *pic_p, double h_add, double s_add,
			double v_add);
