/* FILE: draw.h

   Prototypes for basic drawing functions.

   Written by Petri Kuittinen, last modifications 15th July 1993.
*/ 

void line (int x1, int y1, int x2, int y2, void (*put_pixel) (int x, int y));
void hline (int x1, int x2, int y, void (*put_pixel) (int x, int y));
void vline (int x, int y1, int y2, void (*put_pixel) (int x, int y));
void circle (int xc, int yc, int r, void (*put_pixel) (int x, int y));
void fill_circle (int xc, int yc, int r, void (*put_pixel) (int x, int y));
void ellipse (int xc, int yc, int rx, int ry, void (*put_pixel)(int x, int y));
void fill_ellipse (int xc, int yc, int rx, int ry,
		   void (*put_pixel)(int x, int y));
void box (int x1, int y1, int x2, int y2, void (*put_pixel) (int x, int y));
void fill_box (int x1, int y1, int x2, int y2,
	       void (*put_pixel) (int x, int y));
