/*
 callb.c: Callbacks for all the menu and tool buttons. Too long!

 $Header: callb.c,v 2.19 93/09/03 14:46:08 wet Exp $ 
 */
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/Scale.h>
#include <stdio.h>
#include <stdlib.h>
#include "list.h"
#include "tools1.h"
#include "window.h"
#include "dialogw.h"
#include "callb.h"
#include "X_misc.h"
#include "bitmaps.h"
#include "file_access.h"
#include "error.h"
#include "undo.h"
#include "misc.h"

/* FUNCTION:       generic_callback(Widget widget_id, char *client_data,
                                    caddr_t call_data)
   DESCRIPTION:    Used for debugging purposes only.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 28th June 1993.
*/   
void generic_callback (Widget widget_id, char *client_data, caddr_t call_data)
{
  printf("Menu entry %s has not been implemented in this demo version.\n",
	 client_data);
}


/* FUNCTION:       lower_toolbox(Widget widget_id, caddr_t client_data,
                                 XEvent *call_data)
   DESCRIPTION:    Lowers the toolbox to the bottom of the stacking
                   order if the right mouse button is pressed.
   PARAMETERS:
   Widget widget_id    Widget id of the widget that caused the callback.
   caddr_t client_data Not used.
   XEvent *call_data   Pointer to the XEvent structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 18th August 1993.
*/   
void lower_toolbox(Widget widget_id, caddr_t client_data, XEvent *call_data)
{
  if (call_data->xbutton.button==3)
    XLowerWindow(XtDisplay (toplevel), XtWindow (toplevel));
}


/* FUNCTION:       delete_toolbox(Widget widget_id, caddr_t client_data,
                                  XEvent *call_data)
   DESCRIPTION:    Handles WM_DELETE_WINDOW protocol clientmessages. Obsolete
                   at this point.
   PARAMETERS:
   Widget widget_id    Widget id of the widget that caused the callback.
   caddr_t client_data Not used.
   XEvent *call_data   Pointer to the XEvent structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 19th August 1993.
*/   
void delete_toolbox(Widget widget_id, caddr_t client_data, XEvent *call_data)
{
  exit_init();
}



/* FUNCTION:       button_arm_callback (Widget widget_id, int client_data,
                                        caddr_t call_data)
   DESCRIPTION:    Callback for the tool buttons. Changes the pixmap to one
                   that appears pressed and calls the appropriate routine
		   in the main module. Resets the button in the group that was
		   set before.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback. DO NOT
                      USE THIS VALUE! This callback is called from other 
		      functions as well as via the callback mechanism. This
		      can be NULL! (use tool_btns[client_data] instead)
   int client_data   Button index.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 29th July 1993.
*/   
void button_arm_callback(Widget widget_id, int client_data,
			 caddr_t call_data)
{
  extern struct view *cur_view;
  Arg wargs[10];
  Cardinal n;
  Pixel bs, ts;

  /* get the real shadow colors */
  n = 0;
  XtSetArg (wargs[n], XmNtopShadowColor, &ts); n++;
  XtSetArg (wargs[n], XmNbottomShadowColor, &bs); n++;
  if (tool_set!=TB_POINT)
    XtGetValues(tool_btns[TB_POINT], wargs, n);
  else 
    XtGetValues(tool_btns[TB_LINE], wargs, n);
  
  switch (client_data)
    {
    case TB_POINT:
    case TB_LINE:
    case TB_CIRCLE:
    case TB_BOXSELECT:
    case TB_LASSOSELECT:
    case TB_DRAW:
    case TB_POLYLINE:
    case TB_ELLIPSE:
    case TB_ELLIPSESELECT:
    case TB_AIRBRUSH:
    case TB_FILL:
    case TB_COLOREXT:
    case TB_BOX:
    case TB_POLYGONSELECT:
    case TB_COLORSELECT:
      n = 0;
      XtSetArg(wargs[n], XmNtopShadowColor, ts); n++;
      XtSetArg(wargs[n], XmNbottomShadowColor, bs); n++;
      XtSetArg(wargs[n], XmNlabelPixmap, tool_bmps[tool_set]); n++;
      XtSetValues(tool_btns[tool_set], wargs, n);
      
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data+NO_PIXMAPS]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      toolbranch(cur_view, 0, 0, NONE, CANCEL);
      switch (client_data)
	{
	case TB_POINT:
	  set_tool(POINT);
	  break;
	case TB_LINE:
	  set_tool(LINE);
	  break;
	case TB_CIRCLE:
	  set_tool(CIRCLE);
	  break;
	case TB_BOXSELECT:
	  set_tool(RECT_S);
	  break;
	case TB_LASSOSELECT:
	  set_tool(LASSO_S);
	  break;
	case TB_DRAW:
	  set_tool(DRAW);
	  break;
	case TB_POLYLINE:
	  set_tool(POLYLINE);
	  break;
	case TB_ELLIPSE:
	  set_tool(ELLIPSE);
	  break;
	case TB_ELLIPSESELECT:
	  set_tool(ELLIPSE_S);
	  break;
	case TB_AIRBRUSH:
	  set_tool(AIRBRUSH);
	  break;
	case TB_FILL:
	  set_tool(FLOOD_FILL);
	  break;
	case TB_COLOREXT:
	  set_tool(COLOR_EXT);
	  break;
	case TB_BOX:
	  set_tool(RECTANGLE);
	  break;
	case TB_POLYGONSELECT:
	  set_tool(POLY_S);
	  break;
	case TB_COLORSELECT:
	  set_tool(COLOR_S);
	  break;
	}
      break;
    case TB_EVERYWHERE:
    case TB_INSIDE:
    case TB_OUTSIDE:
      n = 0;
      XtSetArg(wargs[n], XmNtopShadowColor, ts); n++;
      XtSetArg(wargs[n], XmNbottomShadowColor, bs); n++;
      XtSetArg(wargs[n], XmNlabelPixmap, tool_bmps[maskmode_set]); n++;
      XtSetValues(tool_btns[maskmode_set], wargs, n);
      
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data+NO_PIXMAPS]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      toolbranch(cur_view, 0, 0, NONE, CANCEL);
      switch (client_data)
	{
	case TB_EVERYWHERE:
	  XmToggleButtonSetState(get_menu_widget("Everywhere"), True, False);
	  XmToggleButtonSetState(get_menu_widget("Inside mask"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Outside mask"), False,
				 False);
	  flagbranch(EVERYWHERE);
	  break;
	case TB_INSIDE:
	  XmToggleButtonSetState(get_menu_widget("Everywhere"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Inside mask"), True, False);
	  XmToggleButtonSetState(get_menu_widget("Outside mask"), False,
				 False);
	  flagbranch(INSIDE);
	  break;
	case TB_OUTSIDE:
	  XmToggleButtonSetState(get_menu_widget("Everywhere"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Inside mask"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Outside mask"), True, False);
	  flagbranch(OUTSIDE);
	  break;
	}
      break;
    case TB_REPLACE:
    case TB_ADD:
    case TB_SUBSTRACT:
      n = 0;
      XtSetArg(wargs[n], XmNtopShadowColor, ts); n++;
      XtSetArg(wargs[n], XmNbottomShadowColor, bs); n++;
      XtSetArg(wargs[n], XmNlabelPixmap, tool_bmps[drawmode_set]); n++;
      XtSetValues(tool_btns[drawmode_set], wargs, n);
      
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data+NO_PIXMAPS]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      toolbranch(cur_view, 0, 0, NONE, CANCEL);
      switch (client_data)
	{
	case TB_REPLACE:
	  XmToggleButtonSetState(get_menu_widget("Replace"), True, False);
	  XmToggleButtonSetState(get_menu_widget("Add"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Substract"), False, False);
	  flagbranch(REPLACE);
	  break;
	case TB_ADD:
	  XmToggleButtonSetState(get_menu_widget("Replace"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Add"), True, False);
	  XmToggleButtonSetState(get_menu_widget("Substract"), False, False);
	  flagbranch(ADD);
	  break;
	case TB_SUBSTRACT:
	  XmToggleButtonSetState(get_menu_widget("Replace"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Add"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Substract"), True, False);
	  flagbranch(SUB);
	  break;
	}
      break;
    case TB_PERIM:
    case TB_FILLED:
    case TB_FILLEDPERIM:
      n = 0;
      XtSetArg(wargs[n], XmNtopShadowColor, ts); n++;
      XtSetArg(wargs[n], XmNbottomShadowColor, bs); n++;
      XtSetArg(wargs[n], XmNlabelPixmap, tool_bmps[perimmode_set]); n++;
      XtSetValues(tool_btns[perimmode_set], wargs, n);
      
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data+NO_PIXMAPS]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      toolbranch(cur_view, 0, 0, NONE, CANCEL);
      switch (client_data)
	{
	case TB_PERIM:
	  if (perimmode_set==TB_PERIM)
	    break;
	  else if (perimmode_set==TB_FILLED)
	    {
	      flagbranch(FILLED);
	      flagbranch(PERIMETER);
	    }
	  else if (perimmode_set==TB_FILLEDPERIM)
	    flagbranch(FILLED);
	  XmToggleButtonSetState(get_menu_widget("Perimeters"), True, False);
	  XmToggleButtonSetState(get_menu_widget("Filled"), False, False);
	  break;
	case TB_FILLED:
	  if (perimmode_set==TB_FILLED)
	    break;
	  else if (perimmode_set==TB_PERIM)
	    {
	      flagbranch(PERIMETER);
	      flagbranch(FILLED);
	    }
	  else if (perimmode_set==TB_FILLEDPERIM)
	    flagbranch(PERIMETER);
	  XmToggleButtonSetState(get_menu_widget("Perimeters"), False, False);
	  XmToggleButtonSetState(get_menu_widget("Filled"), True, False);
	  break;
	case TB_FILLEDPERIM:
	  if (perimmode_set==TB_FILLEDPERIM)
	    break;
	  else if (perimmode_set==TB_PERIM)
	    flagbranch(FILLED);
	  else if (perimmode_set==TB_FILLED)
	    flagbranch(PERIMETER);
	  XmToggleButtonSetState(get_menu_widget("Perimeters"), True, False);
	  XmToggleButtonSetState(get_menu_widget("Filled"), True, False);
	  break;
	}
      break;
    case TB_SHOWMASK:
      toolbranch(cur_view, 0, 0, NONE, CANCEL);
      if (showedge_set)
	{
	  n = 0;
	  XtSetArg(wargs[n], XmNtopShadowColor, ts); n++;
	  XtSetArg(wargs[n], XmNbottomShadowColor, bs); n++;
	  XtSetArg(wargs[n], XmNlabelPixmap, tool_bmps[client_data]); n++;
	  XtSetValues(tool_btns[client_data], wargs, n);
	  XmToggleButtonSetState(get_menu_widget("Show mask"), False, False);
	  flagbranch(SHOW_EDGE);
	}
      else
	{
	  XtSetArg(wargs[0], XmNlabelPixmap,
		   tool_bmps[client_data+NO_PIXMAPS]);
	  XtSetValues(tool_btns[client_data], wargs, 1);
	  XmToggleButtonSetState(get_menu_widget("Show mask"), True, False);
	  flagbranch(SHOW_EDGE);
	}
      break;
    case TB_BRUSHOPT:
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data+NO_PIXMAPS]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      break;
    case TB_FILLOPT:
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data+NO_PIXMAPS]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      break;
    case TB_SELECTALL:
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data+NO_PIXMAPS]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      if (XtIsSensitive(get_menu_widget("Edit")))
	select_all();
      break;
    case TB_DESELECTALL:
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data+NO_PIXMAPS]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      if (XtIsSensitive(get_menu_widget("Edit")))
	deselect_all();
      break;
    default:
      break;
    }
}


/* FUNCTION:       button_disarm_callback(Widget widget_id, int client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Callback for the tool buttons. Switches the bottom and
                   to shadow colors to give an impression of a depressed 
		   button.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback. DO NOT
                      USE THIS VALUE! This callback is called from other 
		      functions as well as via the callback mechanism. This
		      can be NULL! (use tool_btns[client_data] instead)
   int client_data   Button index.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 29th July 1993.
*/   
void button_disarm_callback(Widget widget_id, int client_data,
			    caddr_t call_data)
{
  Arg wargs[10];
  Cardinal n;
  Pixel bs, ts;

  n = 0;
  XtSetArg(wargs[n], XmNtopShadowColor, &ts); n++;
  XtSetArg(wargs[n], XmNbottomShadowColor, &bs); n++;
  if (tool_set!=TB_POINT)
    XtGetValues(tool_btns[TB_POINT], wargs, n);
  else 
    XtGetValues(tool_btns[TB_LINE], wargs, n);

  switch (client_data)
    {
    case TB_POINT:
    case TB_LINE:
    case TB_CIRCLE:
    case TB_BOXSELECT:
    case TB_LASSOSELECT:
    case TB_DRAW:
    case TB_POLYLINE:
    case TB_ELLIPSE:
    case TB_ELLIPSESELECT:
    case TB_AIRBRUSH:
    case TB_FILL:
    case TB_COLOREXT:
    case TB_BOX:
    case TB_POLYGONSELECT:
    case TB_COLORSELECT:
      n = 0;
      XtSetArg(wargs[n], XmNtopShadowColor, bs); n++;
      XtSetArg(wargs[n], XmNbottomShadowColor, ts); n++;
      XtSetValues(tool_btns[client_data], wargs, n);
      tool_set = client_data;
      break;
    case TB_EVERYWHERE:
    case TB_INSIDE:
    case TB_OUTSIDE:
      n = 0;
      XtSetArg(wargs[n], XmNtopShadowColor, bs); n++;
      XtSetArg(wargs[n], XmNbottomShadowColor, ts); n++;
      XtSetValues(tool_btns[client_data], wargs, n);
      maskmode_set = client_data;
      break;
    case TB_REPLACE:
    case TB_ADD:
    case TB_SUBSTRACT:
      n = 0;
      XtSetArg(wargs[n], XmNtopShadowColor, bs); n++;
      XtSetArg(wargs[n], XmNbottomShadowColor, ts); n++;
      XtSetValues(tool_btns[client_data], wargs, n);
      drawmode_set = client_data;
      break;
    case TB_PERIM:
    case TB_FILLED:
    case TB_FILLEDPERIM:
      n = 0;
      XtSetArg(wargs[n], XmNtopShadowColor, bs); n++;
      XtSetArg(wargs[n], XmNbottomShadowColor, ts); n++;
      XtSetValues(tool_btns[client_data], wargs, n);
      perimmode_set = client_data;
      break;
    case TB_SHOWMASK:
      if (!showedge_set)
      {
	n = 0;
	XtSetArg(wargs[n], XmNtopShadowColor, bs); n++;
	XtSetArg(wargs[n], XmNbottomShadowColor, ts); n++;
	XtSetValues(tool_btns[client_data], wargs, n);
	showedge_set = True;
      }
      else 
	showedge_set = False;
      break;
    case TB_BRUSHOPT:
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      center_window(op_brush_dialog);
      XtManageChild(op_brush_dialog);
      break;
    case TB_FILLOPT:
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      center_window(op_fill_dialog);
      XtManageChild(op_fill_dialog);
      break;
    case TB_SELECTALL:
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      break;
    case TB_DESELECTALL:
      XtSetArg(wargs[0], XmNlabelPixmap, tool_bmps[client_data]);
      XtSetValues(tool_btns[client_data], wargs, 1);
      break;
    default:
      break;
    }
}



/* FUNCTION:       tool_callback(Widget widget_id, int client_data,
                                 caddr_t call_data)
   DESCRIPTION:    Tool callback, tool #defines in tools.h. If the tool is
                   in the toolbox, the button callbacks are called, otherwise,
		   main module routine is called.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Tool number.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 10th August 1993.
*/   
void tool_callback(Widget widget_id, int client_data, caddr_t call_data)
{
  switch (client_data)
    {
    case POINT:
      button_arm_callback((Widget)NULL, TB_POINT, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_POINT, (caddr_t)NULL);
      break;
    case DRAW:
      button_arm_callback((Widget)NULL, TB_DRAW, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_DRAW, (caddr_t)NULL);
      break;
    case AIRBRUSH:
      button_arm_callback((Widget)NULL, TB_AIRBRUSH, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_AIRBRUSH, (caddr_t)NULL);
      break;
    case LINE:
      button_arm_callback((Widget)NULL, TB_LINE, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_LINE, (caddr_t)NULL);
      break;
    case POLYLINE:
      button_arm_callback((Widget)NULL, TB_POLYLINE, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_POLYLINE, (caddr_t)NULL);
      break;
    case RECTANGLE:
      button_arm_callback((Widget)NULL, TB_BOX, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_BOX, (caddr_t)NULL);
      break;
    case CIRCLE:
      button_arm_callback((Widget)NULL, TB_CIRCLE, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_CIRCLE, (caddr_t)NULL);
      break;
    case ELLIPSE:
      button_arm_callback((Widget)NULL, TB_ELLIPSE, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_ELLIPSE, (caddr_t)NULL);
      break;
    case RECT_S:
      button_arm_callback((Widget)NULL, TB_BOXSELECT, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_BOXSELECT, (caddr_t)NULL);
      break;
    case ELLIPSE_S:
      button_arm_callback((Widget)NULL, TB_ELLIPSESELECT, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_ELLIPSESELECT, (caddr_t)NULL);
      break;
    case POLY_S:
      button_arm_callback((Widget)NULL, TB_POLYGONSELECT, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_POLYGONSELECT, (caddr_t)NULL);
      break;
    case LASSO_S:
      button_arm_callback((Widget)NULL, TB_LASSOSELECT, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_LASSOSELECT, (caddr_t)NULL);
      break;
    case COLOR_S:
      button_arm_callback((Widget)NULL, TB_COLORSELECT, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_COLORSELECT, (caddr_t)NULL);
      break;
    case COLOR_EXT:
      button_arm_callback((Widget)NULL, TB_COLOREXT, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_COLOREXT, (caddr_t)NULL);
      break;
    case FLOOD_FILL:
      button_arm_callback((Widget)NULL, TB_FILL, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_FILL, (caddr_t)NULL);
      break;
    }
}


/* FUNCTION:       flag_callback(Widget widget_id, int client_data,
                                 caddr_t call_data)
   DESCRIPTION:    Callback for the menu togglebuttons. Call the button 
                   callbacks.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Flag number.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 14th July 1993.
*/   
void flag_callback(Widget widget_id, int client_data, caddr_t call_data)
{
  switch (client_data)
    {
    case REPLACE:
      button_arm_callback((Widget)NULL, TB_REPLACE, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_REPLACE, (caddr_t)NULL);
      break;
    case ADD:
      button_arm_callback((Widget)NULL, TB_ADD, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_ADD, (caddr_t)NULL);
      break;
    case SUB:
      button_arm_callback((Widget)NULL, TB_SUBSTRACT, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_SUBSTRACT, (caddr_t)NULL);
      break;
    case EVERYWHERE:
      button_arm_callback((Widget)NULL, TB_EVERYWHERE, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_EVERYWHERE, (caddr_t)NULL);
      break;
    case INSIDE:
      button_arm_callback((Widget)NULL, TB_INSIDE, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_INSIDE, (caddr_t)NULL);
      break;
    case OUTSIDE:
      button_arm_callback((Widget)NULL, TB_OUTSIDE, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_OUTSIDE, (caddr_t)NULL);
      break;
    case PERIMETER:
      if (perimmode_set!=TB_PERIM)
	{
	  if (perimmode_set==TB_FILLED)
	    {
	      button_arm_callback((Widget)NULL, TB_FILLEDPERIM, (caddr_t)NULL);
	      button_disarm_callback((Widget)NULL, TB_FILLEDPERIM, 
				     (caddr_t)NULL);
	    }
	  else
	    {
	      button_arm_callback((Widget)NULL, TB_FILLED, (caddr_t)NULL);
	      button_disarm_callback((Widget)NULL, TB_FILLED, (caddr_t)NULL);
	    }
	}
      else
	XmToggleButtonSetState(get_menu_widget("Perimeters"), True, False);
      break;
    case FILLED:
      if (perimmode_set!=TB_FILLED)
	{
	  if (perimmode_set==TB_PERIM)
	    {
	      button_arm_callback((Widget)NULL, TB_FILLEDPERIM, (caddr_t)NULL);
	      button_disarm_callback((Widget)NULL, TB_FILLEDPERIM,
				     (caddr_t)NULL);
	    }
	  else
	    {
	      button_arm_callback((Widget)NULL, TB_PERIM, (caddr_t)NULL);
	      button_disarm_callback((Widget)NULL, TB_PERIM, (caddr_t)NULL);
	    }
	}
      else
	XmToggleButtonSetState(get_menu_widget("Filled"), True, False);
      break;
    case SHOW_EDGE:
      button_arm_callback((Widget)NULL, TB_SHOWMASK, (caddr_t)NULL);
      button_disarm_callback((Widget)NULL, TB_SHOWMASK, (caddr_t)NULL);
      break;
    default:
      break;
    }
}



/*****************************************************************************
 *                            File/New... callbacks                          *
 *****************************************************************************/
/* FUNCTION:       file_new_callback(Widget widget_id, char *client_data,
                                     caddr_t call_data)
   DESCRIPTION:    Callback for the new.. button in the toolbox menu: 
                   Pops up the dialog and returns.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 9th June 1993.
*/   
void file_new_callback(Widget widget_id, char *client_data, caddr_t call_data)
{
  Arg wargs[2];
  char name[15];
  XtSetArg(wargs[0], XmNvalue, "500");
  XtSetValues(new_edit[WIDTH], wargs, 1);
  XtSetValues(new_edit[HEIGHT], wargs, 1);
  sprintf(name, "NoName%02d.ppm", new_times);
  XtSetArg(wargs[0], XmNvalue, name);
  XtSetValues(new_edit[NAME], wargs, 1);
  
  center_window(fi_new_dialog);
  XtManageChild(fi_new_dialog);
}



/* FUNCTION:       new_dialog_callback(Widget widget_id, int client_data,
                                   caddr_t call_data)
   DESCRIPTION:    Callback for the ok button in the File/New... dialog: 
                   creates a pic, a view and a view_window.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in X_misc.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 9th July 1993.
*/   
void new_dialog_callback(Widget widget_id, int client_data, 
			 caddr_t call_data)
{
  struct view *view_p;
  int width, height;
  char *width_s, *height_s, *name;

  switch (client_data)
    { 
    case B_OK:
      width_s = XmTextGetString(new_edit[WIDTH]);
      width = atoi(width_s);
      XtFree(width_s);
      if (width<=0)
	{
	  show_errormsg("Invalid width parameter.", "OK", NULL);
	  break;
	}
      height_s = XmTextGetString(new_edit[HEIGHT]);
      height = atoi(height_s);
      XtFree(height_s);
      if (height<=0)
	{
	  show_errormsg("Invalid height parameter.", "OK", NULL);
	  break;
	}
      name = XmTextGetString(new_edit[NAME]);
      if (name=="")
	{
	  show_errormsg("Invalid name parameter.", "OK", NULL);
	  break;
	}
      /* hourglass on */
      all_busy();
      XtUnmanageChild(fi_new_dialog);
      XFlush(XtDisplay(fi_new_dialog));
      view_p = new_picture(width, height, name);
      if (view_p!=NULL)
	{
	  make_view_window(view_p);
	  new_times++;
	}
      else
	{
	  all_busy_nomore();
	  show_errormsg("Picture allocation error.", "OK", NULL);
	}
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(fi_new_dialog);
      break;
    }
}


/*****************************************************************************
 *                            File/Open... callbacks                         *
 *****************************************************************************/
/* FUNCTION:       file_open_callback(Widget widget_id, char *client_data,
                                      caddr_t call_data)
   DESCRIPTION:    Callback for the open... button in the toolbox menu:
                   Opens the file and creates a window for it.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 14th July 1993.
*/   
void file_open_callback(Widget widget_id, char *client_data, caddr_t call_data)
{
  center_window(fi_open_dialog);
  XtManageChild(fi_open_dialog);
}

/* FUNCTION:       open_dialog callback(Widget widget_id, char *client_data,
                                        caddr_t call_data)
   DESCRIPTION:    Callback for the ok and cancel buttons in the File/Open... 
                   dialog.
   PARAMETERS:
   Widget widget_id                             Widget_id of the widget that
                                                  caused the callback.
   int client_data                              Button number.
   XmFileSelectionBoxCallbackStruct *call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 14th July 1993.
*/   
void open_dialog_callback(Widget widget_id, int client_data, 
			  XmFileSelectionBoxCallbackStruct *call_data)
{
  struct view *view_p;
  char *name;

  if (client_data==B_OK)
    {
      all_busy();
      XtUnmanageChild(fi_open_dialog);
      XFlush(XtDisplay(fi_open_dialog));
      name = xs_get_string_from_xmstring(call_data->value);
      
      view_p = open_file(name);
      if (view_p!=NULL)
	make_view_window(view_p);
      else
	all_busy_nomore();
    }
  else
    XtUnmanageChild(fi_open_dialog);
}


/*****************************************************************************
 *                            File/Save... callbacks                         *
 *****************************************************************************/
/* FUNCTION:       file_save_callback(Widget widget_id, char *client_data,
                                      caddr_t call_data)
   DESCRIPTION:    Callback for save button in the toolbox menu:
                   Saves the file to path specified by pic->name.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 15th July 1993.
*/   
void file_save_callback(Widget widget_id, char *client_data, caddr_t call_data)
{
  save_file(cur_pic, 1);
}


/*****************************************************************************
 *                         File/Save as... callbacks                         *
 *****************************************************************************/
/* FUNCTION:       file_saveas_callback(Widget widget_id, char *client_data,
                                        caddr_t call_data)
   DESCRIPTION:    Callback for save as... button in the toolbox menu:
                   Asks the name in a dialog and then saves.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 15th July 1993.
*/   
void file_saveas_callback(Widget widget_id, char *client_data,
			  caddr_t call_data)
{
/*
  Arg wargs[10];
  Cardinal n;

  n = 0;
  XtSetArg(wargs[n], XmN,
	   XmStringCreateLtoR(cur_pic->name, XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(fi_saveas_dialog, wargs, n);
*/
  center_window(fi_saveas_dialog);
  XtManageChild(fi_saveas_dialog);
}

/* FUNCTION:       saveas_dialog callback(Widget widget_id, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the save as... dialog.
   PARAMETERS:
   Widget widget_id                             Widget_id of the widget that
                                                  caused the callback.
   int client_data                              Button number.
   XmFileSelectionBoxCallbackStruct *call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 14th July 1993.
*/   
void saveas_dialog_callback(Widget widget_id, int client_data, 
			    XmFileSelectionBoxCallbackStruct *call_data)
{
  extern struct picture *cur_pic;
  extern struct view *cur_view;
  char *name, *wname;

  if (client_data==B_OK)
    {
      XtUnmanageChild(fi_saveas_dialog);
      name = xs_get_string_from_xmstring(call_data->value);
      if (cur_pic->name!=NULL)
	free(cur_pic->name); /* free the old name and set the new one */
      cur_pic->name = name;
      wname = malloc((10+strlen(cur_pic->name))*sizeof(char));
      sprintf(wname, "ACTIVE: %s", cur_pic->name);
      XStoreName(XtDisplay(cur_view->main), XtWindow(cur_view->main), wname);
      free(wname);
      save_file(cur_pic, 1);
    }     
  else
    XtUnmanageChild(fi_saveas_dialog);
}



/*****************************************************************************
 *                         File/Abandon... callbacks                         *
 *****************************************************************************/
/* FUNCTION:       file_abandon_callback(Widget w, char *client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Callback for the abandon button in the toolbox menu: 
                   Abandons picture.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 15th July 1993.
*/   
void file_abandon_callback(Widget widget_id, char *client_data, 
			   caddr_t call_data)
{
  abandon_q();
}


/*****************************************************************************
 *                          File/Exit... callbacks                           *
 *****************************************************************************/
/* FUNCTION:       file_exit_callback(Widget w, char *client_data,
                                     caddr_t call_data)
   DESCRIPTION:    Callback for the exit button in the toolbox menu: 
                   Calls exit init in the main module.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 28th June 1993.
*/   
void file_exit_callback(Widget widget_id, char *client_data, caddr_t call_data)
{
  exit_init();
}



/*****************************************************************************
 *                             Edit/Undo callbacks                           *
 *****************************************************************************/
/* FUNCTION:       edit_undo_callback(Widget w, char *client_data,
                                      caddr_t call_data)
   DESCRIPTION:    Undoes the latest operation.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 20th July 1993.
*/   
void edit_undo_callback(Widget widget_id, char *client_data, caddr_t call_data)
{
  undo();
}


/*****************************************************************************
 *                             Edit/Cut callbacks                            *
 *****************************************************************************/
/* FUNCTION:       edit_cut_callback(Widget w, char *client_data,
                                      caddr_t call_data)
   DESCRIPTION:    Cuts the selected area and moves it into the clipboard.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void edit_cut_callback(Widget widget_id, char *client_data, caddr_t call_data)
{
  cut();
}


/*****************************************************************************
 *                            Edit/Delete callbacks                          *
 *****************************************************************************/
/* FUNCTION:       edit_delete_callback(Widget w, char *client_data,
                                        caddr_t call_data)
   DESCRIPTION:    Deletes the selected area.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void edit_delete_callback(Widget widget_id, char *client_data,
			  caddr_t call_data)
{
  delete();
}


/*****************************************************************************
 *                             Edit/Copy callbacks                           *
 *****************************************************************************/
/* FUNCTION:       edit_copy_callback(Widget w, char *client_data,
                                      caddr_t call_data)
   DESCRIPTION:    Copies the selected area into the clipboard.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void edit_copy_callback(Widget widget_id, char *client_data, caddr_t call_data)
{
  copy();
}


/*****************************************************************************
 *                             Edit/Paste callbacks                          *
 *****************************************************************************/
/* FUNCTION:       edit_undo_callback(Widget w, char *client_data,
                                      caddr_t call_data)
   DESCRIPTION:    Pastes the clipboard to the screen.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void edit_paste_callback(Widget widget_id, char *client_data,
			 caddr_t call_data)
{
  paste();
}



/*****************************************************************************
 *                       Edit/Paste to toolbox callbacks                     *
 *****************************************************************************/
/* FUNCTION:       edit_pastetool_callback(Widget w, char *client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Pastes the clipboard into the toolbox.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void edit_pastetool_callback(Widget widget_id, char *client_data,
			     caddr_t call_data)
{
  paste_to_toolbox();
}


/* FUNCTION:       pastetool_callback(Widget w, char *client_data,
                                      caddr_t call_data)
   DESCRIPTION:    Asks the user which tool he/she wants to replace, the
                   dialog is managed by request of the main module, if no
		   location is empty.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   int client_data    Number describing callback nature, can be EXPOSE, 
                        USER1_B, USER2_B, USER3_B, B_OK or B_CANCEL
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void pastetool_dialog_callback(Widget widget_id, int client_data,
			       caddr_t call_data)
{
  char *p;
  int w, h;
  int center = BRUSH_MAX/2;
  Pixmap pixmap;
  Display *disp = XtDisplay(ptool_window);
  Window win = XtWindow(ptool_window);
  Window root = DefaultRootWindow(disp);
  switch (client_data)
    {
    case U1:
      XClearArea(disp, win, 0, 0, 0, 0, False);
      ptool = client_data;
      p = give_brush(USER1_B, BRUSH_MAX, &w, &h);
      if (p!=NULL)
	{
	  pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	  XSetStipple(disp, ptool_gc, pixmap);
	  XCopyPlane(disp, pixmap, win, ptool_gc, 0, 0, w, h, 
		     MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	  free(p);
	}
      break;
    case U2:
      XClearArea(disp, win, 0, 0, 0, 0, False);
      ptool = client_data;
      p = give_brush(USER2_B, BRUSH_MAX, &w, &h);
      if (p!=NULL)
	{
	  pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	  XSetStipple(disp, ptool_gc, pixmap);
	  XCopyPlane(disp, pixmap, win, ptool_gc, 0, 0, w, h, 
		     MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	  free(p);
	}
      break;
    case U3:
      XClearArea(disp, win, 0, 0, 0, 0, False);
      ptool = client_data;
      p = give_brush(USER3_B, BRUSH_MAX, &w, &h);
      if (p!=NULL)
	{
	  pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	  XSetStipple(disp, ptool_gc, pixmap);
	  XCopyPlane(disp, pixmap, win, ptool_gc, 0, 0, w, h, 
		     MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	  free(p);
	}
      break;
    case EXPOSE:
      XClearArea(disp, win, 0, 0, 0, 0, False);
      switch (ptool)
	{
	case U1:
	  ptool = client_data;
	  p = give_brush(USER1_B, BRUSH_MAX, &w, &h);
	  if (p!=NULL)
	    {
	      pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	      XSetStipple(disp, ptool_gc, pixmap);
	      XCopyPlane(disp, pixmap, win, ptool_gc, 0, 0, w, h, 
			 MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	      free(p);
	    }
	  break;
	case U2:
	  ptool = client_data;
	  p = give_brush(USER2_B, BRUSH_MAX, &w, &h);
	  if (p!=NULL)
	    {
	      pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	      XSetStipple(disp, ptool_gc, pixmap);
	      XCopyPlane(disp, pixmap, win, ptool_gc, 0, 0, w, h, 
			 MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	      free(p);
	    }
	  break;
	case U3:
	  ptool = client_data;
	  p = give_brush(USER3_B, BRUSH_MAX, &w, &h);
	  if (p!=NULL)
	    {
	      pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	      XSetStipple(disp, ptool_gc, pixmap);
	      XCopyPlane(disp, pixmap, win, ptool_gc, 0, 0, w, h, 
			 MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	      free(p);
	    }
	  break;
	}
      break;
    case B_OK:
      XtUnmanageChild(ed_ptool_dialog);
      if (paste_func!=NULL)
	switch (ptool)
	  {
	  case U1:
	    (*paste_func)(USER1_B, client_data);
	    break;
	  case U2:
	    (*paste_func)(USER2_B, client_data);
	    break;
	  case U3:
	    (*paste_func)(USER3_B, client_data);
	    break;
	  }
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(ed_ptool_dialog);
      break;
    }
}  


/*****************************************************************************
 *                        Edit/Select all callback                           *
 *****************************************************************************/
/* FUNCTION:       edit_select_callback(Widget w, char *client_data,
                                        caddr_t call_data)
   DESCRIPTION:    Selects the whole picture.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 3rd August 1993.
*/   
void edit_select_callback(Widget widget_id, char *client_data,
			  caddr_t call_data)
{
  select_all();
}


/*****************************************************************************
 *                        Edit/Deselect all callback                         *
 *****************************************************************************/
/* FUNCTION:       edit_deselect_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Erases selections.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 3rd August 1993.
*/   
void edit_deselect_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  deselect_all();
}



/*****************************************************************************
 *                         Image/Invert callbacks                            *
 *****************************************************************************/
/* FUNCTION:       image_invert_callback(Widget w, char *client_data,
                                        caddr_t call_data)
   DESCRIPTION:    Inverts the image/selected area.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void image_invert_callback(Widget w, char *client_data, caddr_t call_data)
{
  invert();
}


/*****************************************************************************
 *                       Image/Brighten... callbacks                         *
 *****************************************************************************/
/* FUNCTION:       image_brighten_callback(Widget w, char *client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 5th August 1993.
*/   
void image_brighten_callback(Widget widget_id, char *client_data,
			     caddr_t call_data)
{
  center_window(im_brighten_dialog);      
  XtManageChild(im_brighten_dialog);
}



/* FUNCTION:       brighten_dialog_callback(Widget widget_id, int client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Brighten... dialog: 
                   Gets the desired brightening percentage, and calls
		   brighten() in the main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in dialogw.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 5th August 1993.
*/   
void brighten_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  int scale;

  switch (client_data)
    { 
    case B_OK:
      XmScaleGetValue(brighten_slider, &scale);
      XtUnmanageChild(im_brighten_dialog);
      brighten(scale);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_brighten_dialog);
      break;
    }
}



/*****************************************************************************
 *                       Image/Darken... callbacks                         *
 *****************************************************************************/
/* FUNCTION:       image_darken_callback(Widget w, char *client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 5th August 1993.
*/   
void image_darken_callback(Widget widget_id, char *client_data,
			     caddr_t call_data)
{
  center_window(im_darken_dialog);      
  XtManageChild(im_darken_dialog);
}



/* FUNCTION:       darken_dialog_callback(Widget widget_id, int client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Darken... dialog: 
                   Gets the desired darkening percentage, and calls
		   darken() in the main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in dialogw.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 5th August 1993.
*/   
void darken_dialog_callback(Widget widget_id, int client_data, 
			    caddr_t call_data)
{
  int scale;

  switch (client_data)
    { 
    case B_OK:
      XmScaleGetValue(darken_slider, &scale);
      XtUnmanageChild(im_darken_dialog);
      darken(scale);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_darken_dialog);
      break;
    }
}




/*****************************************************************************
 *                        Image/Soften... callbacks                          *
 *****************************************************************************/
/* FUNCTION:       image_soften_callback(Widget w, char *client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void image_soften_callback(Widget w, char *client_data, caddr_t call_data)
{
  ask_question3("Do you want to edit the softening matrix?", "Edit matrix",
		"Apply matrix", "Cancel", soften_dialog_callback);
}


/* FUNCTION:       soften_dialog_callback(int client_data)
   DESCRIPTION:    Pops up the User matrix dialog if requested, otherwise
                   just calls soften() in the main module.
   PARAMETERS:
   int client_data    Number describing callback nature, can be B_OK, 
                       B_NO or B_CANCEL, defined in X_misc.h.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 9th August 1993.
*/   
void soften_dialog_callback(int client_data)
			    
{
  Arg wargs[2];
  int i;
  char *m[] = {
    "0.0", "0.0", "0.0", "0.0", "0.0",
    "0.0", "1.0", "1.0", "1.0", "0.0",  
    "0.0", "1.0", "1.0", "1.0", "0.0",
    "0.0", "1.0", "1.0", "1.0", "0.0",
    "0.0", "0.0", "0.0", "0.0", "0.0"};
  char *n = "1.0";
  char *d = "9.0";
  double im[5][5] = {
    {0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 1.0, 1.0, 1.0, 0.0},
    {0.0, 1.0, 1.0, 1.0, 0.0},
    {0.0, 1.0, 1.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0}
  };
  
  switch (client_data)
    {
    case B_OK:
      XtSetArg(wargs[0], XmNvalue, n);
      XtSetValues(num, wargs, 1);
      
      XtSetArg(wargs[0], XmNvalue, d);
      XtSetValues(denom, wargs, 1);
      
      for (i = 0; i<25; i++)
	{
	  XtSetArg(wargs[0], XmNvalue, m[i]);
	  XtSetValues(user_matrix[i], wargs, 1);
	}
      center_window(im_matrix_dialog);      
      XtManageChild(im_matrix_dialog);
      break;
    case B_NO:
      matrix(atof(n), atof(d), im[0]);
      break;
    case B_CANCEL:
    default:
      break;
    }
}



/*****************************************************************************
 *                        Image/Sharpen... callbacks                         *
 *****************************************************************************/
/* FUNCTION:       image_sharpen_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void image_sharpen_callback(Widget widegt_id, char *client_data, 
			    caddr_t call_data)
{
  ask_question3("Do you want to edit the sharpening matrix?", "Edit matrix",
		"Apply matrix", "Cancel", sharpen_dialog_callback);
}


/* FUNCTION:       sharpen_dialog_callback(int client_data)
   DESCRIPTION:    Pops up the User matrix dialog if requested, otherwise
                   just calls sharpen() in the main module.
   PARAMETERS:
   int client_data    Number describing callback nature, can be B_OK, 
                       B_NO or B_CANCEL, defined in X_misc.h.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 9th August 1993.
*/   
void sharpen_dialog_callback(int client_data)
{
  Arg wargs[2];
  int i;
  char *m[] = {
    "0.0", "0.0", "0.0", "0.0", "0.0",
    "0.0", "-1.0", "-1.0", "-1.0", "0.0",  
    "0.0", "-1.0", "17.0", "-1.0", "0.0", 
    "0.0", "-1.0", "-1.0", "-1.0", "0.0",
    "0.0", "0.0", "0.0", "0.0", "0.0"};
  char *n = "1.0";
  char *d = "9.0";
  double im[5][5] = {
    {0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, -1.0, -1.0, -1.0, 0.0},
    {0.0, -1.0, 17.0, -1.0, 0.0},
    {0.0, -1.0, -1.0, -1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0}
  };

  switch (client_data)
    {
    case B_OK:
      XtSetArg(wargs[0], XmNvalue, n);
      XtSetValues(num, wargs, 1);
      
      XtSetArg(wargs[0], XmNvalue, d);
      XtSetValues(denom, wargs, 1);
      
      for (i = 0; i<25; i++)
	{
	  XtSetArg(wargs[0], XmNvalue, m[i]);
	  XtSetValues(user_matrix[i], wargs, 1);
	}
      center_window(im_matrix_dialog);      
      XtManageChild(im_matrix_dialog);
      break;
    case B_NO:
      matrix(atof(n), atof(d), im[0]);
      break;
    case B_CANCEL:
    default:
      break;
    }
  
}



/*****************************************************************************
 *                     Image/User Matrix... callbacks                        *
 *****************************************************************************/
/* FUNCTION:       image_matrix_callback(Widget w, char *client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Pops up the matrix dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void image_matrix_callback(Widget widget_id, char *client_data,
			     caddr_t call_data)
{
  center_window(im_matrix_dialog);      
  XtManageChild(im_matrix_dialog);
}



/* FUNCTION:       matrix_dialog_callback(Widget widget_id, int client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the User Matrix... dialog: 
                   Gets the matrix from the dialog and calls matrix() in the
		   main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in dialogw.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void matrix_dialog_callback(Widget widget_id, int client_data, 
			    caddr_t call_data)
{
  int i, j;
  double v, n, d;
  char *s;
  double m[5][5];
  switch (client_data)
    { 
    case B_OK:
      s = XmTextGetString(num);
      n = atof(s);
      s = XmTextGetString(denom);
      d = atof(s);
      for (i = 0; i<5; i++)
	for (j = 0; j<5; j++)
	  {
	    s = XmTextGetString(user_matrix[i*5+j]);
	    v = atof(s);
	    m[i][j] = v;
	    }
      XtUnmanageChild(im_matrix_dialog);
      XtFree(s);
      matrix(n, d, m[0]);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_matrix_dialog);
      break;
    }
}



/*****************************************************************************
 *                      Image/RGB-adjust... callbacks                        *
 *****************************************************************************/
/* FUNCTION:       image_RGB-adjust_callback(Widget w, char *client_data,
                                             caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void image_RGB_adjust_callback(Widget w, char *client_data, caddr_t call_data)
{
  center_window(im_RGB_adjust_dialog);      
  XtManageChild(im_RGB_adjust_dialog);
}


/* FUNCTION:       RGB_adjust_dialog_callback(Widget widget_id,
                                              int client_data,
                                              caddr_t call_data)
   DESCRIPTION:    Callback for the buttons and text widgets in the
                   RGB-adjust... dialog: Gets the multiplicators and the 
		   offsets and calls rgb_adjust() in the main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be R_MUL_UP
                     R_MUL_DOWN, G_MUL_UP. G_MUL_DOWN, B_MUL_UP, B_MUL_DOWN,
		     R_OFF_UP, R_OFF_DOWN, G_OFF_UP, G_OFF_DOWN, B_OFF_UP,
		     B_OFF_DOWN, B_OK, B_CANCEL.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void RGB_adjust_dialog_callback(Widget widget_id, int client_data, 
				caddr_t call_data)
{
  Arg wargs[2];
  double r_m, g_m, b_m;
  int r_o, g_o, b_o;
  char *rm_s, *gm_s, *bm_s, *ro_s, *go_s, *bo_s;
  char s[10];
  switch (client_data)
    {
    case R_MUL_UP:
      rm_s = XmTextGetString(mul[R]);
      r_m = atof(rm_s);
      XtFree(rm_s);
      if (r_m<=-4.0)
	r_m = -3.75;
      else if (r_m>=3.75)
	r_m = 4.0;
      else
	r_m += 0.25;
      sprintf(s, "%1.4f", r_m);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(mul[R], wargs, 1);
      break;
    case R_MUL_DOWN:
      rm_s = XmTextGetString(mul[R]);
      r_m = atof(rm_s);
      XtFree(rm_s);
      if (r_m<=-3.75)
	r_m = -4.0;
      else if (r_m>=4.0)
	r_m = 3.75;
      else
	r_m -= 0.25;
      sprintf(s, "%1.4f", r_m);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(mul[R], wargs, 1);
      break;
    case R_OFF_UP:
      ro_s = XmTextGetString(offset[R]);
      r_o = atoi(ro_s);
      XtFree(ro_s);
      if (r_o<=-128)
	r_o = -118;
      else if (r_o>=118)
	r_o = 128;
      else
	r_o += 10;
      sprintf(s, "%d", r_o);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(offset[R], wargs, 1);
      break;
    case R_OFF_DOWN:
      ro_s = XmTextGetString(offset[R]);
      r_o = atoi(ro_s);
      XtFree(ro_s);
      if (r_o<=-118)
	r_o = -128;
      else if (r_o>=128)
	r_o = 118;
      else
	r_o -= 10;
      sprintf(s, "%d", r_o);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(offset[R], wargs, 1);
      break;
    case G_MUL_UP:
      gm_s = XmTextGetString(mul[G]);
      g_m = atof(gm_s);
      XtFree(gm_s);
      if (g_m<=-4.0)
	g_m = -3.75;
      else if (g_m>=3.75)
	g_m = 4.0;
      else
	g_m += 0.25;
      sprintf(s, "%1.4f", g_m);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(mul[G], wargs, 1);
      break;
    case G_MUL_DOWN:
      gm_s = XmTextGetString(mul[G]);
      g_m = atof(gm_s);
      XtFree(gm_s);
      if (g_m<=-3.75)
	g_m = -4.0;
      else if (g_m>=4.0)
	g_m = 3.75;
      else
	g_m -= 0.25;
      sprintf(s, "%1.4f", g_m);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(mul[G], wargs, 1);
      break;
    case G_OFF_UP:
      go_s = XmTextGetString(offset[G]);
      g_o = atoi(go_s);
      XtFree(go_s);
      if (g_o<=-128)
	g_o = -118;
      else if (g_o>=118)
	g_o = 128;
      else
	g_o += 10;
      sprintf(s, "%d", g_o);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(offset[G], wargs, 1);
      break;
    case G_OFF_DOWN:
      go_s = XmTextGetString(offset[G]);
      g_o = atoi(go_s);
      XtFree(go_s);
      if (g_o<=-118)
	g_o = -128;
      else if (g_o>=128)
	g_o = 118;
      else
	g_o -= 10;
      sprintf(s, "%d", g_o);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(offset[G], wargs, 1);
      break;
    case B_MUL_UP:
      bm_s = XmTextGetString(mul[B]);
      b_m = atof(bm_s);
      XtFree(bm_s);
      if (b_m<=-4.0)
	b_m = -3.75;
      else if (b_m>=3.75)
	b_m = 4.0;
      else
	b_m += 0.25;
      sprintf(s, "%1.4f", b_m);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(mul[B], wargs, 1);
      break;
    case B_MUL_DOWN:
      bm_s = XmTextGetString(mul[B]);
      b_m = atof(bm_s);
      XtFree(bm_s);
      if (b_m<=-3.75)
	b_m = -4.0;
      else if (b_m>=4.0)
	b_m = 3.75;
      else
	b_m -= 0.25;
      sprintf(s, "%1.4f", b_m);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(mul[B], wargs, 1);
      break;
    case B_OFF_UP:
      bo_s = XmTextGetString(offset[B]);
      b_o = atoi(bo_s);
      XtFree(bo_s);
      if (b_o<=-128)
	b_o = -118;
      else if (b_o>=118)
	b_o = 128;
      else
	b_o += 10;
      sprintf(s, "%d", b_o);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(offset[B], wargs, 1);
      break;
    case B_OFF_DOWN:
      bo_s = XmTextGetString(offset[B]);
      b_o = atoi(bo_s);
      XtFree(bo_s);
      if (b_o<=-118)
	b_o = -128;
      else if (b_o>=128)
	b_o = 118;
      else
	b_o -= 10;
      sprintf(s, "%d", b_o);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(offset[B], wargs, 1);
      break;
    case B_OK:
      rm_s = XmTextGetString(mul[R]);
      r_m = atof(rm_s);
      XtFree(rm_s);
      ro_s = XmTextGetString(offset[R]);
      r_o = atoi(ro_s);
      XtFree(ro_s);
      gm_s = XmTextGetString(mul[G]);
      g_m = atof(gm_s);
      XtFree(gm_s);
      go_s = XmTextGetString(offset[G]);
      g_o = atoi(go_s);
      XtFree(go_s);
      bm_s = XmTextGetString(mul[B]);
      b_m = atof(bm_s);
      XtFree(bm_s);
      bo_s = XmTextGetString(offset[B]);
      b_o = atoi(bo_s);
      XtFree(bo_s);
      rgb_adjust(r_m, g_m, b_m, r_o, g_o, b_o);
      XtUnmanageChild(im_RGB_adjust_dialog);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_RGB_adjust_dialog);
      break;
    }
}


/*****************************************************************************
 *                      Image/HSV-adjust... callbacks                        *
 *****************************************************************************/
/* FUNCTION:       image_HSV-adjust_callback(Widget w, char *client_data,
                                             caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 10th August 1993.
*/   
void image_HSV_adjust_callback(Widget w, char *client_data, caddr_t call_data)
{
  center_window(im_HSV_adjust_dialog);      
  XtManageChild(im_HSV_adjust_dialog);
}


/* FUNCTION:       HSV_adjust_dialog_callback(Widget widget_id,
                                              int client_data,
                                              caddr_t call_data)
   DESCRIPTION:    Callback for the buttons and text widgets in the
                   HSV-adjust... dialog: Gets the multiplicators and the 
		   offsets and calls hsv_adjust() in the main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or
                       B_CANCEL.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 10th August 1993.
*/   
void HSV_adjust_dialog_callback(Widget widget_id, int client_data, 
				caddr_t call_data)
{
  int h_scale, v_scale, s_scale;
  switch (client_data)
    { 
    case B_OK:
      XmScaleGetValue(HSV_slides[H_S], &h_scale);   
      XmScaleGetValue(HSV_slides[S_S], &s_scale);   
      XmScaleGetValue(HSV_slides[V_S], &v_scale);   
      XtUnmanageChild(im_HSV_adjust_dialog);
      hsv_adjust((double)h_scale/100.0, (double)s_scale/10000.0,
		 (double)v_scale/10000.0);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_HSV_adjust_dialog);
      break;
    }
}


/*****************************************************************************
 *                       Image/Add noise... callbacks                        *
 *****************************************************************************/
/* FUNCTION:       image_addnoise_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 10th August 1993.
*/   
void image_addnoise_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  center_window(im_addnoise_dialog);
  XtManageChild(im_addnoise_dialog);
}



/* FUNCTION:       addnoise_dialog_callback(Widget widget_id, int client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Add noise... dialog: 
                   Gets the scale value and calls add_noise() in the
		   main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in dialogw.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 19th July 1993.
*/   
void addnoise_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  int scale;

  switch (client_data)
    { 
    case B_OK:
      XmScaleGetValue(addnoise_slider, &scale);
      XtUnmanageChild(im_addnoise_dialog);
    add_noise(scale);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_addnoise_dialog);
      break;
    }
}



/*****************************************************************************
 *                        Image/Resize... callbacks                          *
 *****************************************************************************/
/* FUNCTION:       image_resize_callback(Widget w, char *client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Sets the values and pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void image_resize_callback(Widget w, char *client_data, caddr_t call_data)
{
  extern struct picture *cur_pic;
  Arg wargs[2];
  char width_s[10], height_s[10];

  sprintf(width_s, "%d", cur_pic->width);
  XtSetArg(wargs[0], XmNvalue, width_s);
  XtSetValues(size[WIDTH], wargs, 1);

  sprintf(height_s, "%d", cur_pic->height);
  XtSetArg(wargs[0], XmNvalue, height_s);
  XtSetValues(size[HEIGHT], wargs, 1);

  XtSetArg(wargs[0], XmNset, TRUE);
  XtSetValues(keep, wargs, 1);
  keep_flag = True;
  update_flag = False;
  orig_w = cur_pic->width;
  orig_h = cur_pic->height;

  center_window(im_resize_dialog);      
  XtManageChild(im_resize_dialog);
}


/* FUNCTION:       resize_dialog_callback(Widget widget_id, int client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Resize... dialog: 
                   Gets the new width and height and calls resize in the
		   main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be WIDTH, HEIGHT,
                       W_UP, W_DOWN, H_UP, H_DOWN, KEEP, B_OK or B_CANCEL.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 8th August 1993.
*/   
void resize_dialog_callback(Widget widget_id, int client_data, 
			    caddr_t call_data)
{
  Arg wargs[2];
  int width, height;
  char *width_s, *height_s;
  char s[10];

  if (update_flag==True)
    {
      update_flag = False;
      return;
    }
  switch (client_data)
    { 
    case KEEP:
      if (keep_flag==True)
	keep_flag = False;
      else
	{
	  keep_flag = True;
	  width_s = XmTextGetString(size[WIDTH]);
	  width = atoi(width_s);
	  XtFree(width_s);

	  height_s = XmTextGetString(size[HEIGHT]);
	  height = atoi(height_s);
	  XtFree(height_s);

	  orig_w = (width<=0) ? 1 : width;
	  orig_h = (height<=0) ? 1 : height;
	}
      break;
    case WIDTH:
      if (keep_flag==True)
	{      
	  width_s = XmTextGetString(size[WIDTH]);
	  width = atoi(width_s);
	  XtFree(width_s);
	  height = width*orig_h/orig_w;
	  update_flag = True;
	  sprintf(s, "%d", height);
	  XtSetArg(wargs[0], XmNvalue, s);
	  XtSetValues(size[HEIGHT], wargs, 1);
	}
      break;
    case W_UP:
      width_s = XmTextGetString(size[WIDTH]);
      width = atoi(width_s);
      XtFree(width_s);
      if (width<=0)
	width = 50;
      else
	width += 50;
      sprintf(s, "%d", width);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(size[WIDTH], wargs, 1);
      break;
    case W_DOWN:
      width_s = XmTextGetString(size[WIDTH]);
      width = atoi(width_s);
      XtFree(width_s);
      if (width<=50)
	width = 1;
      else
	width -= 50;
      sprintf(s, "%d", width);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(size[WIDTH], wargs, 1);
      break;
    case HEIGHT:
      if (keep_flag==True)
	{      
	  height_s = XmTextGetString(size[HEIGHT]);
	  height = atoi(height_s);
	  XtFree(height_s);
	  width = height*orig_w/orig_h;
	  update_flag = True;
	  sprintf(s, "%d", width);
	  XtSetArg(wargs[0], XmNvalue, s);
	  XtSetValues(size[WIDTH], wargs, 1);
	}
      break;
    case H_UP:
      height_s = XmTextGetString(size[HEIGHT]);
      height = atoi(height_s);
      XtFree(height_s);
      if (height<=0)
	height = 50;
      else
	height += 50;
      sprintf(s, "%d", height);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(size[HEIGHT], wargs, 1);
      break;
    case H_DOWN:
      height_s = XmTextGetString(size[HEIGHT]);
      height = atoi(height_s);
      XtFree(height_s);
      if (height<=50)
	height = 0;
      else
	height -= 50;
      sprintf(s, "%d", height);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(size[HEIGHT], wargs, 1);
      break;
    case B_OK:
      width_s = XmTextGetString(size[WIDTH]);
      width = atoi(width_s);
      XtFree(width_s);
      if (width<=0)
	{
	  show_errormsg("Invalid width parameter.", "OK", NULL);
	  break;
	}
      height_s = XmTextGetString(size[HEIGHT]);
      height = atoi(height_s);
      XtFree(height_s);
      if (height<=0)
	{
	  show_errormsg("Invalid height parameter.", "OK", NULL);
	  break;
	}
      all_busy();
      XtUnmanageChild(im_resize_dialog);
      XFlush(XtDisplay(im_resize_dialog));
      resize(width, height);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_resize_dialog);
      break;
    }
}



/*****************************************************************************
 *                     Image/Vertical flip callbacks                         *
 *****************************************************************************/
/* FUNCTION:       image_vflip_callback(Widget w, char *client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Flips the image vertically.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void image_vflip_callback(Widget w, char *client_data, caddr_t call_data)
{
  vflip();
}


/*****************************************************************************
 *                     Image/Horizontal flip callbacks                       *
 *****************************************************************************/
/* FUNCTION:       image_hflip_callback(Widget w, char *client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Flips the image horizontally.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void image_hflip_callback(Widget w, char *client_data, caddr_t call_data)
{
  hflip();
}


/*****************************************************************************
 *                          Image/Rotate callbacks                           *
 *****************************************************************************/
/* FUNCTION:       image_rotate_callback(Widget w, char *client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 9th August 1993.
*/   
void image_rotate_callback(Widget w, char *client_data, caddr_t call_data)
{
  center_window(im_rotate_dialog);
  XtManageChild(im_rotate_dialog);
}


/* FUNCTION:       rotate_dialog_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Gets the degree of rotation and calls rotate() in the main
                   module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be ANGLE_UP,
                      ANGLE_DOWN, CW, ACW, B_OK or B_CANCEL,
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 9th August 1993.
*/   
void rotate_dialog_callback(Widget widget_id, int client_data,
			    caddr_t call_data)
{
  Arg wargs[2];
  char *r, w[10];
  double v;
  switch (client_data)
    {
    case CW:
      dir = CW;
      break;
    case CCW:
      dir = CCW;
      break;
    case ANGLE_UP:
      r = XmTextGetString(angle);
      v = atof(r);
      XtFree(r);
      v += 20.0;
      if (v>=360.0)
	v = v - 360.0;
      sprintf(w, "%3.2f", v);
      XtSetArg(wargs[0], XmNvalue, w);
      XtSetValues(angle, wargs, 1);
      break;
    case ANGLE_DOWN:
      r = XmTextGetString(angle);
      v = atof(r);
      XtFree(r);
      v -= 20.0;
      if (v<0.0)
	v = v + 360.0;
      sprintf(w, "%3.2f", v);
      XtSetArg(wargs[0], XmNvalue, w);
      XtSetValues(angle, wargs, 1);
      break;
    case B_OK:
      r = XmTextGetString(angle);
      all_busy();
      XtUnmanageChild(im_rotate_dialog);
      XFlush(XtDisplay(im_rotate_dialog));
      v = atof(r);
      XtFree(r);
      rotate(v, (dir==CW) ? !0 : 0);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_rotate_dialog);
      break;
    }
}



/*****************************************************************************
 *                       Image/Duplicate callbacks                           *
 *****************************************************************************/
/* FUNCTION:       image_duplicate_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Duplicates the image.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 5th August 1993.
*/   
void image_duplicate_callback(Widget widget_id, char *client_data,
			      caddr_t call_data)
{
  struct view *view_p;
  char *name;
  all_busy();
  view_p = duplicate();
  if (view_p!=NULL)
    {
      name = (char *)malloc(15*sizeof(char));
      sprintf(name, "NoName%02d.ppm", new_times);	  
      if (view_p->pic_p->name!=NULL)
	free(view_p->pic_p->name);
      view_p->pic_p->name = name;
      new_times++;
      make_view_window(view_p);
      show_zoom(view_p);
    }
}




/*****************************************************************************
 *                       Image/Add view... callbacks                         *
 *****************************************************************************/
/* FUNCTION:       image_addview_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 20th July 1993.
*/   
void image_addview_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  center_window(im_addview_dialog);
  XtManageChild(im_addview_dialog);
}



/* FUNCTION:       addview_dialog_callback(Widget widget_id, int client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Add view... dialog: 
                   Gets the desired scale factor, adds the view and
		   creates the view_window.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in dialogw.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 19th July 1993.
*/   
void addview_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  struct view *view_p;
  int scale;

  switch (client_data)
    { 
    case B_OK:
      XmScaleGetValue(addview_slider, &scale);
      all_busy();
      XtUnmanageChild(im_addview_dialog);
      XFlush(XtDisplay(im_addview_dialog));
      view_p = add_view(cur_pic, 0, 0, cur_pic->width-1, cur_pic->height-1, 
			scale);
      if (view_p!=NULL)
	make_view_window(view_p);
      else
	all_busy_nomore();
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_addview_dialog);
      break;
    }
}



/*****************************************************************************
 *                          Image/Zoom... callbacks                          *
 *****************************************************************************/
/* FUNCTION:       image_zoom_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 20th July 1993.
*/   
void image_zoom_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  center_window(im_zoom_dialog);
  XtManageChild(im_zoom_dialog);
}



/* FUNCTION:       zoom_dialog_callback(Widget widget_id, int client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Zoom... dialog: 
                   Gets the desired scale factor, removes the old view
		   window and creates a new one.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in X_misc.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 19th July 1993.
*/   
void zoom_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  Arg wargs[10];
  Cardinal n;
  extern struct view *cur_view;
  int scale;
  int scroll_h, scroll_w;
  Dimension width, height;
  XSizeHints hints;
  Display *disp = XtDisplay(cur_view->main);
  Window win = XtWindow(cur_view->main);
  int scr = DefaultScreen(disp);

  switch (client_data)
    { 
    case B_OK:
      XmScaleGetValue(zoom_slider, &scale);
      XtUnmanageChild(im_zoom_dialog);

      if (scale*cur_view->pic_p->width+decor_w+bar_t+space
	  <XDisplayWidth(disp, scr))
	scroll_w = scale*cur_view->pic_p->width+bar_t+space;
      else
	scroll_w = XDisplayWidth(disp, scr)-decor_w;
      if (scale*cur_view->pic_p->height+decor_h+label_h+bar_t+space
	  <XDisplayHeight(disp, scr)) 
	scroll_h = scale*cur_view->pic_p->height+bar_t+space;
      else
	scroll_h = XDisplayHeight(disp, scr)-decor_h-label_h;

      n = 0;
      XtSetArg(wargs[n], XmNwidth, &width); n++;
      XtSetArg(wargs[n], XmNheight, &height); n++;
      XtGetValues(cur_view->draw_area, wargs, n);

      width = MIN(cur_view->pic_p->width*cur_view->scale, width);
      height = MIN(cur_view->pic_p->height*cur_view->scale, height);

      hints.flags = 0;
      if ((width>scroll_w-bar_t-space||height>scroll_h-bar_t-space) &&
	  scale<cur_view->scale)
	{
	  hints.width =  scroll_w;
	  hints.height = scroll_h+label_h;
	  hints.flags |= PSize;
	  width = scroll_w-bar_t-space;
	  height = scroll_h-bar_t-space;
	}

      hints.max_width =  scroll_w;
      hints.max_height = scroll_h+label_h;
      hints.flags |= PMaxSize;
      XSetNormalHints(disp, win, &hints);

      cur_view->scale = scale;

      width = (width%cur_view->scale) ? width/cur_view->scale+1 :
	width/cur_view->scale;
      height = (height%cur_view->scale) ? height/cur_view->scale+1 :
	height/cur_view->scale;
      
      if (width>cur_view->pic_p->width-cur_view->x1)
	cur_view->x1 = MAX(cur_view->pic_p->width-width, 0);
      if (height>cur_view->pic_p->height-cur_view->y1)
	cur_view->y1 = MAX(cur_view->pic_p->height-height, 0);;
      
      cur_view->x2 = MIN(cur_view->x1+width-1, cur_view->pic_p->width-1);
      cur_view->y2 = MIN(cur_view->y1+height-1, cur_view->pic_p->height-1);

      n = 0;
      XtSetArg(wargs[n], XmNsliderSize, width-1); n++;
      XtSetArg(wargs[n], XmNvalue, cur_view->x1); n++;
      XtSetArg(wargs[n], XmNpageIncrement, width); n++;
      XtSetValues(cur_view->h_scroll, wargs, n);
      
      n = 0;
      XtSetArg(wargs[n], XmNsliderSize, height-1); n++;
      XtSetArg(wargs[n], XmNvalue, cur_view->y1); n++;
      XtSetArg(wargs[n], XmNpageIncrement, height); n++;
      XtSetValues(cur_view->v_scroll, wargs, n);
      
      win = XtWindow(cur_view->draw_area);
      XClearArea(disp, win, 0, 0, 0, 0, True);
      show_zoom(cur_view);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(im_zoom_dialog);
      break;
    }
}



/*****************************************************************************
 *                          Color/Select... callbacks                        *
 *****************************************************************************/
/* FUNCTION:       color_select_callback(Widget w, int client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Color selector callback, shows the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   int client_data    Numeric constant, sets which.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void color_select_callback(Widget widget_id, int client_data,
			    caddr_t call_data)
{
  extern struct view *cur_view;
  Arg wargs[2];
  int r, g, b, h, s, v;
  double hd = 0.0, sd, vd;

  if (cur_view!=NULL)
    {
      if (client_data==PRIM)
	give_color(cur_view, &r, &g, &b, PRIMARY);
      else
	give_color(cur_view, &r, &g, &b, SECONDARY);
      
      rgb_to_hsv(r/255.0, g/255.0, b/255.0, &hd, &sd, &vd);
      h = (int)(hd*100);
      s = (int)(sd*10000);
      v = (int)(vd*10000);
      
      XtSetArg(wargs[0], XmNvalue, r);
      XtSetValues(color_slides[R], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, g);
      XtSetValues(color_slides[G], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, b);
      XtSetValues(color_slides[B], wargs, 1);
      
      XtSetArg(wargs[0], XmNvalue, h);
      XtSetValues(color_slides[H], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(color_slides[S], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, v);
      XtSetValues(color_slides[V], wargs, 1);

      prim_changed = second_changed = 0;
      
      XtSetArg(wargs[0], XmNset, TRUE);
      XtSetValues(col_btn[client_data], wargs, 1);
      which = client_data;

      XtSetArg(wargs[0], XmNset, FALSE);
      if (client_data)
	XtSetValues(col_btn[client_data-1], wargs, 1);
      else
	XtSetValues(col_btn[client_data+1], wargs, 1);

      center_window(co_select_dialog);
      XtManageChild(co_select_dialog);
    }
  else
    show_errormsg("Must have an actice view to change color.", "OK", NULL);
}



/* FUNCTION:       select_dialog_callback(Widget widget_id, int client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Callback for the buttons and slides  in the Select... 
                   dialog: 
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in X_misc.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 19th July 1993.
*/   
void select_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  extern int depth;
  Arg wargs[2];
  static int r_p, g_p, b_p, r_s, g_s, b_s, h_p, s_p, v_p, h_s, s_s, v_s;
  static double hd_p, hd_s;
  double rd, gd, bd, sd, vd;
  extern struct view *cur_view;
  GC prim_gc = XtGetGC(cur_view->prim_ind, (XtGCMask)NULL, NULL);
  GC second_gc = XtGetGC(cur_view->second_ind, (XtGCMask)NULL, NULL);
  XImage *prim_image, *second_image;
  Display *disp = XtDisplay(cur_view->prim_ind);
  Window prim_win = XtWindow(cur_view->prim_ind);
  Window second_win = XtWindow(cur_view->second_ind);

  switch (client_data)
    {
    case PRIM_B:
      if (prim_changed==0)
	give_color(cur_view, &r_p, &g_p, &b_p, PRIMARY);

      hd_p = 0.0;
      rgb_to_hsv(r_p/255.0, g_p/255.0, b_p/255.0, &hd_p, &sd, &vd);
      h_p = (int)(hd_p*100);
      s_p = (int)(sd*10000);
      v_p = (int)(vd*10000);
      
      XtSetArg(wargs[0], XmNvalue, r_p);
      XtSetValues(color_slides[R], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, g_p);
      XtSetValues(color_slides[G], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, b_p);
      XtSetValues(color_slides[B], wargs, 1);
      
      XtSetArg(wargs[0], XmNvalue, h_p);
      XtSetValues(color_slides[H], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, s_p);
      XtSetValues(color_slides[S], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, v_p);
      XtSetValues(color_slides[V], wargs, 1);
      
      which = PRIM;
      break;
    case SEC_B:
      if (second_changed==0)
	give_color(cur_view, &r_s, &g_s, &b_s, SECONDARY);

      hd_s = 0.0;
      rgb_to_hsv(r_s/255.0, g_s/255.0, b_s/255.0, &hd_s, &vd, &sd);
      h_s = (int)(hd_s*100);
      s_s = (int)(sd*10000);
      v_s = (int)(vd*10000);
      
      XtSetArg(wargs[0], XmNvalue, r_s);
      XtSetValues(color_slides[R], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, g_s);
      XtSetValues(color_slides[G], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, b_s);
      XtSetValues(color_slides[B], wargs, 1);
      
      XtSetArg(wargs[0], XmNvalue, h_s);
      XtSetValues(color_slides[H], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, s_s);
      XtSetValues(color_slides[S], wargs, 1);
      XtSetArg(wargs[0], XmNvalue, v_s);
      XtSetValues(color_slides[V], wargs, 1);
      
      which = SEC;
      break;
    case R:
    case G:
    case B:
      if (which==PRIM)
	{
	  if (!prim_changed)
	    hd_p = 0.0;
	  XmScaleGetValue(color_slides[R], &r_p);
	  XmScaleGetValue(color_slides[G], &g_p);
	  XmScaleGetValue(color_slides[B], &b_p);
	  rgb_to_hsv(r_p/255.0, g_p/255.0, b_p/255.0, &hd_p, &sd, &vd);
	  h_p = (int)(hd_p*100);
	  s_p = (int)(sd*10000);
	  v_p = (int)(vd*10000);

	  XtSetArg(wargs[0], XmNvalue, h_p);
	  XtSetValues(color_slides[H], wargs, 1);
	  XtSetArg(wargs[0], XmNvalue, s_p);
	  XtSetValues(color_slides[S], wargs, 1);
	  XtSetArg(wargs[0], XmNvalue, v_p);
	  XtSetValues(color_slides[V], wargs, 1);

	  prim_image =
	    XCreateImage(disp, view_vis, depth, ZPixmap, 0,
			 colored_block(r_p, g_p, b_p, ind_w, ind_h), 
			 ind_w, ind_h, pad, 0);
	  XPutImage(disp, prim_win, prim_gc, prim_image, 0, 0, 0, 0,
		    ind_w, ind_h);
	  prim_changed = 1;
	}
      else
	{
	  if (!second_changed)
	    hd_s = 0.0;
	  XmScaleGetValue(color_slides[R], &r_s);
	  XmScaleGetValue(color_slides[G], &g_s);
	  XmScaleGetValue(color_slides[B], &b_s);
	  rgb_to_hsv(r_s/255.0, g_s/255.0, b_s/255.0, &hd_s, &vd, &sd);
	  h_s = (int)(hd_s*100);
	  s_s = (int)(sd*10000);
	  v_s = (int)(vd*10000);

	  XtSetArg(wargs[0], XmNvalue, h_s);
	  XtSetValues(color_slides[H], wargs, 1);
	  XtSetArg(wargs[0], XmNvalue, s_s);
	  XtSetValues(color_slides[S], wargs, 1);
	  XtSetArg(wargs[0], XmNvalue, v_s);
	  XtSetValues(color_slides[V], wargs, 1);

	  second_image =
	    XCreateImage(disp, view_vis, depth, ZPixmap, 0,
			 colored_block(r_s, g_s, b_s, ind_w, ind_h), 
			 ind_w, ind_h, pad, 0);
	  XPutImage(disp, second_win, second_gc, second_image, 0, 0, 0, 0,
		    ind_w, ind_h);
	  second_changed = 1;
	}
      break;
    case H:
    case V:
    case S:
      if (which==PRIM)
	{
	  XmScaleGetValue(color_slides[H], &h_p);
	  XmScaleGetValue(color_slides[S], &v_p);
	  XmScaleGetValue(color_slides[V], &s_p);
	  hsv_to_rgb(h_p/100.0, v_p/10000.0, s_p/10000.0, &rd, &gd, &bd);
	  r_p = (int)(rd*255.0);
	  g_p = (int)(gd*255.0);
	  b_p = (int)(bd*255.0);

	  XtSetArg(wargs[0], XmNvalue, r_p);
	  XtSetValues(color_slides[R], wargs, 1);
	  XtSetArg(wargs[0], XmNvalue, g_p);
	  XtSetValues(color_slides[G], wargs, 1);
	  XtSetArg(wargs[0], XmNvalue, b_p);
	  XtSetValues(color_slides[B], wargs, 1);

	  prim_image =
	    XCreateImage(disp, view_vis, depth, ZPixmap, 0,
			 colored_block(r_p, g_p, b_p, ind_w, ind_h), 
			 ind_w, ind_h, pad, 0);
	  XPutImage(disp, prim_win, prim_gc, prim_image, 0, 0, 0, 0,
		    ind_w, ind_h);
	  prim_changed = 1;
	}
      else
	{
	  XmScaleGetValue(color_slides[H], &h_s);
	  XmScaleGetValue(color_slides[S], &v_s);
	  XmScaleGetValue(color_slides[V], &s_s);
	  hsv_to_rgb(h_s/100.0, v_s/10000.0, s_s/10000.0, &rd, &gd, &bd);
	  r_s = (int)(rd*255.0);
	  g_s = (int)(gd*255.0);
	  b_s = (int)(bd*255.0);

	  XtSetArg(wargs[0], XmNvalue, r_s);
	  XtSetValues(color_slides[R], wargs, 1);
	  XtSetArg(wargs[0], XmNvalue, g_s);
	  XtSetValues(color_slides[G], wargs, 1);
	  XtSetArg(wargs[0], XmNvalue, b_s);
	  XtSetValues(color_slides[B], wargs, 1);

	  second_image =
	    XCreateImage(disp, view_vis, depth, ZPixmap, 0,
			 colored_block(r_s, g_s, b_s, ind_w, ind_h), 
			 ind_w, ind_h, pad, 0);
	  XPutImage(disp, second_win, second_gc, second_image, 0, 0, 0, 0,
		    ind_w, ind_h);
	  second_changed = 1;
	}
      break;
    case B_OK:
      if (prim_changed)
	take_color(cur_view, r_p, g_p, b_p, PRIMARY);
      if (second_changed)
	take_color(cur_view, r_s, g_s, b_s, SECONDARY);
      XtUnmanageChild(co_select_dialog);
      break;
    case B_CANCEL:
      show_colors(cur_view);
    default:
     XtUnmanageChild(co_select_dialog);
      break;
    }
}



/*****************************************************************************
 *                      Options/Brush options... callbacks                   *
 *****************************************************************************/
/* FUNCTION:       options_brush_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void options_brush_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  center_window(op_brush_dialog);
  XtManageChild(op_brush_dialog);
}



/* FUNCTION:       brush_dialog_callback(Widget widget_id, int client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Callback for the buttons and the slider in the Brush 
                   options... dialog: 
                   
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK, B_CANCEL,
                       SLIDER or a number between 0 and 9 (these numbers 
		       represent the different brush types)
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void brush_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  static int brush, scale;
  Display *disp = XtDisplay(brush_window);
  Window win = XtWindow(brush_window);
  Window root = DefaultRootWindow(disp);
  Pixmap pixmap;
  char *p;
  int center = BRUSH_MAX/2;
  int w, h;

  switch (client_data)
    { 
    case POINT_B:
      XClearArea(disp, win, 0, 0, 0, 0, False);
      XDrawPoint(disp, win, brush_gc, center, center);
      brush = client_data;
      XmScaleSetValue(brush_slider, 1);
      break;
    case DISC_B:
      XmScaleGetValue(brush_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      if (scale==1)
	XDrawPoint(disp, win, brush_gc, center, center);
      else
	XFillArc(disp, win, brush_gc, center-scale/2, center-scale/2, 
		 scale, scale, 0, 23040);
      brush = client_data;
      break;
    case BOX_B:
      XmScaleGetValue(brush_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      XFillRectangle(disp, win, brush_gc, center-scale/2, center-scale/2, 
		     scale, scale);
      brush = client_data;
      break;
    case HLINE_B:
      XmScaleGetValue(brush_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      XDrawLine(disp, win, brush_gc, center-scale/2, center,
		center+scale/2, center);
      brush = client_data;
      break;
    case VLINE_B:
      XmScaleGetValue(brush_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      XDrawLine(disp, win, brush_gc, center, center-scale/2,
		center, center+scale/2);
      brush = client_data;
      break;
    case RLINE_B:
      XmScaleGetValue(brush_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      XDrawLine(disp, win, brush_gc, center-scale/2, center+scale/2,
		center+scale/2, center-scale/2);
      brush = client_data;
      break;
    case LLINE_B:
      XmScaleGetValue(brush_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      XDrawLine(disp, win, brush_gc, center-scale/2, center-scale/2,
		center+scale/2, center+scale/2);
      brush = client_data;
      break;
    case USER1_B:
    case USER2_B:
    case USER3_B:
      XClearArea(disp, win, 0, 0, 0, 0, False);
      brush = client_data;
      p = give_brush(brush, BRUSH_MAX, &w, &h);
      if (p!=NULL)
	{
	  pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	  XSetStipple(disp, brush_gc, pixmap);
	  XCopyPlane(disp, pixmap, win, brush_gc, 0, 0, w, h, 
		     MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	  free(p);
	}
      XmScaleSetValue(brush_slider, 1);
      break;
    case SLIDER:
      XmScaleGetValue(brush_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      switch (brush)
	{
	case POINT_B:
	  XDrawPoint(disp, win, brush_gc, center, center);
	  XmScaleSetValue(brush_slider, 1);
	  break;
	case DISC_B:
	  if (scale==1)
	    XDrawPoint(disp, win, brush_gc, center, center);
	  else
	    XFillArc(disp, win, brush_gc, center-scale/2, center-scale/2, 
		     scale, scale, 0, 23040);
	  break;
	case BOX_B:
	  XFillRectangle(disp, win, brush_gc, center-scale/2, center-scale/2, 
			 scale, scale);
	  break;
	case HLINE_B:
	  XDrawLine(disp, win, brush_gc, center-scale/2, center,
		    center+scale/2, center);
	  break;
	case VLINE_B:
	  XDrawLine(disp, win, brush_gc, center, center-scale/2,
		    center, center+scale/2);
	  break;
	case RLINE_B:
	  XDrawLine(disp, win, brush_gc, center-scale/2, center+scale/2,
		    center+scale/2, center-scale/2);
	  break;
	case LLINE_B:
	  XDrawLine(disp, win, brush_gc, center-scale/2, center-scale/2,
		    center+scale/2, center+scale/2);
	  break;
	case USER1_B:
	case USER2_B:
	case USER3_B:
	  p = give_brush(brush, BRUSH_MAX, &w, &h);
	  if (p!=NULL)
	    {
	      pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	      XSetStipple(disp, brush_gc, pixmap);
	      XCopyPlane(disp, pixmap, win, brush_gc, 0, 0, w, h, 
			 MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	      free(p);
	    }
	  XmScaleSetValue(brush_slider, 1);
	  break;
	}
      break;
    case EXPOSE:
      if (brush_times==0)
	{
	  brush = POINT_B;
	  scale = 1;
	  brush_times = 1;
	}
      XClearArea(disp, win, 0, 0, 0, 0, False);
      switch (brush)
	{
	case POINT_B:
	  XDrawPoint(disp, win, brush_gc, center, center);
	  break;
	case DISC_B:
	  if (scale==1)
	    XDrawPoint(disp, win, brush_gc, center, center);
	  else
	    XFillArc(disp, win, brush_gc, center-scale/2, center-scale/2, 
		     scale, scale, 0, 23040);
	  break;
	case BOX_B:
	  XFillRectangle(disp, win, brush_gc, center-scale/2, center-scale/2, 
			 scale, scale);
	  break;
	case HLINE_B:
	  XDrawLine(disp, win, brush_gc, center-scale/2, center,
		    center+scale/2, center);
	  break;
	case VLINE_B:
	  XDrawLine(disp, win, brush_gc, center, center-scale/2,
		    center, center+scale/2);
	  break;
	case RLINE_B:
	  XDrawLine(disp, win, brush_gc, center-scale/2, center+scale/2,
		    center+scale/2, center-scale/2);
	  break;
	case LLINE_B:
	  XDrawLine(disp, win, brush_gc, center-scale/2, center-scale/2,
		    center+scale/2, center+scale/2);
	  break;
	case USER1_B:
	case USER2_B:
	case USER3_B:
	  p = give_brush(brush, BRUSH_MAX, &w, &h);
	  if (p!=NULL)
	    {
	      pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	      XSetStipple(disp, brush_gc, pixmap);
	      XCopyPlane(disp, pixmap, win, brush_gc, 0, 0, w, h, 
			 MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	      free(p);
	    }
	  break;
	}
      break;
    case B_OK:
      create_brush(brush, scale);
    case B_CANCEL:
    default:
      XtUnmanageChild(op_brush_dialog);
      break;
    }
}




/*****************************************************************************
 *                     Options/Airbrush options... callbacks                  *
 *****************************************************************************/
/* FUNCTION:       options_airbrush_callback(Widget w, char *client_data,
                                             caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void options_airbrush_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  center_window(op_airbrush_dialog);
  XtManageChild(op_airbrush_dialog);
}



/* FUNCTION:       airbrush_dialog_callback(Widget widget_id, int client_data,
                                            caddr_t call_data)
   DESCRIPTION:    Callback for the buttons and sliderd in the Airrush 
                   options... dialog: 
                   
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or
                       B_CANCEL,
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th July 1993.
*/   
void airbrush_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  int size, flow;

  switch (client_data)
    { 
    case B_OK:
      XmScaleGetValue(airbrush_slider[SIZE], &size);
      XmScaleGetValue(airbrush_slider[FLOW], &flow);
      XtUnmanageChild(op_airbrush_dialog);
      set_airbrush(size, flow);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(op_airbrush_dialog);
      break;
    }
}



/*****************************************************************************
 *                      Options/Fill options... callbacks                   *
 *****************************************************************************/
/* FUNCTION:       options_fill_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void options_fill_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  center_window(op_fill_dialog);
  XtManageChild(op_fill_dialog);
}



/* FUNCTION:       fill_dialog_callback(Widget widget_id, int client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Callback for the buttons and the slider in the Fill 
                   options... dialog: 
                   
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK, B_CANCEL,
                       SLIDER or a number between 0 and 9 (these numbers 
		       represent the different fill patterns)
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void fill_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  static int fill, scale;
  Display *disp = XtDisplay(fill_window);
  Window win = XtWindow(fill_window);
  Window root = DefaultRootWindow(disp);
  Pixmap pixmap;
  char *p;
  int center = BRUSH_MAX/2;
  int w, h;
  int x, y;
  int toler;

  switch (client_data)
    { 
    case SOLID_F:
      XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
      fill = client_data;
      XmScaleSetValue(fill_slider, 1);
      break;
    case DISC_F:
      XmScaleGetValue(fill_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      if (scale==1)
	XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
      else
	for (y = 0; y<BRUSH_MAX; y += scale)
	  for (x = 0; x<BRUSH_MAX; x += scale)
	    XFillArc(disp, win, fill_gc, x, y, scale, scale, 0, 23040);	
      fill = client_data;
      break;
    case BOX_F:
      XmScaleGetValue(fill_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      if (scale==1)
	XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
      else
	for (y = 0; y<BRUSH_MAX; y += scale*2)
	  {
	    for (x = 0; x<BRUSH_MAX; x += scale*2)
	      XFillRectangle(disp, win, fill_gc, x, y, scale, scale);
	    for (x = scale; x<BRUSH_MAX; x += scale*2)
	      XFillRectangle(disp, win, fill_gc, x, y+scale, scale, scale);
	  }
      fill = client_data;
      break;
    case HLINE_F:
      XmScaleGetValue(fill_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      for (y = 0; y<BRUSH_MAX; y += scale)
	XDrawLine(disp, win, fill_gc, 0, y, BRUSH_MAX-1, y);
      fill = client_data;
      break;
    case VLINE_F:
      XmScaleGetValue(fill_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      for (x = 0; x<BRUSH_MAX; x += scale)
	XDrawLine(disp, win, fill_gc, x, 0, x, BRUSH_MAX-1);
      fill = client_data;
      break;
    case RLINE_F:
      XmScaleGetValue(fill_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      for (x = 0; x<BRUSH_MAX; x += scale)
	{
	  XDrawLine(disp, win, fill_gc, BRUSH_MAX-x, 0, 0, BRUSH_MAX-x);
	  XDrawLine(disp, win, fill_gc, x, BRUSH_MAX, BRUSH_MAX, x);
	}	  
      fill = client_data;
      break;
    case LLINE_F:
      XmScaleGetValue(fill_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      for (y = BRUSH_MAX; y>0; y -= scale)
	{
	  XDrawLine(disp, win, fill_gc, 0, BRUSH_MAX-y, y, BRUSH_MAX);
	  XDrawLine(disp, win, fill_gc, BRUSH_MAX-y, 0, BRUSH_MAX, y);
	}
      fill = client_data;
      break;
    case USER1_F:
    case USER2_F:
    case USER3_F:
      XClearArea(disp, win, 0, 0, 0, 0, False);
      fill = client_data;
      p = give_brush(fill, BRUSH_MAX, &w, &h);
      if (p!=NULL)
	{
	  pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	  XSetStipple(disp, fill_gc, pixmap);
	  XCopyPlane(disp, pixmap, win, fill_gc, 0, 0, w, h, 
		     MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	  free(p);
	}
      XmScaleSetValue(fill_slider, 1);
      break;
    case SLIDER:
      XmScaleGetValue(fill_slider, &scale);
      XClearArea(disp, win, 0, 0, 0, 0, False);
      switch (fill)
	{
	case SOLID_F:
	  XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
	  XmScaleSetValue(fill_slider, 1);
	  break;
	case DISC_F:
	  if (scale==1)
	    XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
	  else
	    for (y = 0; y<BRUSH_MAX; y += scale)
	      for (x = 0; x<BRUSH_MAX; x += scale)
		XFillArc(disp, win, fill_gc, x, y, scale, scale, 0, 23040);
	  break;
	case BOX_F:
	  if (scale==1)
	    XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
	  else
	    for (y = 0; y<BRUSH_MAX; y += scale*2)
	      {
		for (x = 0; x<BRUSH_MAX; x += scale*2)
		  XFillRectangle(disp, win, fill_gc, x, y, scale, scale);
		for (x = scale; x<BRUSH_MAX; x += scale*2)
		  XFillRectangle(disp, win, fill_gc, x, y+scale, scale, scale);
	      }
	  break;
	case HLINE_F:
	  for (y = 0; y<BRUSH_MAX; y += scale)
	    XDrawLine(disp, win, fill_gc, 0, y, BRUSH_MAX-1, y);
	  break;
	case VLINE_F:
	  for (x = 0; x<BRUSH_MAX; x += scale)
	    XDrawLine(disp, win, fill_gc, x, 0, x, BRUSH_MAX-1);
	  break;
	case RLINE_F:
	  for (x = 0; x<BRUSH_MAX; x += scale)
	    {
	      XDrawLine(disp, win, fill_gc, BRUSH_MAX-x, 0, 0, BRUSH_MAX-x);
	      XDrawLine(disp, win, fill_gc, x, BRUSH_MAX, BRUSH_MAX, x);
	    }	  
	  break;
	case LLINE_F:
	  for (y = BRUSH_MAX; y>0; y -= scale)
	    {
	      XDrawLine(disp, win, fill_gc, 0, BRUSH_MAX-y, y, BRUSH_MAX);
	      XDrawLine(disp, win, fill_gc, BRUSH_MAX-y, 0, BRUSH_MAX, y);
	    }
	  break;
	case USER1_F:
	case USER2_F:
	case USER3_F:
	  p = give_brush(fill, BRUSH_MAX, &w, &h);
	  if (p!=NULL)
	    {
	      pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	      XSetStipple(disp, fill_gc, pixmap);
	      XCopyPlane(disp, pixmap, win, fill_gc, 0, 0, w, h, 
			 MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	      free(p);
	    }
	  XmScaleSetValue(fill_slider, 1);
	  break;
	}
      break;
    case EXPOSE:
      if (fill_times==0)
	{
	  fill = SOLID_F;
	  scale = 1;
	  fill_times = 1;
	}
      XClearArea(disp, win, 0, 0, 0, 0, False);
      switch (fill)
	{
	case SOLID_F:
	  XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
	  break;
	case DISC_F:
	  if (scale==1)
	    XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
	  else
	    for (y = 0; y<BRUSH_MAX; y += scale)
	      for (x = 0; x<BRUSH_MAX; x += scale)
		XFillArc(disp, win, fill_gc, x, y, scale, scale, 0, 23040);
	  break;
	case BOX_F:
	  if (scale==1)
	    XFillRectangle(disp, win, fill_gc, 0, 0, BRUSH_MAX, BRUSH_MAX);
	  else
	    for (y = 0; y<BRUSH_MAX; y += scale*2)
	      {
		for (x = 0; x<BRUSH_MAX; x += scale*2)
		  XFillRectangle(disp, win, fill_gc, x, y, scale, scale);
		for (x = scale; x<BRUSH_MAX; x += scale*2)
		  XFillRectangle(disp, win, fill_gc, x, y+scale, scale, scale);
	      }
	  break;
	case HLINE_F:
	  for (y = 0; y<BRUSH_MAX; y += scale)
	    XDrawLine(disp, win, fill_gc, 0, y, BRUSH_MAX-1, y);
	  break;
	case VLINE_F:
	  for (x = 0; x<BRUSH_MAX; x += scale)
	    XDrawLine(disp, win, fill_gc, x, 0, x, BRUSH_MAX-1);
	  break;
	case RLINE_F:
	  for (x = 0; x<BRUSH_MAX; x += scale)
	    {
	      XDrawLine(disp, win, fill_gc, BRUSH_MAX-x, 0, 0, BRUSH_MAX-x);
	      XDrawLine(disp, win, fill_gc, x, BRUSH_MAX, BRUSH_MAX, x);
	    }	  
	  break;
	case LLINE_F:
	  for (y = BRUSH_MAX; y>0; y -= scale)
	    {
	      XDrawLine(disp, win, fill_gc, 0, BRUSH_MAX-y, y, BRUSH_MAX);
	      XDrawLine(disp, win, fill_gc, BRUSH_MAX-y, 0, BRUSH_MAX, y);
	    }
	  break;
	case USER1_F:
	case USER2_F:
	case USER3_F:
	  p = give_brush(fill, BRUSH_MAX, &w, &h);
	  if (p!=NULL)
	    {
	      pixmap = XCreateBitmapFromData(disp, root, p, w, h);
	      XSetStipple(disp, fill_gc, pixmap);
	      XCopyPlane(disp, pixmap, win, fill_gc, 0, 0, w, h, 
			 MAX(center-w/2, 0), MAX(center-h/2, 0), 1);
	      free(p);
	    }
	  break;
	}
      break;
    case B_OK:
      XmScaleGetValue(toler_slider, &toler);
      XtUnmanageChild(op_fill_dialog);
      create_fill(fill, scale, toler);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(op_fill_dialog);
      break;
    }
}


/*****************************************************************************
 *                      Options/Set hot spot... callbacks                    *
 *****************************************************************************/
/* FUNCTION:       options_hotspot_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void options_hotspot_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  center_window(op_hotspot_dialog);
  XtManageChild(op_hotspot_dialog);
}



/* FUNCTION:       hotspot_dialog_callback(Widget widget_id, int client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Hot spot dialog. 
                   
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK, B_CANCEL,
                       number between 0 and 9 (#defines in tools.h).
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 13th August 1993.
*/   
void hotspot_dialog_callback(Widget widget_id, int client_data,
			     caddr_t call_data) 
{
  static int hotspot;

  if (hotspot_times==0)
    {
      hotspot = CENTER_HS;
      hotspot_times = 1;
    }
  switch (client_data)
    { 
    case CENTER_HS:
    case LEFT_HS:
    case RIGHT_HS:
    case TOP_HS:
    case BOTTOM_HS:
    case TOPLEFT_HS:
    case TOPRIGHT_HS:
    case BOTTOMLEFT_HS:
    case BOTTOMRIGHT_HS:
      hotspot = client_data;
      break;
    case B_OK:
      XtUnmanageChild(op_hotspot_dialog);
      set_hotspot(hotspot);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(op_hotspot_dialog);
      break;
    }
}



/*****************************************************************************
 *                  Options/Range select... callbacks                        *
 *****************************************************************************/
/* FUNCTION:       options_range_callback(Widget w, char *client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th August 1993.
*/   
void options_range_callback(Widget widget_id, char *client_data,
			     caddr_t call_data)
{
  center_window(op_range_dialog);      
  XtManageChild(op_range_dialog);
}



/* FUNCTION:       range_dialog_callback(Widget widget_id, int client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Options/Range select
                   options... dialog: Gets the desired range, and calls 
		   set_select_tolerance in the main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL, defined in X_misc.h
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 21th August 1993.
*/   
void range_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  int scale;

  switch (client_data)
    { 
    case B_OK:
      XmScaleGetValue(range_slider, &scale);
      XtUnmanageChild(op_range_dialog);
      set_select_tolerance(scale);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(op_range_dialog);
      break;
    }
}



/*****************************************************************************
 *                  Options/Display options... callbacks                     *
 *****************************************************************************/
/* FUNCTION:       options_display_callback(Widget w, char *client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 31st August 1993.
*/   
void options_display_callback(Widget widget_id, char *client_data,
			     caddr_t call_data)
{
  center_window(op_display_dialog);      
  XtManageChild(op_display_dialog);
}



/* FUNCTION:       display_dialog_callback(Widget widget_id, int client_data,
                                           caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Options/Display
                   options... dialog: Gets the desired grid, and calls 
		   set_grid in the main module.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be G_X_UP,
                       G_X_DOWN, G_Y_UP, G_Y_DOWN, B_OK or B_CANCEL, 
		       defined in dialogw.h and X_misc.h 
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 31st August 1993.
*/   
void display_dialog_callback(Widget widget_id, int client_data, 
			     caddr_t call_data)
{
  char *s;
  int n;
  int x, y;
  Arg wargs[2];
  switch (client_data)
    { 
    case G_X_UP:
      s = XmTextGetString(grid_coords[G_X]);
      n = atoi(s);
      XtFree(s);
      if (n<=1)
	n = 10;
      else
	n += 10;
      sprintf(s, "%d", n);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(grid_coords[G_X], wargs, 1);
      break;
    case G_X_DOWN:
      s = XmTextGetString(grid_coords[G_X]);
      n = atoi(s);
      XtFree(s);
      if (n<=11)
	n = 1;
      else
	n -= 10;
      sprintf(s, "%d", n);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(grid_coords[G_X], wargs, 1);
      break;
    case G_Y_UP:
      s = XmTextGetString(grid_coords[G_Y]);
      n = atoi(s);
      XtFree(s);
      if (n<=1)
	n = 10;
      else
	n += 10;
      sprintf(s, "%d", n);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(grid_coords[G_Y], wargs, 1);
      break;
    case G_Y_DOWN:
      s = XmTextGetString(grid_coords[G_Y]);
      n = atoi(s);
      XtFree(s);
      if (n<=11)
	n = 1;
      else
	n -= 10;
      sprintf(s, "%d", n);
      XtSetArg(wargs[0], XmNvalue, s);
      XtSetValues(grid_coords[G_Y], wargs, 1);
      break;
    case B_OK:
      s = XmTextGetString(grid_coords[G_X]);
      x = atoi(s);
      if (x<=0)
	{
	  show_errormsg("Invalid horizontal density parameter.", "OK", NULL);
	  break;
	}
      s = XmTextGetString(grid_coords[G_Y]);
      y = atoi(s);
      if (y<=0)
	{
	  show_errormsg("Invalid invalid vertical density parameter.", "OK", 
			NULL);
	  break;
	}
      XtUnmanageChild(op_display_dialog);
      XtFree(s);
      set_grid(XmToggleButtonGetState(snap_grid),
	       XmToggleButtonGetState(show_grid), x, y);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(op_display_dialog);
      break;
    }
}



/*****************************************************************************
 *                      Options/Copy options... callbacks                    *
 *****************************************************************************/
/* FUNCTION:       options_copy_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Pops up the dialog.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 14th August 1993.
*/   
void options_copy_callback(Widget widget_id, char *client_data,
			    caddr_t call_data)
{
  center_window(op_copy_dialog);
  XtManageChild(op_copy_dialog);
}


/* FUNCTION:       copy_dialog_callback(Widget widget_id, int client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Callback for the buttons in the Options/Copy options... 
                   dialog. 
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or
                       B_CANCEL.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 14th August 1993.
*/   
void copy_dialog_callback(Widget widget_id, int client_data,
			  caddr_t call_data) 
{
  long bits = 0;
  
  switch (client_data)
    { 
    case R_C:
      if (!r_set)
	{
	  XmToggleButtonSetState(channels[R_1], True, False);
	  XmToggleButtonSetState(channels[R_2], True, False);
	  XmToggleButtonSetState(channels[R_3], True, False);
	  XmToggleButtonSetState(channels[R_4], True, False);
	  XmToggleButtonSetState(channels[R_5], True, False);
	  XmToggleButtonSetState(channels[R_6], True, False);
	  XmToggleButtonSetState(channels[R_7], True, False);
	  XmToggleButtonSetState(channels[R_8], True, False);
	  r_set = True;
	}
      else
	{
	  XmToggleButtonSetState(channels[R_1], False, False);
	  XmToggleButtonSetState(channels[R_2], False, False);
	  XmToggleButtonSetState(channels[R_3], False, False);
	  XmToggleButtonSetState(channels[R_4], False, False);
	  XmToggleButtonSetState(channels[R_5], False, False);
	  XmToggleButtonSetState(channels[R_6], False, False);
	  XmToggleButtonSetState(channels[R_7], False, False);
	  XmToggleButtonSetState(channels[R_8], False, False);
	  r_set = False;
	}
      break;
    case G_C:
      if (!g_set)
	{
	  XmToggleButtonSetState(channels[G_1], True, False);
	  XmToggleButtonSetState(channels[G_2], True, False);
	  XmToggleButtonSetState(channels[G_3], True, False);
	  XmToggleButtonSetState(channels[G_4], True, False);
	  XmToggleButtonSetState(channels[G_5], True, False);
	  XmToggleButtonSetState(channels[G_6], True, False);
	  XmToggleButtonSetState(channels[G_7], True, False);
	  XmToggleButtonSetState(channels[G_8], True, False);
	  g_set = True;
	}
      else
	{
	  XmToggleButtonSetState(channels[G_1], False, False);
	  XmToggleButtonSetState(channels[G_2], False, False);
	  XmToggleButtonSetState(channels[G_3], False, False);
	  XmToggleButtonSetState(channels[G_4], False, False);
	  XmToggleButtonSetState(channels[G_5], False, False);
	  XmToggleButtonSetState(channels[G_6], False, False);
	  XmToggleButtonSetState(channels[G_7], False, False);
	  XmToggleButtonSetState(channels[G_8], False, False);
	  g_set = False;
	}
      break;
    case B_C:
      if (!b_set)
	{
	  XmToggleButtonSetState(channels[B_1], True, False);
	  XmToggleButtonSetState(channels[B_2], True, False);
	  XmToggleButtonSetState(channels[B_3], True, False);
	  XmToggleButtonSetState(channels[B_4], True, False);
	  XmToggleButtonSetState(channels[B_5], True, False);
	  XmToggleButtonSetState(channels[B_6], True, False);
	  XmToggleButtonSetState(channels[B_7], True, False);
	  XmToggleButtonSetState(channels[B_8], True, False);
	  b_set = True;
	}
      else
	{
	  XmToggleButtonSetState(channels[B_1], False, False);
	  XmToggleButtonSetState(channels[B_2], False, False);
	  XmToggleButtonSetState(channels[B_3], False, False);
	  XmToggleButtonSetState(channels[B_4], False, False);
	  XmToggleButtonSetState(channels[B_5], False, False);
	  XmToggleButtonSetState(channels[B_6], False, False);
	  XmToggleButtonSetState(channels[B_7], False, False);
	  XmToggleButtonSetState(channels[B_8], False, False);
	  b_set = False;
	}
    case R_1:
    case R_2:
    case R_3:
    case R_4:
    case R_5:
    case R_6:
    case R_7:
    case R_8:
      if (XmToggleButtonGetState(channels[R_1]) &&
	  XmToggleButtonGetState(channels[R_2]) &&
	  XmToggleButtonGetState(channels[R_3]) &&
	  XmToggleButtonGetState(channels[R_4]) &&
	  XmToggleButtonGetState(channels[R_5]) &&
	  XmToggleButtonGetState(channels[R_6]) &&
	  XmToggleButtonGetState(channels[R_7]) &&
	  XmToggleButtonGetState(channels[R_8]))
	{
	  XmToggleButtonSetState(channels[R_C], True, False);
	  r_set = True;
	}
      else
	{
	  XmToggleButtonSetState(channels[R_C], False, False);
	  r_set = False;
	}
      break;
    case G_1:
    case G_2:
    case G_3:
    case G_4:
    case G_5:
    case G_6:
    case G_7:
    case G_8:
      if (XmToggleButtonGetState(channels[G_1]) &&
	  XmToggleButtonGetState(channels[G_2]) &&
	  XmToggleButtonGetState(channels[G_3]) &&
	  XmToggleButtonGetState(channels[G_4]) &&
	  XmToggleButtonGetState(channels[G_5]) &&
	  XmToggleButtonGetState(channels[G_6]) &&
	  XmToggleButtonGetState(channels[G_7]) &&
	  XmToggleButtonGetState(channels[G_8]))
	{
	  XmToggleButtonSetState(channels[G_C], True, False);
	  g_set = True;
	}
      else
	{
	  XmToggleButtonSetState(channels[G_C], False, False);
	  g_set = False;
	}
      break;
    case B_1:
    case B_2:
    case B_3:
    case B_4:
    case B_5:
    case B_6:
    case B_7:
    case B_8:
      if (XmToggleButtonGetState(channels[B_1]) &&
	  XmToggleButtonGetState(channels[B_2]) &&
	  XmToggleButtonGetState(channels[B_3]) &&
	  XmToggleButtonGetState(channels[B_4]) &&
	  XmToggleButtonGetState(channels[B_5]) &&
	  XmToggleButtonGetState(channels[B_6]) &&
	  XmToggleButtonGetState(channels[B_7]) &&
	  XmToggleButtonGetState(channels[B_8]))
	{
	  XmToggleButtonSetState(channels[B_C], True, False);
	  b_set = True;
	}
      else
	{
	  XmToggleButtonSetState(channels[B_C], False, False);
	  b_set = False;
	}
      break;
    case B_OK:
      if (XmToggleButtonGetState(channels[R_1]))
	bits |= 1<<23;
      if (XmToggleButtonGetState(channels[R_2]))
	bits |= 1<<22;
      if (XmToggleButtonGetState(channels[R_3]))
	bits |= 1<<21;
      if (XmToggleButtonGetState(channels[R_4]))
	bits |= 1<<20;
      if (XmToggleButtonGetState(channels[R_5]))
	bits |= 1<<19;
      if (XmToggleButtonGetState(channels[R_6]))
	bits |= 1<<18;
      if (XmToggleButtonGetState(channels[R_7]))
	bits |= 1<<17;
      if (XmToggleButtonGetState(channels[R_8]))
	bits |= 1<<16;
      if (XmToggleButtonGetState(channels[G_1]))
	bits |= 1<<15;
      if (XmToggleButtonGetState(channels[G_2]))
	bits |= 1<<14;
      if (XmToggleButtonGetState(channels[G_3]))
	bits |= 1<<13;
      if (XmToggleButtonGetState(channels[G_4]))
	bits |= 1<<12;
      if (XmToggleButtonGetState(channels[G_5]))
	bits |= 1<<11;
      if (XmToggleButtonGetState(channels[G_6]))
	bits |= 1<<10;
      if (XmToggleButtonGetState(channels[G_7]))
	bits |= 1<<9;
      if (XmToggleButtonGetState(channels[G_8]))
	bits |= 1<<8;
      if (XmToggleButtonGetState(channels[B_1]))
	bits |= 1<<7;
      if (XmToggleButtonGetState(channels[B_2]))
	bits |= 1<<6;
      if (XmToggleButtonGetState(channels[B_3]))
	bits |= 1<<5;
      if (XmToggleButtonGetState(channels[B_4]))
	bits |= 1<<4;
      if (XmToggleButtonGetState(channels[B_5]))
	bits |= 1<<3;
      if (XmToggleButtonGetState(channels[B_6]))
	bits |= 1<<2;
      if (XmToggleButtonGetState(channels[B_7]))
	bits |= 1<<1;
      if (XmToggleButtonGetState(channels[B_8]))
	bits |= 1;
      XtUnmanageChild(op_copy_dialog);
      set_copy_bits(bits);
      break;
    case B_CANCEL:
    default:
      XtUnmanageChild(op_copy_dialog);
      break;
    }
}



/*****************************************************************************
 *                            Help/About... callbacks                        *
 *****************************************************************************/
/* FUNCTION:       help_about_callback(Widget w, char *client_data,
                                          caddr_t call_data)
   DESCRIPTION:    Shows the help about screen.
   PARAMETERS:
   Widget widget_id   Widget_id of the widget that caused the callback.
   char *client_data  Pre-defined character data.
   caddr_t call_data  Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 18th August 1993.
*/   
void help_about_callback(Widget widget_id, char *client_data,
			 caddr_t call_data)
{
  center_window(he_about_dialog);
  XtManageChild(he_about_dialog);
}


/* FUNCTION:       about_dialog_callback(Widget widget_id, caddr_t client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Unmanages the help dialog.
   PARAMETERS:
   Widget widget_id    Widget_id of the widget that caused the callback.
   caddr_t client_data Not used.
   caddr_t call_data   Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 20th August 1993.
*/
void about_dialog_callback(Widget widget_id, caddr_t client_data,
			   caddr_t call_data)
{
  XtUnmanageChild(he_about_dialog);
}   

/*****************************************************************************
 *                          Generic dialog callbacks                         *
 *****************************************************************************/

/* FUNCTION:       error_dialog_callback(Widget widget_id, int client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Callback for the ok button in the error dialog: 
                   unmanages the dialog.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 9th July 1993.
*/   
void error_dialog_callback(Widget widget_id, int client_data,
			   caddr_t call_data)
{
  XtUnmanageChild(error_dialog);
  if (error_func!=NULL)
    (*error_func)(client_data);
}  

/* FUNCTION:       question_dialog_callback(Widget widget_id, int client_data,
                                         caddr_t call_data)
   DESCRIPTION:    Callback for the ok and cancel buttons in the question
                   dialog: calls the function in the pointer question_func and 
		   unmanages the dialog.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK or 
                       B_CANCEL.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 9th July 1993.
*/   
void question_dialog_callback(Widget widget_id, int client_data,
			      caddr_t call_data)
{
  XtUnmanageChild(question_dialog);
  if (question_func!=NULL)
    (*question_func)(client_data);
}  


/* FUNCTION:       question3_dialog_callback(Widget widget_id, int client_data,
                                             caddr_t call_data)
   DESCRIPTION:    Callback for the ok, no and cancel buttons in the question3
                   dialog: calls the function in the pointer question_func and 
		   unmanages the dialog.
   PARAMETERS:
   Widget widget_id  Widget_id of the widget that caused the callback.
   int client_data   Number describing callback nature, can be B_OK, B_NO or 
                       B_CANCEL.
   caddr_t call_data Event structure.
   RETURNS:        Nothing.

   Written by Vesa T|rm{nen, last modifications 4th August 1993.
*/   
void question3_dialog_callback(Widget widget_id, int client_data,
			       caddr_t call_data)
{
  XtUnmanageChild(question3_dialog);
  if (question_func!=NULL)
    (*question_func)(client_data);
}  

