/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include "nurbh.h"

#define LINE printf("*************************************\n")

PR_nurb c1, c2, c3, c4;
PR_nurb s1, s2, s3, s4;

Pint ee,ii,nsteps;

Pfloat dt,t1,t2;
Pmatrix3 xx;
Pvector3 v1;
Ppoint3 p1;

void putpoint3(C(FILE *)fp, C(Ppoint3)xx)
PreANSI(FILE *fp)
PreANSI(Ppoint3 xx)
{
fprintf(fp,"%12.4g%12.4g%12.4g",xx.x,xx.y,xx.z);
}

main()
{
  printf("Testing NURBS\n");

  nrb_clear(&c1);
  nrb_clear(&c2);
  nrb_clear(&c3);
  nrb_clear(&c4);

  nrb_clear(&s1);
  nrb_clear(&s2);
  nrb_clear(&s3);
  nrb_clear(&s4);

  LINE;
  printf("Circle\n");
  nrb_circle(&c1);
  nrb_dump(stdout,&c1);
  LINE;
  printf("Elevated circle\n");
  nrb_elevate(FALSE,&c1,&c2);
  nrb_dump(stdout,&c2);
  nsteps=50;

  for (ii = 0; ii<= nsteps; ii++)
  {
    t1 = (Pfloat) ii/ (Pfloat) nsteps;	/* 0-1 */
    t2 = 2.0*3.141592653*t1; 		/* 0 - 2pi*/
    nrb_bvalue(&c1,t1,0,&s1);
    nrb_bvalue(&c2,t1,0,&s2);
    printf("%6.4g%7.4g\n",t1,t2);
    printf("          ");

    p1 =ptk_pt4topt3(&(s1.pf_ppp->pts[0]));
    v1 = ptk_pt3tovec3(&p1);
    printf("%12.4g\n",ptk_modv(&v1));

    printf("          ");
    p1 =ptk_pt4topt3(&(s2.pf_ppp->pts[0]));
    v1 = ptk_pt3tovec3(&p1);
    printf("%12.4g\n",ptk_modv(&v1));

    printf("          ");
    putpoint3(stdout,ptk_vector3(cos(t2),sin(t2),0.0));

    v1 = ptk_vector3(cos(t2),sin(t2),0.0);
    printf("%12.4g\n",ptk_modv(&v1));
  }

  nrb_stats(stdout);
  nrb_dumplists(stdout);

  printf("End of NURBs test.\n");
  return 0;
}

/* End. */
