/* nrbdemo1.c 
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <ptk.h>

/* Declarations */
PR_nurb c1;                             /* NURB curve                    */
PR_nurb s1;                             /* NURB surface                  */
Pvector3 v1;                            /* Scaling Vector                */

Pint ee;                                /* Extrusion Error               */

Pmatrix3 xx;                            /* Tranformation Matrix          */

main()
{
  printf("Testing NURBS\n");

  nrb_initialise;                       /* Start up NURBS library        */

  nrb_clear(&c1);                       /* Make sure the data structures */
  nrb_clear(&s1);                       /* are empty                     */

  nrb_circle(&c1);                      /* Make c1 a circle              */

  v1 =ptk_vector3(100.0,100.0,100.0);
  ptk_scale3(&v1,PREPLACE,xx);
  nrb_xform(&c1,xx);                    /* Transform the unit circle, so */
                                        /* it is 100 units in radius     */

  nrb_dump(stdout,&c1);                 /* Print it out the contents of  */
                                        /* the NURB structure            */
  printf("Unit Cylinder\n");
  v1=ptk_vector3(0.0,0.0,100.0);
  nrb_extrude(&c1,v1,&s1,&ee);         /* Convert it to a cylinder by   */
                                        /* extrusion                     */
  nrb_dump(stdout,&s1);                 /* Print it out the contents of  */
                                        /* the NURB structure            */

  nrb_stats(stdout);                    /* Print out some statistics     */
  nrb_dumplists(stdout);  

  printf("End of NURBs test.\n");
}
