/*
 * file:     fontMenu.c
 * author:   Wes Barris
 * date:     5/06/92
 * purpose:  creates Font menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <sys/types.h>
#include <sys/dir.h>
#include <X11/StringDefs.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include "Umsc/List.h"
#include "PSutils.h"

extern DESI		desi;
extern UmscList		theList;
extern GenericInfo	defaultInfo;
extern TextInfo		selectedText;

static Widget		fontMenu;

int			extraFonts[N_EXT_FONTS];

void
LookForFonts(void)
{
   DIR	*dirp;
   struct direct *dp;
   int	i;

   for (i=0; i<N_EXT_FONTS; i++)
      extraFonts[i] = 0;
   dirp = opendir("/usr/lib/DPS/outline/base");
   if (dirp == NULL)
      printf("Can't open dps font directory.\n");
   while ((dp = readdir(dirp)) != NULL) {
      for (i=0; i<N_EXT_FONTS; i++)
         if (!strcmp(dp->d_name, font_info[i].name))
            extraFonts[font_info[i].id] = 1;
      }
   closedir(dirp);
}


char *
MakeName(int font, int style)
{
   int i;

   if (font == TIMES) {
      if (style == ROMAN)
         return "Times-Roman";
      else if (style == BOLD)
         return "Times-Bold";
      else if (style == ITALIC)
         return "Times-Italic";
      else if (style == BOLDITALIC)
         return "Times-BoldItalic";
      }
   else if (font == HELVETICA) {
      if (style == ROMAN)
         return "Helvetica";
      else if (style == BOLD)
         return "Helvetica-Bold";
      else if (style == ITALIC)
         return "Helvetica-Oblique";
      else if (style == BOLDITALIC)
         return "Helvetica-BoldOblique";
      }
   else if (font == COURIER) {
      if (style == ROMAN)
         return "Courier";
      else if (style == BOLD)
         return "Courier-Bold";
      else if (style == ITALIC)
         return "Courier-Oblique";
      else if (style == BOLDITALIC)
         return "Courier-BoldOblique";
      }
   else if (font == UTOPIA) {
      if (style == ROMAN)
         return "Utopia-Regular";
      else if (style == BOLD)
         return "Utopia-Bold";
      else if (style == ITALIC)
         return "Utopia-Italic";
      else if (style == BOLDITALIC)
         return "Utopia-BoldItalic";
      }
   else if (font == SYMBOL)
      return "Symbol";
   else
      for (i=0; i<N_EXT_FONTS; i++)
         if (font_info[i].id == font)
            return font_info[i].name;
   return "unknown font";
}


static void
SetFontCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n;
/*
 * Return if the button is unselected or if this event was triggered by
 * calling XmToggleButtonSetState.
 */
   if (!((XmToggleButtonCallbackStruct *)call_data)->set || !((XmToggleButtonCallbackStruct *)call_data)->event)
      return;
/*
 * Make a valid font name for both the default text and any selected text.
 */
   strcpy(defaultInfo.u.text.fontname,
          MakeName((int)client_data, defaultInfo.u.text.fontstyle));
   strcpy(selectedText.fontname, MakeName((int)client_data, selectedText.fontstyle));
   selectedText.font = defaultInfo.u.text.font = (int)client_data;
/*
 * But wait, are there any selected text objects?
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->objtype == TXTOBJ && thisObject->selected == True) {
         thisObject->u.text.font = selectedText.font;
         thisObject->u.text.fontstyle = selectedText.fontstyle;
         strcpy(thisObject->u.text.fontname, selectedText.fontname);
         DrawText(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
}


static struct {
   char		*name;		/* name of menu item widget */
   void		(*func)(Widget, XtPointer, char*);	/* callback function */
   int		data;		/* callback data */
   } items[] = {
      { "courier",	SetFontCB,	COURIER		},
      { "helvetica",	SetFontCB,	HELVETICA	},
      { "symbol",	SetFontCB,	SYMBOL		},
      { "times",	SetFontCB,	TIMES		},
      { "utopia",	SetFontCB,	UTOPIA		},
      };

static void
SetItemCB(w, client_data, call_data)
Widget			w;
char			*client_data;
XmAnyCallbackStruct	*call_data;
{
   int	i;
/*
 * Set the font item so that it matches that of the selected text.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].data == selectedText.font) {
         XmToggleButtonSetState(XtNameToWidget(fontMenu, items[i].name), True, True);
         return;
         }
      else
         XmToggleButtonSetState(XtNameToWidget(fontMenu, items[i].name), False, False);
      }

      for (i = 0; i < N_EXT_FONTS; i++)
         if (font_info[i].id > 5) {
            if (font_info[i].id == selectedText.font) {
               XmToggleButtonSetState(
                       XtNameToWidget(fontMenu, font_info[i].name), True, True);
               return;
               }
            else
               XmToggleButtonSetState(
                     XtNameToWidget(fontMenu, font_info[i].name), False, False);
            }
}


void
FontMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	w;

/*
 * Create pulldown menu.
 */
   LookForFonts();
   n = 0;
   XtSetArg(arg[n], XmNradioBehavior, True); n++;
   fontMenu = XmCreatePulldownMenu(parent, "fontMenu", arg, n);
/*
 * Create the entries for the file menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].name != NULL) {
         w = XmCreateToggleButton(fontMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNvalueChangedCallback, (XtCallbackProc)items[i].func, (char *)items[i].data);
         }
      else 
         w = XmCreateSeparator(fontMenu, "sep", arg, 0);
      XtManageChild(w);
      }
/*
 * Add extra fonts to menu?
 */
   w = XtCreateManagedWidget("sep",xmSeparatorWidgetClass,fontMenu,arg,0);
   for (i = 0; i < N_EXT_FONTS; i++) {
      if (font_info[i].id > 5) {
         XtSetArg(arg[0],XmNsensitive,(extraFonts[font_info[i].id]?True:False));
         w = XtCreateManagedWidget(font_info[i].name,
                                   xmToggleButtonWidgetClass,
                                   fontMenu,arg,1);
         XtAddCallback(w, XmNvalueChangedCallback,
                       (XtCallbackProc)SetFontCB, (char *)font_info[i].id);
         }
      }
/*
 * Create the Edit cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, fontMenu); n++;
   w = XmCreateCascadeButton(parent, "fonts", arg, n);
   XtAddCallback(w, XmNcascadingCallback, (XtCallbackProc)SetItemCB, NULL);
   XtManageChild(w);
}
