/*
 * file:     addMenu.c
 * author:   Wes Barris
 * date:     2/25/92
 * purpose:  creates a couple cursors
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <X11/cursorfont.h>

extern DESI		desi;

void
BusyCursorCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	*call_data;
{
   static Cursor busyCursor = (Cursor) 0;    
/*
 * Make a busy cursor.
 */
   if (busyCursor == (Cursor) 0) {
      XColor colors[2];

      colors[0].pixel = 1;
      colors[1].pixel = 0;
      XQueryColors(XtDisplay(desi.toplevel),
                   DefaultColormap(XtDisplay(desi.toplevel),
                   DefaultScreen(XtDisplay(desi.toplevel))), colors, 2);
      busyCursor = XCreateFontCursor(XtDisplay(desi.toplevel), XC_watch);
      XRecolorCursor(XtDisplay(desi.toplevel), busyCursor,
                     &colors[0], &colors[1]);
      }
   XDefineCursor(XtDisplay(desi.toplevel), XtWindow(desi.toplevel), busyCursor);
   XFlush(XtDisplay(desi.toplevel));
   return;
}


void
UnBusyCursorCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	*call_data;
{
   static Cursor unBusyCursor = (Cursor) 0;

   if (unBusyCursor == (Cursor) 0) {
      XColor colors[2];

      colors[0].pixel = 1;
      colors[1].pixel = 0;
      XQueryColors(XtDisplay(desi.toplevel),
                   DefaultColormap(XtDisplay(desi.toplevel),
                   DefaultScreen(XtDisplay(desi.toplevel))), colors, 2);
      unBusyCursor = XCreateFontCursor(XtDisplay(desi.toplevel), XC_left_ptr);
      XRecolorCursor(XtDisplay(desi.toplevel), unBusyCursor,
                     &colors[0], &colors[1]);
      }
   XDefineCursor(XtDisplay(desi.toplevel), XtWindow(desi.toplevel),
                 unBusyCursor);
   XFlush(XtDisplay(desi.toplevel));
   return;
}
