/*
 *      File:	ProtoMacro.h
 *    Module:	-
 *      Date:	11/03/92
 *    Author:	Daniel B. Waylonis (danw@msc.edu)
 *   Purpose:	Setup some macros for no-prototypes vs. prototypes
 *
 *   Copyright @ 1992 by Research Equipment Inc. (dba)
 *   Minnesota Supercomputer Center, Inc.
 *
 *   Proprietary Information of Minnesota Supercomputer Center, Inc. -
 *   DO NOT DISCLOSE
 *
 * RESTRICTED RIGHTS LEGEND
 *   Use, duplication, or disclosure of this software and its documentation
 *   by the Government is subject to restrictions as set forth in subdivision
 *   { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 *   clause at 52.227-7013.
 *
 * $Log: ProtoMacro.h,v $
 * Revision 1.1  1992/12/02  17:35:49  danw
 * Initial revision
 *
 * Revision 1.1  1992/12/02  17:35:49  danw
 * Initial revision
 *
 * 
 */

#ifndef _Umsc_ProtoMacro_H
#define _Umsc_ProtoMacro_H
/*-------------------------------------------------------------------------*/

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) && !defined(_NO_PROTO)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif

/* Macro for ANSI or K&R external declarations.  Declare them like this:
**
**      int foo _(( int, MapAg ));
**
** DO NOT forget whitespace before the '_' !!
*/
#ifndef _
#if NeedFunctionPrototypes
#define _(a) a		/* ANSI results in: int foo ( int, MapAg ); */
#else
#define _(a) ()		/* K&R  results in: int foo (); */
#endif
#endif

/*
 * macro to make things C++ compatable
 */
#if defined(__cplusplus) || defined(c_plusplus)
#define UmscProtoBegin extern "C" {
#define UmscProtoEnd }
#else
#define UmscProtoBegin
#define UmscProtoEnd
#endif

/*-------------------------------------------------------------------------*/
#endif
