/* $Id$ */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Log$
 */




#include "context.h"



/*
 * Apply gamma correction to an array of RGB pixels.
 */
void
gl_apply_gamma( GLuint n, GLubyte red[], GLubyte green[], GLubyte blue[] )
{
   GLuint i;

   for (i=0;i<n;i++) {
      red[i]   = CC.RedRamp[red[i]];
      green[i] = CC.GreenRamp[green[i]];
      blue[i]  = CC.BlueRamp[blue[i]];
   }
}
