/* nurbs.h */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Id: nurbs.h,v 1.2 1995/07/28 21:36:49 brianp Exp $

$Log: nurbs.h,v $
 * Revision 1.2  1995/07/28  21:36:49  brianp
 * changed all GLUenum to GLenum
 *
 * Revision 1.1  1995/07/28  17:38:30  brianp
 * Initial revision
 *
 */


/*
 * NURBS implementation written by Bogdan Sikorski (gstbs@io.coi.pw.edu.pl)
 * See README-nurbs for more info.
 */


#include "gluP.h"

#define EPSILON 1e-06 /* epsilon for double precision compares */

typedef enum
{
	GLU_NURBS_CURVE, GLU_NURBS_SURFACE, GLU_NURBS_TRIM, GLU_NURBS_NO_TRIM,
	GLU_NURBS_NONE
} GLU_nurbs_enum;


typedef struct
{
	GLint	sknot_count;
	GLfloat *sknot;
	GLint	tknot_count;
	GLfloat	*tknot;
	GLint	s_stride;
	GLint	t_stride;
	GLfloat	*ctrlarray;
	GLint	sorder;
	GLint	torder;
	GLenum	type;
} nurbs_surface;

typedef struct
{
	int	dummy;
} nurbs_trim;

typedef struct
{
	GLfloat model[16],proj[16],viewport[4];
} culling_and_sampling_str;

struct GLUnurbsObj {
	GLboolean		culling;
	GLenum			error;
	void			(*error_callback)( GLenum err );
	GLenum			display_mode;
	GLU_nurbs_enum	nurbs_type;
	GLboolean		auto_load_matrix;
	culling_and_sampling_str
					sampling_matrices;
	GLfloat			sampling_tolerance;
	nurbs_surface	surface;
	nurbs_trim		trim;
};

typedef struct
{
	GLfloat		*knot;
	GLint		nknots;
	GLint		order;
	GLfloat		t_min,t_max;
	GLint		delta_nknots;
	GLboolean	open_at_begin,open_at_end;
	GLfloat		*new_knot;
	GLfloat		*alpha;
} knot_str_type;

void call_user_error( GLUnurbsObj *nobj, GLenum error );

GLenum explode_knot(knot_str_type *the_knot);

GLenum calc_alphas(knot_str_type *the_knot);

GLenum calc_new_ctrl_pts(GLfloat *ctrl,GLint stride,knot_str_type *the_knot,
	GLint dim,GLfloat **new_ctrl,GLint *ncontrol);

GLenum glu_do_sampling_2D(GLUnurbsObj *nobj, GLfloat *new_ctrl,GLint n_ctrl,
	GLint order,GLint dim,GLint **factors);

GLenum glu_do_sampling_3D(GLUnurbsObj *nobj, GLfloat *ctrl, GLint scnt,
	GLint tcnt, GLint dim, GLint **sfactors, GLint **tfactors);

GLboolean culling_test_3D(GLUnurbsObj *nobj, GLint dim);

GLboolean fine_culling_test_2D(GLUnurbsObj *nobj, GLfloat *ctrl, GLint n_ctrl,
	GLint stride, GLint dim);

GLboolean fine_culling_test_3D(GLUnurbsObj *nobj, GLfloat *ctrl,
	GLint s_n_ctrl, GLint t_n_ctrl, GLint s_stride, GLint t_stride, GLint dim);

void do_nurbs_curve( GLUnurbsObj *nobj, GLint nknots, GLfloat *knot,
	GLint stride, GLfloat *ctlarray, GLint order, GLenum type );

void do_nurbs_surface( GLUnurbsObj *nobj);

