#include <stdio.h>
#include "config.h"
#include "unixlib.h"

#if defined(ATARI_ST)
#include <string.h>
#include <ext.h>

#elif defined(MSDOS) || defined(SUN) || defined(SEQUENT386) || defined(AVIION)
#include <sys/types.h>
#include <sys/stat.h>

#else
#error Wrong machine type. Edit config.h and follow the instructions.

#endif

#include "portab.h"
#include "picstat.h"

int log2(x)
int x;

{
  int i;

  for (i=0; i<16; i++)
    {
      if (x <= (1<<i))
        {
          return (i);
        }
    }
  return (0);
}


/*
 *  get_int()
 */

void get_int (fp, x)
FILE *fp;
int *x;

{
  int c;
  int sol;

  c = 0;
  while (!isdigit(c))
    {
      c = fgetc(fp);
      if (c == EOF)
        {
          *x = EOF;
          return;
        }
      if (sol && (c == '#'))
        {
          while (c != EOLN)
            {
              c = fgetc(fp);
              if (c == EOF)
                {
                  *x = EOF;
                  return;
                }
            }
        }
      sol = (c == EOLN);
    }
  *x = 0;
  while (isdigit(c))
    {
      *x *= 10;
      *x += c-'0';
      c = fgetc(fp);
      if (c == EOF)
        {
          *x = EOF;
          return;
        }
    }
}


/*
 *  return PBM stats of a file
 */

int pbmstat (name, buf, mode)
 char *name;
 struct picstat *buf;
 int mode;

{
  int ret;
  struct stat sbuf;
  FILE *fp;
  int i, j;
  int ncols;
  int high;
  char line[80];
  int type;
  

  if (mode)
    {
      ret = lstat (name, &sbuf);
    }
  else
    {
      ret = stat (name, &sbuf);
    }
  if (ret)
    {
      return (-1);
    }
  if ((fp = fopen (name, "rb")) == NULL)
    {
      return (-1);
    }
  if (fgets (line, 80, fp) == NULL)
    {
      fclose(fp);
      return (-1);
    }
  if (line[0] != 'P')
    {
      fclose(fp);
      return (-1);
    }
  type = line[1];
  get_int (fp, &(buf->p_sizex));
  get_int (fp, &(buf->p_sizey));
  get_int (fp, &high);
  if (fclose (fp))
    {
      return (-1);
    }
  buf->p_fsize = sbuf.st_size;
  buf->p_colrez = log2 (high);
  buf->p_nframes = 1;
  buf->p_speed = 0;
  buf->p_cols = NULL;
  switch (type)
    {
      case '1':
        {
          buf->p_ncol = 1<<buf->p_colrez;
          buf->p_coltype = CT_BW;
          strcpy (buf->p_type, "PBMasc");
          break;
        }
      case '2':
        {
          buf->p_ncol = 1<<buf->p_colrez;
          buf->p_coltype = CT_BW;
          strcpy (buf->p_type, "PGMasc");
          break;
        }
      case '3':
        {
          buf->p_colrez *= 3;
          buf->p_ncol = 1<<buf->p_colrez;
          buf->p_coltype = CT_COLOR;
          strcpy (buf->p_type, "PPMasc");
          break;
        }
      case '4':
        {
          buf->p_ncol = 1<<buf->p_colrez;
          buf->p_coltype = CT_BW;
          strcpy (buf->p_type, "PBMraw");
          break;
        }
      case '5':
        {
          buf->p_ncol = 1<<buf->p_colrez;
          buf->p_coltype = CT_BW;
          strcpy (buf->p_type, "PGMraw");
          break;
        }
      case '6':
        {
          buf->p_colrez *= 3;
          buf->p_ncol = 1<<buf->p_colrez;
          buf->p_coltype = CT_COLOR;
          strcpy (buf->p_type, "PPMraw");
          break;
        }
    }
  return (0);
}
