#include <stdio.h>
#include "config.h"
#include "unixlib.h"

#if defined(ATARI_ST)
#include <string.h>
#include <ext.h>

#elif defined (SUN) || defined(MSDOS) || defined(SEQUENT386) || defined(AVIION)
#include <sys/types.h>
#include <sys/stat.h>

#else
#error Wrong machine type. Edit config.h and follow the instructions.

#endif

#include "portab.h"
#include "picstat.h"


typedef struct
{
  ULONG h_fsize;
  UWORD h_magic;
  UWORD h_nframes;
  UWORD h_xsize;
  UWORD h_ysize;
  UWORD h_colrez;
  UWORD h_flags;
  UWORD h_speed;
} HEADBUF;


/*
 *  return FLI stats of a file
 */

int flistat (name, buf, mode)
 char *name;
 struct picstat *buf;
 int mode;

{
  int ret;
  struct stat sbuf;
  FILE *fp;
  UWORD length;
  unsigned long llength;
  HEADBUF headbuf;
  int i, j;

  if (mode)
    ret = lstat (name, &sbuf);
  else
    ret = stat (name, &sbuf);
  if (ret)
    return (-1);
  fp = fopen (name, "rb");
  if (fp == NULL)
    {
      return (-1);
    }
  if (sizeof(headbuf) != fread (&headbuf, 1L, sizeof(headbuf), fp))
    {
      fclose (fp);
      return (-1);
    }
  if (fclose (fp))
    {
      return (-1);
    }
  if ((headbuf.h_magic != 0x11af) && (headbuf.h_magic != 0x12af))
    {
      return (-1);
    }
  buf->p_fsize = sbuf.st_size;
  buf->p_sizex = SWAP2(headbuf.h_xsize);
  buf->p_sizey = SWAP2(headbuf.h_ysize);
  buf->p_colrez =  SWAP2(headbuf.h_colrez);
  buf->p_ncol = 1 << buf->p_colrez;
  buf->p_coltype = CT_UNKNOWN;
  buf->p_nframes = SWAP2(headbuf.h_nframes);
  buf->p_speed =SWAP2(headbuf.h_speed);
  strcpy (buf->p_type, "FLI");
  buf->p_cols = NULL;
  return (0);
}
