/* lfftoppm - convert .LFF -> PPM binary (P6) format
 *
 * Jon Leech 11/17/92
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "pixlib.h"

LFF_HDR Imagehdr;

char Usage[] = "%s [--] input-file [output-file]\n";
char *Example[] = {
    "\tlfftoppm converts a lucasfilm file to a PPM binary file.\n",
    "\n\tExample: lfftoppm image.lff image.ppm\n",
    NullPtr(char)
};

main (argc, argv)
int	argc;
char   *argv[];
{
    int  i, mode, status;
    char *lffname = NULL, *outname = NULL;
    RGBPIXEL *image;
    FILE *fp;

    for (i = 1; i < argc; i++) {
	if (!strcmp(argv[i],"--"))
	    userhelp(argv[0],Usage,Example);
	else {
	    if (lffname == NULL)
		lffname = argv[i];
	    else if (outname == NULL)
		outname = argv[i];
	    else
		userhelp(argv[0],Usage,Example);
	}
    }

    status = open_lff(lffname,&Imagehdr);
    if (status != LFF_OK)
	gr_bomb("Can't open %s, open_lff returns: %s\n",lffname,pixerrmess(status));

    /* Allocate memory for the image in core */
    i = Imagehdr.hdr_height * Imagehdr.hdr_width * sizeof(RGBPIXEL);
    image = (RGBPIXEL *)malloc(i);
    if (image == (RGBPIXEL *)NULL)
	gr_bomb("Failed to allocate %d bytes for incore buffer\n",i);

    /* Scan each tile in order and save in the incore buffer */
    {
	int i, j, vtiles,htiles;

	vtiles = Imagehdr.hdr_height / Imagehdr.hdr_tileheight;
	htiles = Imagehdr.hdr_width / Imagehdr.hdr_tilewidth;
	for (i = 0; i < vtiles; i++) {
	    int yoff = i * Imagehdr.hdr_tileheight;

	    for (j = 0; j < htiles; j++) {
		int y, xoff = j * Imagehdr.hdr_tilewidth;

		if (lff_seek_tile(i,j) != LFF_OK)
		    gr_bomb("Error reading tile %d, row %d, column %d\n",
			i*htiles+j,i,j);
		for (y = yoff; y < yoff+Imagehdr.hdr_tileheight; y++) {
		    int newy;
		    RGBPIXEL *ptr = &image[Imagehdr.hdr_width * y + xoff];

		    status = lff_read_line(ptr,&newy);
		    if (status != LFF_OK)
			gr_bomb("lff_read_line(y=%d) returns: %s\n",
			    newy,pixerrmess(status));
		}
	    }
	}
    }

    if (outname) {
	if (!(fp = fopen(outname, "w")))
	    gr_bomb("Can't write %s\n", outname);
    } else
	fp = stdout;

    /* Now write the image out in PPM binary format */
    fprintf(fp, "P6\n%d %d\n%d\n",
	Imagehdr.hdr_width,
	Imagehdr.hdr_height,
	255);			/* Max pixel value */

    {
	int pixels;
	RGBPIXEL *start, *end;

	pixels = Imagehdr.hdr_height * Imagehdr.hdr_width;
	start = image;
	end = &image[pixels];

	while (start < end) {
	    RGBPIXEL p = *start++;

	    putc(GETRED(p), fp);
	    putc(GETGRN(p), fp);
	    putc(GETBLU(p), fp);
	}
    }

    return 0;
}
